/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.installer;

import JWVFile.VFile;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.installer.InstallMainGUI;
import de.netcomputing.installer.Synchronizer;
import de.netcomputing.propertystore.beans.PropertyFileSel;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import netcomputing.tools.Platforms;

public class InstallMain
extends JPanel {
    JEditorPane htmlPane;
    JProgressBar fullProgress;
    JProgressBar fileProgress;
    JButton installBtn;
    JButton cancelBtn;
    PropertyFileSel dirTxt;
    int NUM_FILES = 1082;
    static String SHORTCUTDIR = "AnyJ4.0";
    int fullCount = 0;
    static /* synthetic */ Class class$com$incors$plaf$kunststoff$KunststoffLookAndFeel;

    public InstallMain() {
        Platforms.CheckPlatform();
        this.initGui();
    }

    public void initGui() {
        new InstallMainGUI().createGui(this);
        this.fullProgress.setMinimum(0);
        this.fullProgress.setMaximum(this.NUM_FILES);
        this.htmlPane.setText("<h2>Welcome to AnyJ " + NCApplication.Version + " Installation</h2>" + "Please choose the installation directory of AnyJ" + "<br><br><small>License information:<br>" + "The unregistered version of AnyJ can be used for non-commercial development and evaluation" + " only. <br> AnyJ does *not* expire, but starts to popup a warning after 3 month" + " of usage without license.<br></small>");
        if (File.separator.equals("\\")) {
            this.dirTxt.setText("C:\\AnyJ" + NCApplication.Version);
        } else {
            this.dirTxt.setText(System.getProperty("user.home", "/opt") + "/AnyJ4.1");
        }
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        System.exit(-1);
    }

    void extractFile(ZipFile zf, File target) throws IOException {
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            this.copyInputStream(zf, ze, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void copyInputStream(ZipFile zf, ZipEntry ze, File base) throws IOException {
        this.fullProgress.setValue(this.fullCount++);
        this.fullProgress.setString(ze.getName());
        this.fileProgress.setMinimum(0);
        this.fileProgress.setMaximum((int)ze.getSize());
        this.fileProgress.setValue(0);
        OutputStream out = null;
        try {
            if (!ze.getName().endsWith("/")) {
                String target = base.getAbsolutePath() + File.separator + ze.getName().replace('/', File.separatorChar);
                BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze), 20000);
                File tr = new File(target).getParentFile();
                boolean res = tr.mkdirs();
                Tracer.This.println("mkdirs:" + tr.getAbsolutePath() + " zename:" + ze.getName() + " res:" + res);
                out = new BufferedOutputStream(new FileOutputStream(target), 20000);
                int c = 0;
                int count = 0;
                while ((c = ((InputStream)in).read()) >= 0) {
                    out.write(c);
                    if (++count % 2000 != 0) continue;
                    this.fileProgress.setValue(count);
                }
            }
            Object var12_11 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public void installBtn_actionPerformed(ActionEvent var0) {
        Thread t = new Thread(){

            public void run() {
                try {
                    String dir = InstallMain.this.dirTxt.getText().trim();
                    if (dir.indexOf(" ") >= 0) {
                        JOptionPane.showMessageDialog(InstallMain.this, "Please select a directory *not* containing spaces (' ')");
                        InstallMain.this.installBtn.setEnabled(true);
                        return;
                    }
                    File outF = new File(dir);
                    outF.mkdirs();
                    Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, System.getProperty("java.class.path", ""));
                    String name = "";
                    int n = 0;
                    while (n < v.size()) {
                        String cur = v.elementAt(n).toString().toLowerCase();
                        Tracer.This.println("CP:" + cur);
                        if (cur.indexOf("anyj") >= 0) {
                            name = cur;
                        }
                        ++n;
                    }
                    if (name.length() == 0) {
                        JOptionPane.showMessageDialog(InstallMain.this, "Could not locate installerfile in the classpath " + System.getProperty("java.class.path", ""));
                        System.exit(-1);
                    }
                    Tracer.This.println("ASSUMING INSTALLER FILE NAME:" + name + ", rename if install fails");
                    ZipFile zf = new ZipFile(name);
                    ZipEntry ze = zf.getEntry("anyjdeploy.zip");
                    InstallMain.this.copyInputStream(zf, ze, outF);
                    zf.close();
                    zf = new ZipFile(outF.getAbsolutePath() + File.separator + "anyjdeploy.zip");
                    InstallMain.this.NUM_FILES = 0;
                    Enumeration<? extends ZipEntry> en = zf.entries();
                    while (en.hasMoreElements()) {
                        ++InstallMain.this.NUM_FILES;
                        en.nextElement();
                    }
                    InstallMain.this.fullProgress.setMaximum(InstallMain.this.NUM_FILES);
                    InstallMain.this.extractFile(zf, outF);
                    zf.close();
                    InstallMain.this.fullProgress.setString("Deleting temp files ..");
                    String base = outF.getAbsolutePath() + File.separator;
                    Synchronizer.This.buildZipMapFile(outF.getAbsolutePath() + File.separator + "anyjdeploy.zip", base + "bin" + File.separator + "files.txt");
                    new File(outF.getAbsolutePath() + File.separator + "anyjdeploy.zip").delete();
                    try {
                        File jarOutF = new File(base + "bin" + File.separator + "anyj.jar");
                        InstallMain.this.fullProgress.setString("building anyj.jar ..");
                        zf = new ZipFile(name);
                        JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(jarOutF));
                        int maxAJJarEntries = 0;
                        en = zf.entries();
                        while (en.hasMoreElements()) {
                            en.nextElement();
                            InstallMain.this.fileProgress.setMaximum(InstallMain.this.NUM_FILES);
                            ++maxAJJarEntries;
                        }
                        InstallMain.this.fileProgress.setMaximum(maxAJJarEntries);
                        int progCount = 0;
                        en = zf.entries();
                        while (en.hasMoreElements()) {
                            ZipEntry zen = en.nextElement();
                            if (zen.getName().endsWith("anyjdeploy.zip") || zen.getName().indexOf("META-INF") >= 0) continue;
                            jarOut.putNextEntry(new JarEntry(zen.getName()));
                            InputStream in = zf.getInputStream(zen);
                            int by = 0;
                            while ((by = in.read()) >= 0) {
                                jarOut.write(by);
                            }
                            jarOut.closeEntry();
                            if (++progCount % 10 != 0) continue;
                            InstallMain.this.fileProgress.setValue(progCount);
                        }
                        InstallMain.this.fileProgress.setValue(maxAJJarEntries);
                        zf.close();
                        jarOut.close();
                        Synchronizer.This.buildZipMapFile(base + "bin" + File.separator + "anyj.jar", base + "bin" + File.separator + "classes.txt");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        VFile.Copy(new File(name), new File(base + "bin" + File.separator + "anyj.jar"));
                    }
                    InstallMain.this.fullProgress.setValue(InstallMain.this.NUM_FILES);
                    try {
                        InstallMain.this.markAsUpgrade(base);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    InstallMain.this.fullProgress.setString("Creating shortcuts");
                    InstallMain.createWin32Shortcuts(base);
                    if (Platforms.IsLinux()) {
                        try {
                            FileOutputStream out = new FileOutputStream(System.getProperty("user.home") + "/bin/anyj");
                            PrintStream pout = new PrintStream(out);
                            pout.println("#!/bin/sh");
                            pout.println("cd " + dir + "/");
                            pout.println("sh ./anyj.sh");
                        }
                        catch (Throwable ex) {
                            System.out.println("failed to create startscript " + System.getProperty("user.home") + "/bin/anyj.sh");
                        }
                        Runtime.getRuntime().exec("chmod +x " + dir + "/bin/anyj.sh");
                        Runtime.getRuntime().exec("chmod +x " + System.getProperty("user.home") + "/bin/anyj");
                    }
                    JOptionPane.showMessageDialog(InstallMain.this, "Installation finished");
                    System.exit(0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(InstallMain.this, ex.getClass().getName() + ":" + ex.getMessage());
                }
            }
        };
        t.setPriority(1);
        this.installBtn.setEnabled(false);
        t.start();
    }

    public void markAsUpgrade(String installDir) {
        Platforms.CheckPlatform();
        String uhome = installDir;
        uhome = Platforms.IsWindows() ? uhome + File.separator + "anyj" : System.getProperty("user.home") + File.separator + "anyj";
        File f = new File(uhome);
        if (f.exists()) {
            try {
                FileOutputStream out = new FileOutputStream(new File(uhome, "upgrade"));
                out.write(NCApplication.Version.getBytes());
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void createWin32Shortcuts(String base) {
        try {
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "license.html " + "\"\\" + SHORTCUTDIR + "\\License.lnk\" " + "\"readme\" " + base + " " + "\"\" \"\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "readme.html " + "\"\\" + SHORTCUTDIR + "\\Readme.lnk\" " + "\"license\" " + base + " " + "\"\" \"\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "bin\\doc\\guide\\manual.html " + "\"\\" + SHORTCUTDIR + "\\Guide.lnk\" " + "\"Guide\" " + base + " " + "\"\" \"\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "bin\\doc\\tutorials\\debug_jsp.html " + "\"\\" + SHORTCUTDIR + "\\Tutorials\\Debugging Java Server Pages.lnk\" " + "\"Debugging Java Server Pages\" " + base + " " + "\"\" \"\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "bin\\doc\\tutorials\\gui_builder.html " + "\"\\" + SHORTCUTDIR + "\\Tutorials\\Debugging Java Server Pages.lnk\" " + "\"Debugging Java Server Pages\" " + base + " " + "\"\" \"\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "bin\\doc\\tutorials\\using_cvs.html " + "\"\\" + SHORTCUTDIR + "\\Tutorials\\Using CVS with AnyJ.lnk\" " + "\"Debugging Java Server Pages\" " + base + " " + "\"\" \"\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "bin\\doc\\tutorials\\workspace_from_scratch.html " + "\"\\" + SHORTCUTDIR + "\\Tutorials\\Creating a Workspace from Scratch.lnk\" " + "\"Debugging Java Server Pages\" " + base + " " + "\"\" \"\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "bin\\doc\\tutorials\\workspace_from_existing_source.html " + "\"\\" + SHORTCUTDIR + "\\Tutorials\\Creating a Workspace from existing Source.lnk\" " + "\"Debugging Java Server Pages\" " + base + " " + "\"\" \"\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "bin\\doc\\tutorials\\workspace_sharing_in_team.html " + "\"\\" + SHORTCUTDIR + "\\Tutorials\\Sharing Workspaces or part of them.lnk\" " + "\"Debugging Java Server Pages\" " + base + " " + "\"\" \"\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "bin\\doc\\tutorials\\gui_builder.html " + "\"\\" + SHORTCUTDIR + "\\Tutorials\\Using the GUI Builder.lnk\" " + "\"Using the GUI Builder\" " + base + " " + "\"\" \"\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "javadoc\\tutorial.html " + "\"\\" + SHORTCUTDIR + "\\Tutorials\\Scripting.lnk\" " + "\"Scripting AnyJ\" " + base + " " + "\"\" \"\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "bin\\jre\\bin\\java.exe " + "\"\\" + SHORTCUTDIR + "\\Start AnyJ (small projects).lnk\" " + "\"Start AnyJ\" " + base + "bin " + base + "bin\\streamredirect.exe " + "\"-noverify -Xms48m -Xmx48m -classpath anyj.jar editapp.EditApp\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "bin\\jre\\bin\\java.exe " + "\"\\" + SHORTCUTDIR + "\\Start AnyJ (medium projects).lnk\" " + "\"Start AnyJ\" " + base + "bin " + base + "bin\\streamredirect.exe " + "\"-noverify -Xms64m -Xmx64m -classpath anyj.jar editapp.EditApp\"");
            Runtime.getRuntime().exec(base + "bin" + File.separator + "mkshortcut.exe " + base + "bin\\jre\\bin\\java.exe " + "\"\\" + SHORTCUTDIR + "\\Start AnyJ (large projects).lnk\" " + "\"Start AnyJ\" " + base + "bin " + base + "bin\\streamredirect.exe " + "\"-noverify -Xms64m -Xmx96m -classpath anyj.jar editapp.EditApp\"");
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public static void main(String[] args) {
        try {
            try {
                UIManager.setLookAndFeel((class$com$incors$plaf$kunststoff$KunststoffLookAndFeel == null ? (class$com$incors$plaf$kunststoff$KunststoffLookAndFeel = InstallMain.class$("com.incors.plaf.kunststoff.KunststoffLookAndFeel")) : class$com$incors$plaf$kunststoff$KunststoffLookAndFeel).getName());
            }
            catch (Exception ex) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        InstallMain mn = new InstallMain();
        JFrame fr = ApplicationHelper.Singleton().createFrameOn(mn);
        ApplicationHelper.Singleton().centerWindow(fr);
        fr.setResizable(false);
        fr.show();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

