/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.modeller;

import de.netcomputing.modeller.BasicSaver;
import de.netcomputing.modeller.IModellerContext;
import de.netcomputing.modeller.model.IDataModel;
import de.netcomputing.modeller.model.IDataModelConnection;
import de.netcomputing.modeller.model.IDataModelEntity;
import de.netcomputing.modeller.model.IDataModelNode;
import de.netcomputing.modeller.model.MetaModel;
import de.netcomputing.util.stringpersistance.NCStringMapper;
import de.netcomputing.util.xml.Node;
import de.netcomputing.util.xml.XMLIterator;
import java.awt.Rectangle;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultSaver
extends BasicSaver {
    int saveIdCount = 0;
    static /* synthetic */ Class class$java$awt$Rectangle;

    public void saveModel(IDataModel model, OutputStream outs) throws Exception {
        PrintStream out = new PrintStream(outs);
        List l = model.getDataEntities();
        out.println("<Model meta=\"" + model.getMetaModelName() + "\">");
        Rectangle bounds = null;
        int i = 0;
        while (i < l.size()) {
            IDataModelEntity assoc = (IDataModelEntity)l.get(i);
            assoc.setID(this.saveIdCount++);
            bounds = assoc.getModelBounds();
            out.print("    <" + assoc.getMetaSpec().getField("name"));
            out.print(" bounds=\"" + NCStringMapper.This().encode(bounds) + "\"");
            out.print(" linkid=\"" + assoc.getID() + "\"");
            out.println(">");
            out.println("        <Properties>");
            this.dumpProps(out, "            ", assoc.getProperties());
            out.println("        </Properties>");
            int ii = 0;
            while (ii < assoc.getAttributes().size()) {
                out.println("        <Attribute>");
                this.dumpProps(out, "            ", ((IDataModelNode)assoc.getAttributes().get(ii)).getProperties());
                out.println("        </Attribute>");
                ++ii;
            }
            int ii2 = 0;
            while (ii2 < assoc.getMethods().size()) {
                out.println("        <Method>");
                this.dumpProps(out, "            ", ((IDataModelNode)assoc.getMethods().get(ii2)).getProperties());
                out.println("        </Method>");
                ++ii2;
            }
            out.println("    </" + assoc.getMetaSpec().getField("name") + ">");
            ++i;
        }
        List assocs = model.getDataConnections();
        int i2 = 0;
        while (i2 < assocs.size()) {
            IDataModelConnection ass = (IDataModelConnection)assocs.get(i2);
            out.println("    <Link name=\"" + ass.getMetaSpec().getField("name") + "\">");
            ass.getProperties().put("rightid", "" + ass.getRightEntity().getID());
            ass.getProperties().put("leftid", "" + ass.getLeftEntity().getID());
            this.dumpProps(out, "        ", ass.getProperties());
            out.println("    </Link>");
            ++i2;
        }
        out.println("</Model>");
    }

    public void loadModel(IModellerContext modeller, Node dataFile) throws Exception {
        HashMap<Integer, IDataModelEntity> linkIdToModel = new HashMap<Integer, IDataModelEntity>();
        MetaModel model = modeller.getMetaModel();
        int i = 0;
        while (i < dataFile.getSubnodeCount()) {
            Node n = (Node)dataFile.getSubnode(i);
            String entityType = n.getName();
            if (entityType.equals("Link")) {
                int leftID = n.getIntField("leftid.content");
                int rightID = n.getIntField("rightid.content");
                String metaNodeName = n.getField("name");
                Node entity = model.findConnection(metaNodeName);
                HashMap props = this.nodeToHMap(n.getSubnodes(), n);
                String shape = entity.getField("shape");
                IDataModelEntity left = (IDataModelEntity)linkIdToModel.get(new Integer(leftID));
                IDataModelEntity right = (IDataModelEntity)linkIdToModel.get(new Integer(rightID));
                modeller.addConnection(entity, shape, right, left, props);
            } else {
                Node entity = model.findEntity(entityType);
                if (entity == null) {
                    throw new RuntimeException("Unknown Entity:" + entityType + " File does not match meta information");
                }
                Rectangle bounds = (Rectangle)NCStringMapper.This().decode(class$java$awt$Rectangle == null ? DefaultSaver.class$("java.awt.Rectangle") : class$java$awt$Rectangle, n.getField("bounds", "0,0,100,100"));
                String label = n.getField(entity.getField("labelproperty", "Name"));
                HashMap props = this.nodeToHMap(n.getSubnode("Properties").getSubnodes(), n);
                props.remove("linkid");
                props.remove("bounds");
                IDataModelEntity ass = modeller.addEntity(entity, label, bounds, props);
                ass.setID(n.getIntField("linkid"));
                linkIdToModel.put(new Integer(ass.getID()), ass);
                XMLIterator attributes = n.getSubnodes("Attribute");
                while (attributes.hasMoreElements()) {
                    Node attNode = (Node)attributes.nextElement();
                    modeller.addAttribute(ass, this.nodeToHMap(attNode.getSubnodes(), attNode));
                }
                XMLIterator methods = n.getSubnodes("Method");
                while (methods.hasMoreElements()) {
                    Node methNode = (Node)methods.nextElement();
                    modeller.addMethod(ass, this.nodeToHMap(methNode.getSubnodes(), methNode));
                }
                modeller.updateView(ass);
            }
            ++i;
        }
    }

    public void dumpProps(PrintStream out, String off, Map props) {
        Iterator it = props.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            String val = (String)props.get(key);
            if (val == null || val.length() <= 0) continue;
            out.println(off + "<" + key + ">" + this.quoteString(val) + "</" + key + ">");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

