/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.modeller;

import JWVFile.VFile;
import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.application.IAJDocument;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.ObjectValue;
import de.netcomputing.anyj.jwidgets.StringValue;
import de.netcomputing.modeller.DefaultSaver;
import de.netcomputing.modeller.IModellerContext;
import de.netcomputing.modeller.MetaModelSaver;
import de.netcomputing.modeller.ModelAssoc;
import de.netcomputing.modeller.ModelWithPropsPanelGUI;
import de.netcomputing.modeller.ModellerAssociation;
import de.netcomputing.modeller.ModellerEntity;
import de.netcomputing.modeller.ModellerPanel;
import de.netcomputing.modeller.ModellerProps;
import de.netcomputing.modeller.editors.AddConnectionInspector;
import de.netcomputing.modeller.editors.AddEntityEditor;
import de.netcomputing.modeller.model.IDataModel;
import de.netcomputing.modeller.model.IDataModelConnection;
import de.netcomputing.modeller.model.IDataModelEntity;
import de.netcomputing.modeller.model.IDataModelSaver;
import de.netcomputing.modeller.model.IMetaModelLocator;
import de.netcomputing.modeller.model.MetaModel;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import de.netcomputing.util.xml.Node;
import de.netcomputing.util.xml.XMLIterator;
import de.netcomputing.util.xml.XmlReader;
import editapp.EditApp;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.print.PrintService;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import layedit.LayoutableComponent;
import netcomputing.collections.INCTarget;

public class ModelWithPropsPanel
extends JPanel
implements INCTarget,
IDataModel,
IMetaModelLocator,
IModellerContext,
IAJDocument {
    JSlider ratioZoomer;
    JCheckBox landScape;
    JComboBox printerCombo;
    JButton printBtn;
    JButton saveAsBtn;
    JSlider zoomer;
    JButton loadBtn;
    JScrollPane scrollPane;
    ModellerPanel modeller;
    JButton saveBtn;
    JLabel statusLabel;
    JSplitPane split;
    ModellerProps props;
    MetaModel model;
    HashMap diagramProps = new HashMap();
    Node activeEntityRoot;
    Map activeProps;
    LayoutableComponent[] sel;
    LayoutableComponent lastSingleSel;
    ModellerAssociation selAssoc;
    File dataFile;
    IDataModelSaver saver = new DefaultSaver();
    float printRatio = 0.7f;
    static /* synthetic */ Class class$de$netcomputing$modeller$entities$ProcessEntity;
    static /* synthetic */ Class class$de$netcomputing$modeller$entities$DataBaseEntity;
    static /* synthetic */ Class class$de$netcomputing$modeller$entities$ImageEntity;
    static /* synthetic */ Class class$de$netcomputing$modeller$entities$ConnectionMetaEntity;
    static /* synthetic */ Class class$de$netcomputing$modeller$entities$RoundBorderEntity;

    public static ModelWithPropsPanel Open(File f) {
        JDialog dg = new JDialog(EditApp.App.getMainWindow(), "DBModeller:" + f.getAbsolutePath());
        ModelWithPropsPanel mf = new ModelWithPropsPanel();
        dg.getContentPane().add(mf);
        dg.setBounds(0, 0, 800, 600);
        mf.load(f);
        dg.show();
        return mf;
    }

    public static ModelWithPropsPanel OpenInFrame(String title, File f) {
        JFrame dg = new JFrame(title);
        ModelWithPropsPanel mf = new ModelWithPropsPanel();
        dg.getContentPane().add(mf);
        dg.setBounds(0, 0, 800, 600);
        mf.load(f);
        dg.show();
        return mf;
    }

    public ModelWithPropsPanel() {
        this.initGui();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ModelWithPropsPanel.this.props.doLayout();
            }
        });
        this.props = new ModellerProps();
        this.props.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setViewportView(this.props);
        this.split.setLeftComponent(this.modeller);
        this.split.setRightComponent(this.scrollPane);
        this.split.setResizeWeight(1.0);
        this.split.setContinuousLayout(true);
        this.split.setDividerLocation(1100);
        this.modeller.binder().addTarget(this, "actionModellerEvent");
        this.props.setKeyHook(this);
        this.fillPrinterCombos();
        this.model = new MetaModel();
        this.ratioZoomer.setValue((int)(this.modeller.getBopRoot().getPrintRatio() * 100.0f));
    }

    public ModellerPanel getModeller() {
        return this.modeller;
    }

    public void action(String selector, Object arg, Object sender) {
        KeyEvent ev = (KeyEvent)arg;
        if (ev.getKeyCode() == 10 && ev.getID() == 401) {
            this.setInspector();
        }
    }

    Node getActMethodRoot() {
        return (Node)this.activeEntityRoot.getSubnode("Method");
    }

    Node getActAttribRoot() {
        return (Node)this.activeEntityRoot.getSubnode("Attribute");
    }

    public Object actionModellerEvent(Object arg, Object sen) {
        System.out.println("arg:" + arg);
        if (arg instanceof StringValue) {
            String action = ((StringValue)arg).stringValue();
            if (action.equals("delete")) {
                ModellerAssociation con;
                this.props.clear();
                this.sel = this.modeller.getSelectedComponents();
                if (this.sel.length > 1) {
                    this.modeller.deleteSelected();
                } else if (this.sel.length == 1) {
                    ModellerEntity en = (ModellerEntity)this.sel[0].getWrappedBop();
                    ModelAssoc ass = (ModelAssoc)this.sel[0].getAssocObject();
                    int[] attsel = en.getAttribs().getSelectedIndices();
                    int[] methsel = en.getMethods().getSelectedIndices();
                    if (attsel == null || attsel.length == 0) {
                        if (methsel == null || methsel.length == 0) {
                            this.modeller.deleteSelected();
                        } else if (methsel.length >= 1) {
                            en.removeSelected();
                        }
                    } else if (attsel.length >= 1) {
                        en.removeSelected();
                    } else {
                        this.props.clear();
                        this.props.repaint();
                        this.activeProps = null;
                    }
                } else if (this.sel.length == 0 && (con = (ModellerAssociation)this.modeller.getSelectedConnections()) != null) {
                    this.modeller.getAssocs().remAssoc(con);
                    this.modeller.repaint();
                }
                this.props.invalidate();
                this.props.validate();
                this.props.repaint();
            }
            return null;
        }
        ObjectValue val = (ObjectValue)arg;
        if (val.value() instanceof Object[]) {
            System.out.println("type:" + ((Object[])val.value())[0]);
            System.out.println("arg :" + ((Object[])val.value())[1]);
        } else {
            System.out.println("selection event");
            this.setInspector();
        }
        return null;
    }

    public void setInspector() {
        if (this.activeProps != null) {
            this.props.readProperties(this.activeProps);
            if (this.selAssoc != null) {
                this.selAssoc.applyProperties();
            } else {
                int i = 0;
                while (i < this.sel.length) {
                    ((ModellerEntity)this.sel[i].getWrappedBop()).readAssoc();
                    ++i;
                }
            }
        }
        this.sel = this.modeller.getSelectedComponents();
        this.selAssoc = null;
        if (this.sel.length == 1) {
            this.lastSingleSel = this.sel[0];
            this.props.clear();
            ModellerEntity en = (ModellerEntity)this.sel[0].getWrappedBop();
            ModelAssoc ass = (ModelAssoc)this.sel[0].getAssocObject();
            this.activeEntityRoot = ass.getMetaSpec();
            int[] attsel = en.getAttribs().getSelectedIndices();
            int[] methsel = en.getMethods().getSelectedIndices();
            if (attsel == null || attsel.length == 0) {
                if (methsel == null || methsel.length == 0) {
                    this.activeProps = ass.getProperties();
                    this.props.buildInspector(this.activeEntityRoot, (IModellerContext)this);
                } else if (methsel.length == 1) {
                    this.activeProps = (HashMap)ass.getMethProps().get(methsel[0]);
                    this.props.buildInspector(this.getActMethodRoot(), (IModellerContext)this);
                }
            } else if (attsel.length == 1) {
                this.activeProps = (HashMap)ass.getAttProps().get(attsel[0]);
                this.props.buildInspector(this.getActAttribRoot(), (IModellerContext)this);
            } else {
                this.props.clear();
                this.props.repaint();
                this.activeProps = null;
            }
            this.props.invalidate();
            this.props.validate();
            this.props.repaint();
        } else if (this.sel.length == 2) {
            if (this.sel[0] == this.lastSingleSel) {
                this.sel[0] = this.sel[1];
                this.sel[1] = this.lastSingleSel;
            }
            this.props.clear();
            XMLIterator it = this.model.getConnections();
            while (it.hasMoreElements()) {
                Node connMeta = (Node)it.nextElement();
                String lshape = connMeta.getField("Left.Allow.content");
                String rshape = connMeta.getField("Right.Allow.content");
                boolean leftUnique = connMeta.getBooleanField("Left.unique", false);
                boolean rightUnique = connMeta.getBooleanField("Right.unique", false);
                HashSet lSet = new HashSet(NCStringUtilities.SplitSeparatedString(",", lshape));
                HashSet rSet = new HashSet(NCStringUtilities.SplitSeparatedString(",", rshape));
                if (lshape != null && !lSet.contains(((ModelAssoc)this.sel[0].getAssocObject()).getMetaSpec().getField("name")) || rshape != null && !rSet.contains(((ModelAssoc)this.sel[1].getAssocObject()).getMetaSpec().getField("name"))) continue;
                boolean showAddEditor = true;
                if (leftUnique && rightUnique) {
                    showAddEditor = this.modeller.getAssocs().findAssoc(this.sel[0], this.sel[1], connMeta) == null;
                } else if (leftUnique) {
                    showAddEditor = this.modeller.getAssocs().findAssoc(this.sel[0], null, connMeta) == null;
                } else if (rightUnique) {
                    boolean bl = showAddEditor = this.modeller.getAssocs().findAssoc(null, this.sel[1], connMeta) == null;
                }
                if (!showAddEditor) continue;
                AddConnectionInspector ed = new AddConnectionInspector((ModellerEntity)this.sel[0].getWrappedBop(), (ModellerEntity)this.sel[1].getWrappedBop());
                this.props.addPropEditor(ed);
                ed.setLabel(connMeta.getField("name", "unnamed"));
                ed.setDescription(connMeta.getField("Description.content"));
                ed.setContext(this);
                ((AddEntityEditor)ed).initialize(connMeta);
                ed.setEntitySpec(connMeta);
                ed.doLayout();
            }
            this.props.init();
            this.props.invalidate();
            this.props.validate();
            this.props.repaint();
            this.activeProps = null;
        } else if (this.sel.length == 0) {
            ModellerAssociation con = (ModellerAssociation)this.modeller.getSelectedConnections();
            if (con != null) {
                this.selAssoc = con;
                this.props.clear();
                this.activeProps = con.getProperties();
                this.props.buildInspector(con.getMetaSpec(), (IModellerContext)this);
                this.props.invalidate();
                this.props.validate();
                this.props.repaint();
            } else {
                this.props.clear();
                this.activeProps = this.diagramProps;
                this.props.buildInspector(this.model.getRoot(), (IModellerContext)this);
                this.props.invalidate();
                this.props.validate();
                this.props.repaint();
            }
        } else {
            this.props.clear();
            this.props.repaint();
            this.activeProps = null;
        }
        if (this.activeProps != null) {
            this.props.setProperties(this.activeProps);
            this.props.requestFocus();
        }
    }

    public void initGui() {
        new ModelWithPropsPanelGUI().createGui(this);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    void save(File f) {
        try {
            FileOutputStream fout = new FileOutputStream(f);
            this.saver.saveModel(this, fout);
            fout.close();
            FileOutputStream fout1 = new FileOutputStream(new File(f.getParentFile(), "tryst.xml"));
            new MetaModelSaver().saveModel(this, fout1);
            this.saver.saveModel(this, fout);
            fout.close();
            fout1.close();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            Confirm.MsgException(ex);
        }
    }

    public void loadMetaModel(File f) {
        try {
            this.model.loadMetaModel(f);
            this.diagramProps = new HashMap();
            this.modeller.reset();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            Confirm.MsgException(ex);
        }
    }

    public List getEntities() {
        return this.modeller.getEntities();
    }

    public ModelAssoc getCurrentEntityAssoc() {
        return this.modeller.getCurrentEntityAssoc();
    }

    public IDataModelEntity addEntity(Node entity, String label, Rectangle bounds, Map properties) {
        ModellerEntity me2 = ModellerEntity.createFromSpec(entity, label);
        ModelAssoc ass = new ModelAssoc();
        ass.setMetaSpec(entity);
        ass.setProperties(properties);
        LayoutableComponent comp = this.modeller.addNewComponent(me2, ass, false);
        comp.setBoundsBop(bounds.x, bounds.y, bounds.width, bounds.height);
        me2.clearAttribsAndMethods();
        return ass;
    }

    public void addAttribute(IDataModelEntity entity, Map props) {
        ((ModelAssoc)entity).addAttrib(props);
    }

    public void addMethod(IDataModelEntity entity, Map props) {
        ((ModelAssoc)entity).addMethod(props);
    }

    public void updateView(IDataModelEntity entity) {
        ((ModellerEntity)((ModelAssoc)entity).getComp().getWrappedBop()).readAssoc();
    }

    public IDataModelConnection addConnection(Node entity, String shape, IDataModelEntity right, IDataModelEntity left, Map props) {
        ModellerAssociation modelAssoc = new ModellerAssociation((ModellerEntity)((ModelAssoc)left).getComp().getWrappedBop(), (ModellerEntity)((ModelAssoc)right).getComp().getWrappedBop(), shape, "", "");
        modelAssoc.setMeta(entity);
        modelAssoc.setProperties(props);
        this.modeller.getAssocs().addAssoc(modelAssoc);
        modelAssoc.applyProperties();
        return modelAssoc;
    }

    public MetaModel getMetaModel() {
        return this.model;
    }

    public File findMetaModel(File dataFile, Node dataRoot) {
        String modelFileName = dataRoot.getField("meta", "DBModel.xml");
        File modelFile = new File(dataFile.getParentFile(), modelFileName);
        if (!modelFile.exists()) {
            modelFile = new VFile("#models/" + modelFileName);
        }
        return modelFile;
    }

    public List getDataEntities() {
        return this.modeller.getEntities();
    }

    public List getDataConnections() {
        return this.modeller.getAssocs().getAssociations();
    }

    public String getMetaModelName() {
        return this.model.getName();
    }

    public File getFile() {
        return this.dataFile;
    }

    void setFile(File f) {
        this.dataFile = f;
    }

    public void load(File f) {
        try {
            this.setFile(f);
            FileInputStream in = new FileInputStream(f);
            Node dataFile = (Node)new XmlReader().read(in);
            in.close();
            this.loadMetaModel(this.findMetaModel(f, dataFile));
            this.saver.loadModel(this, dataFile);
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            Confirm.MsgException(ex);
        }
    }

    public void fillPrinterCombos() {
        this.printerCombo.setEnabled(false);
        this.landScape.setEnabled(false);
        new Thread(){

            public void run() {
                PrintService[] ps = PrinterJob.lookupPrintServices();
                if (ps == null) {
                    ModelWithPropsPanel.this.printerCombo.setEnabled(false);
                    ModelWithPropsPanel.this.landScape.setEnabled(false);
                    return;
                }
                int i = 0;
                while (i < ps.length) {
                    ModelWithPropsPanel.this.printerCombo.addItem(ps[i].getName());
                    ++i;
                }
                PrintService def = PrinterJob.getPrinterJob().getPrintService();
                if (def == null) {
                    ModelWithPropsPanel.this.printerCombo.setEnabled(false);
                    ModelWithPropsPanel.this.landScape.setEnabled(false);
                    return;
                }
                ModelWithPropsPanel.this.printerCombo.setSelectedItem(def.getName());
                ModelWithPropsPanel.this.printerCombo.setEnabled(true);
                ModelWithPropsPanel.this.landScape.setEnabled(true);
            }
        }.start();
    }

    public void ratioZoomer_stateChanged(ChangeEvent var0) {
        this.modeller.getBopRoot().setPrintRatio((float)this.ratioZoomer.getValue() / 100.0f);
        this.modeller.repaint();
    }

    public void updatePageFormat() {
        try {
            PrintService[] ps = PrinterJob.lookupPrintServices();
            PrintService target = null;
            int i = 0;
            while (i < ps.length) {
                if (ps[i].getName().equals("" + this.printerCombo.getSelectedItem())) {
                    target = ps[i];
                }
                ++i;
            }
            if (target == null) {
                this.modeller.setPageFormat(null);
                return;
            }
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintService(target);
            PageFormat f = job.defaultPage();
            f.setOrientation(this.landScape.isSelected() ? 0 : 1);
            this.modeller.setPageFormat(f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.repaint();
    }

    public void landScape_actionPerformed(ActionEvent var0) {
        this.updatePageFormat();
    }

    public void formatCombo_actionPerformed(ActionEvent var0) {
        this.updatePageFormat();
    }

    public void printerCombo_actionPerformed(ActionEvent var0) {
        this.updatePageFormat();
    }

    public void printBtn_actionPerformed(ActionEvent var0) {
        try {
            PrintService[] ps = PrinterJob.lookupPrintServices();
            PrintService target = null;
            int i = 0;
            while (i < ps.length) {
                if (ps[i].getName().equals("" + this.printerCombo.getSelectedItem())) {
                    target = ps[i];
                }
                ++i;
            }
            if (target == null) {
                this.modeller.setPageFormat(null);
                return;
            }
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintService(target);
            final PageFormat f = job.defaultPage();
            f.setOrientation(this.landScape.isSelected() ? 0 : 1);
            this.modeller.setPageFormat(f);
            Pageable pg = new Pageable(){

                public int getNumberOfPages() {
                    return 1;
                }

                public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
                    return f;
                }

                public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
                    return ModelWithPropsPanel.this.modeller;
                }
            };
            job.setCopies(1);
            job.setJobName("MetaModeller:" + this.getFile().getName());
            job.setPrintable(this.modeller);
            job.setPageable(pg);
            job.print();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Confirm.MsgException(ex);
        }
    }

    public void saveAsBtn_actionPerformed(ActionEvent var0) {
        File file2 = AJDirSelector.SelectDirModal((Window)this.getTopLevelAncestor(), null, "Save As File", null, this.getFile().getAbsolutePath());
        if (file2 != null) {
            this.setFile(file2);
            this.save(this.getFile());
        }
    }

    public void zoomer_stateChanged(ChangeEvent var0) {
        this.modeller.setScale((float)this.zoomer.getValue() / 100.0f);
    }

    public void loadBtn_actionPerformed(ActionEvent var0) {
        File file2 = AJDirSelector.SelectDirModal((Window)this.getTopLevelAncestor(), null, "Open File", null, this.getFile().getAbsolutePath());
        if (file2 != null) {
            this.setFile(file2);
            this.load(this.getFile());
        }
    }

    public void saveBtn_actionPerformed(ActionEvent var0) {
        this.save(this.getFile());
    }

    public void assocBtn_actionPerformed(ActionEvent var0) {
    }

    public void tableBtn_actionPerformed(ActionEvent var0) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JFrame f = new JFrame();
        ModelWithPropsPanel mf = new ModelWithPropsPanel();
        f.getContentPane().add(mf);
        if (args != null && args.length > 0) {
            mf.setFile(new File(args[0]));
        }
        mf.load(mf.getFile());
        f.pack();
        f.setSize(1424, 1100);
        f.show();
        f.setDefaultCloseOperation(3);
    }

    public String getTitle() {
        return this.getFile().getName();
    }

    public void save() {
        this.saveAsBtn_actionPerformed(null);
    }

    public boolean isSaved() {
        return false;
    }

    public JComponent getComponent() {
        return this;
    }

    public void notifyClose() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ModellerEntity.RegisterEntityClass("Process", class$de$netcomputing$modeller$entities$ProcessEntity == null ? (class$de$netcomputing$modeller$entities$ProcessEntity = ModelWithPropsPanel.class$("de.netcomputing.modeller.entities.ProcessEntity")) : class$de$netcomputing$modeller$entities$ProcessEntity);
        ModellerEntity.RegisterEntityClass("DB", class$de$netcomputing$modeller$entities$DataBaseEntity == null ? (class$de$netcomputing$modeller$entities$DataBaseEntity = ModelWithPropsPanel.class$("de.netcomputing.modeller.entities.DataBaseEntity")) : class$de$netcomputing$modeller$entities$DataBaseEntity);
        ModellerEntity.RegisterEntityClass("Image", class$de$netcomputing$modeller$entities$ImageEntity == null ? (class$de$netcomputing$modeller$entities$ImageEntity = ModelWithPropsPanel.class$("de.netcomputing.modeller.entities.ImageEntity")) : class$de$netcomputing$modeller$entities$ImageEntity);
        ModellerEntity.RegisterEntityClass("ConnectionMeta", class$de$netcomputing$modeller$entities$ConnectionMetaEntity == null ? (class$de$netcomputing$modeller$entities$ConnectionMetaEntity = ModelWithPropsPanel.class$("de.netcomputing.modeller.entities.ConnectionMetaEntity")) : class$de$netcomputing$modeller$entities$ConnectionMetaEntity);
        ModellerEntity.RegisterEntityClass("RoundRect", class$de$netcomputing$modeller$entities$RoundBorderEntity == null ? (class$de$netcomputing$modeller$entities$RoundBorderEntity = ModelWithPropsPanel.class$("de.netcomputing.modeller.entities.RoundBorderEntity")) : class$de$netcomputing$modeller$entities$RoundBorderEntity);
    }
}

