/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.modeller;

import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.modeller.IModellerContext;
import de.netcomputing.modeller.IModellerPropEditor;
import de.netcomputing.modeller.NodeEvaluator;
import de.netcomputing.modeller.editors.AddAttributeEditor;
import de.netcomputing.modeller.editors.AddEntityEditor;
import de.netcomputing.modeller.editors.AddMethodEditor;
import de.netcomputing.modeller.editors.BooleanEditor;
import de.netcomputing.modeller.editors.ManyOfManyEditor;
import de.netcomputing.modeller.editors.OneOfManyEditor;
import de.netcomputing.modeller.editors.OtherAttributeEditor;
import de.netcomputing.modeller.editors.OtherAttributesEditor;
import de.netcomputing.modeller.editors.OtherEntitiesEditor;
import de.netcomputing.modeller.editors.OtherEntityEditor;
import de.netcomputing.modeller.editors.PathPropertyEditor;
import de.netcomputing.modeller.editors.StringEditor;
import de.netcomputing.modeller.editors.TextPropertyEditor;
import de.netcomputing.util.Tracer;
import de.netcomputing.util.xml.Node;
import de.netcomputing.util.xml.XMLIterator;
import de.netcomputing.util.xml.XmlReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import netcomputing.collections.INCTarget;

public class ModellerProps
extends JPanel
implements INCTarget {
    ArrayList props = new ArrayList(20);
    int maxLab = 0;
    INCTarget keyHook;

    public void init() {
        this.setLayout(null);
        int i = 0;
        while (i < this.props.size()) {
            IModellerPropEditor ed = (IModellerPropEditor)this.props.get(i);
            JLabel label = new JLabel(ed.getLabel());
            int w = label.getPreferredSize().width;
            if (this.maxLab < w) {
                this.maxLab = w;
            }
            this.add(label);
            this.add(ed.getEditorComponent());
            ++i;
        }
        Vector v = new Vector(50);
        JWidgetsUtil.AllComponents(v, this);
        int i2 = 0;
        while (i2 < v.size()) {
            ((Component)v.get(i2)).addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (ModellerProps.this.keyHook != null) {
                        ModellerProps.this.keyHook.action("keyEvent", e, this);
                    }
                }
            });
            ++i2;
        }
    }

    public void action(String selector, Object arg, Object sender) {
        HashMap map = new HashMap();
        this.readProperties(map);
        this.validateProperties(map);
    }

    public void setKeyHook(INCTarget keyHook) {
        this.keyHook = keyHook;
    }

    public INCTarget getKeyHook() {
        return this.keyHook;
    }

    public void doLayout() {
        Dimension d = this.getSize();
        if (this.getParent().getParent() instanceof JScrollPane) {
            d = new Dimension(this.getParent().getWidth() - 6, d.height);
        }
        int y = 0;
        int i = 0;
        while (i < this.getComponentCount()) {
            JLabel lab = (JLabel)this.getComponent(i);
            JComponent prop = (JComponent)this.getComponent(i + 1);
            int propH = prop.getPreferredSize().height;
            lab.setBounds(2, y, this.maxLab, propH);
            int gap = 8;
            prop.setBounds(this.maxLab + 8, y, Math.max(30, d.width - this.maxLab - 16), propH);
            y += propH + 2;
            i += 2;
        }
    }

    public Dimension getMinimumSize() {
        Dimension d = this.getSize();
        int y = 0;
        int i = 0;
        while (i < this.getComponentCount()) {
            JLabel lab = (JLabel)this.getComponent(i);
            JComponent prop = (JComponent)this.getComponent(i + 1);
            int propH = prop.getPreferredSize().height;
            y += propH + 2;
            i += 2;
        }
        d.height = y;
        return d;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void addPropEditor(IModellerPropEditor ed) {
        this.props.add(ed);
        ed.setChangeListener(this);
    }

    public void clear() {
        this.props.clear();
        this.removeAll();
    }

    public void buildInspector(File f, IModellerContext ctx) {
        try {
            FileInputStream in = new FileInputStream(f);
            Node node = (Node)new XmlReader().read(in);
            this.buildInspector(node, ctx);
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            Confirm.MsgException(ex);
        }
    }

    public Node findEntitySpec(Node entityDescroot, String name) {
        XMLIterator it = entityDescroot.getSubnodes("Entity");
        while (it.hasMoreElements()) {
            Node prop = (Node)it.nextElement();
            if (!prop.getField("name", "").equals(name)) continue;
            return prop;
        }
        return null;
    }

    public void buildInspector(Node entityDescroot, IModellerContext ctx) {
        Node tmpNode;
        int i = entityDescroot.getSubnodeCount("Property");
        XMLIterator it = null;
        if (i > 0) {
            it = entityDescroot.getSubnodes("Property");
            this.buildInspectorInternal(entityDescroot, it, ctx);
        }
        if ((tmpNode = (Node)entityDescroot.getSubnode("Properties")) != null) {
            it = tmpNode.getSubnodes("Property");
            i = tmpNode.getSubnodeCount("Property");
            if (i > 0) {
                this.buildInspectorInternal(entityDescroot, it, ctx);
            }
        }
        this.init();
    }

    void buildInspectorInternal(Node entityDescroot, XMLIterator it, IModellerContext ctx) {
        while (it != null && it.hasMoreElements()) {
            Node prop = (Node)it.nextElement();
            String type = prop.getField("type", "String");
            IModellerPropEditor ed = this.createEditor(type, prop);
            if (ed == null) continue;
            ed.setLabel(prop.getField("name", "unnamed"));
            ed.setDescription(prop.getField("Description.content"));
            ed.setContext(ctx);
            String defaultVal = prop.getField("default");
            if (defaultVal != null) {
                ed.setPropValue(defaultVal);
            }
            ed.setMeta(prop);
            ed.initialize(prop);
            if (ed instanceof AddEntityEditor) {
                ((AddEntityEditor)ed).setEntitySpec(this.findEntitySpec(entityDescroot, prop.getField("EntityType.content", prop.getField("name"))));
            }
            this.addPropEditor(ed);
        }
    }

    public void readProperties(Map map) {
        int i = 0;
        while (i < this.props.size()) {
            IModellerPropEditor ed = (IModellerPropEditor)this.props.get(i);
            map.put(ed.getLabel(), ed.getPropValue());
            ++i;
        }
    }

    public void setProperties(Map map) {
        int i = 0;
        while (i < this.props.size()) {
            IModellerPropEditor ed = (IModellerPropEditor)this.props.get(i);
            Object val = map.get(ed.getLabel());
            if (val == null) {
                val = "";
            }
            ed.setPropValue("" + val);
            ++i;
        }
        this.validateProperties(map);
    }

    public void requestFocus() {
        if (this.getComponentCount() > 1) {
            this.getComponent(1).requestFocus();
        }
    }

    public void validateProperties(Map map) {
        int i = 0;
        while (i < this.props.size()) {
            IModellerPropEditor ed = (IModellerPropEditor)this.props.get(i);
            Node meta = ed.getMeta();
            Node eq = (Node)meta.getSubnode("enabled");
            if (eq != null) {
                NodeEvaluator val = new NodeEvaluator(map);
                ((Component)((Object)ed)).setEnabled(val.evaluateAnd(eq));
            } else {
                ((Component)((Object)ed)).setEnabled(true);
            }
            ++i;
        }
    }

    public IModellerPropEditor createEditor(String type, Node properties) {
        if ("None".equals(type)) {
            return null;
        }
        if ("String".equals(type)) {
            return new StringEditor();
        }
        if ("Text".equals(type)) {
            return new TextPropertyEditor();
        }
        if ("Boolean".equals(type)) {
            return new BooleanEditor();
        }
        if ("OneOfMany".equals(type)) {
            return new OneOfManyEditor();
        }
        if ("ManyOfMany".equals(type)) {
            return new ManyOfManyEditor();
        }
        if ("Entity".equals(type)) {
            return new OtherEntityEditor();
        }
        if ("Entities".equals(type)) {
            return new OtherEntitiesEditor();
        }
        if ("Attribute".equals(type)) {
            return new OtherAttributeEditor();
        }
        if ("Attributes".equals(type)) {
            return new OtherAttributesEditor();
        }
        if ("AddEntity".equals(type)) {
            return new AddEntityEditor();
        }
        if ("AddAttribute".equals(type)) {
            return new AddAttributeEditor();
        }
        if ("AddMethod".equals(type)) {
            return new AddMethodEditor();
        }
        if ("Path".equals(type)) {
            return new PathPropertyEditor();
        }
        return new StringEditor();
    }
}

