/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.modeller.model;

import de.netcomputing.util.xml.Node;
import de.netcomputing.util.xml.XMLIterator;
import de.netcomputing.util.xml.XmlReader;
import java.io.File;
import java.io.FileInputStream;

public class MetaModel {
    File file;
    Node modelRoot;

    public Node getRoot() {
        return this.modelRoot;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public void loadMetaModel(File f) throws Exception {
        FileInputStream in = new FileInputStream(f);
        this.modelRoot = (Node)new XmlReader().read(in);
        in.close();
        this.file = f;
    }

    public Node findEntity(String name) {
        return this.findObject(this.modelRoot, name, "Entity");
    }

    public Node findConnection(String name) {
        return this.findObject(this.modelRoot, name, "Connection");
    }

    public Node findProperty(Node entityOrConnection, String name) {
        return this.findObject(entityOrConnection, name, "Property");
    }

    public Node findProperty(String name) {
        return this.findObject(this.modelRoot, name, "Property");
    }

    protected Node findObject(Node root, String name, String tagName) {
        XMLIterator it = root.getSubnodes(tagName);
        Node entity = null;
        while (it.hasMoreElements()) {
            Node entityNode = (Node)it.nextElement();
            if (!entityNode.getField("name", "").equals(name)) continue;
            entity = entityNode;
            break;
        }
        return entity;
    }

    public XMLIterator getConnections() {
        return this.modelRoot.getSubnodes("Connection");
    }

    public XMLIterator getEntities() {
        return this.modelRoot.getSubnodes("Entity");
    }
}

