/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.propertystore.beans;

import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.jwidgets.JListPanel;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.propertystore.IStoreAccess;
import de.netcomputing.propertystore.IStoreControl;
import de.netcomputing.propertystore.beans.PropertyFileSelGUI;
import de.netcomputing.util.NCStringUtilities;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PropertyFileSel
extends JPanel
implements IStoreControl {
    JTextField dirTxt;
    JButton chooseDirBtn;
    String acceptedExtensions = "";
    String fileToSearch = null;
    String label;
    IStoreAccess store;
    String dataPath;
    JListPanel mirror;

    public void addDocumentListener(DocumentListener cl) {
        this.dirTxt.getDocument().addDocumentListener(cl);
    }

    public void removeDocumentListener(DocumentListener cl) {
        this.dirTxt.getDocument().removeDocumentListener(cl);
    }

    public void addChangeListener(final ChangeListener cl) {
        this.dirTxt.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                cl.stateChanged(new ChangeEvent(e));
            }
        });
    }

    public void removeChangeListener(final ChangeListener cl) {
        this.dirTxt.removePropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                cl.stateChanged(new ChangeEvent(e));
            }
        });
    }

    public void setMirror(final JListPanel mirror) {
        this.mirror = mirror;
        this.addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            public void changedUpdate(DocumentEvent e) {
                if (mirror != null) {
                    Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, PropertyFileSel.this.dirTxt.getText());
                    int n = 0;
                    while (n < v.size()) {
                        v.setElementAt(new ListItem(v.elementAt(n)), n);
                        ++n;
                    }
                    mirror.setList(v, 0.0, -1);
                    mirror.repaint();
                }
            }
        });
    }

    public JListPanel getMirror() {
        return this.mirror;
    }

    public void setToolTipText(String s) {
        super.setToolTipText(s);
        int n = 0;
        while (n < this.countComponents()) {
            if (this.getComponent(n) instanceof JComponent) {
                ((JComponent)this.getComponent(n)).setToolTipText(s);
            }
            ++n;
        }
    }

    public void addFocusListener(FocusListener li) {
        if (this.dirTxt != null) {
            this.dirTxt.addFocusListener(li);
            this.chooseDirBtn.addFocusListener(li);
        } else {
            super.addFocusListener(li);
        }
    }

    public void replaceSelection(String s) {
        this.dirTxt.replaceSelection(s);
    }

    public PropertyFileSel() {
        this.initGui();
    }

    public void initGui() {
        new PropertyFileSelGUI().createGui(this);
    }

    public void readData(IStoreAccess store) {
        this.dirTxt.setText(store.getValue(this.dataPath));
    }

    public void writeData(IStoreAccess store) {
        store.setValue(this.dataPath, this.dirTxt.getText());
    }

    public void setStore(IStoreAccess store) {
        this.store = store;
    }

    public IStoreAccess getStore() {
        return this.store;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setFileToSearch(String fileToSearch) {
        this.fileToSearch = fileToSearch;
    }

    public String getFileToSearch() {
        return this.fileToSearch;
    }

    public void setAcceptedExtensions(String acceptedExtensions) {
        this.acceptedExtensions = acceptedExtensions;
    }

    public String getAcceptedExtensions() {
        return this.acceptedExtensions;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getText() {
        return this.dirTxt.getText();
    }

    public void setText(String s) {
        this.dirTxt.setText(s);
    }

    public void setEnabled(boolean b) {
        this.dirTxt.setEnabled(b);
        this.chooseDirBtn.setEnabled(b);
    }

    public boolean isEnabled() {
        return this.dirTxt.isEnabled();
    }

    public void setTextAfterChoosing(String s) {
        this.dirTxt.setText(s);
    }

    public String getTextBeforeChoosing() {
        return this.dirTxt.getText();
    }

    public void chooseDirBtn_actionPerformed(ActionEvent var0) {
        File f;
        Container frame = this.getTopLevelAncestor();
        if (frame instanceof Dialog) {
            frame = frame.getParent();
        }
        if ((f = AJDirSelector.SelectDirModal((Frame)frame, null, this.label, "", this.getTextBeforeChoosing(), this.getAcceptedExtensions())) != null) {
            this.setTextAfterChoosing(f.getAbsolutePath());
        }
    }
}

