/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx;

import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.swingx.DockingComponentInfo;
import de.netcomputing.swingx.NCGradientLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class DockingWindowTitleBar
extends JPanel {
    public static final int STATE_INACTIVE = 0;
    public static final int STATE_ACTIVE_PRIMARY = 1;
    public static final int STATE_ACTIVE_SECONDARY = 2;
    public static Color primarySelColor = SystemColor.activeCaption;
    public static Color secondarySelColor = SystemColor.activeCaption.darker();
    int activationState = 0;
    JButton minimizeBtn;
    JButton closeBtn;
    DockingComponentInfo info;
    int gap = 2;

    public DockingWindowTitleBar(int initialState, DockingComponentInfo dcInfo) {
        this.info = dcInfo;
        this.activationState = initialState;
        this.minimizeBtn = new JButton();
        this.closeBtn = new JButton();
        this.minimizeBtn.setMargin(new Insets(0, 0, 0, 0));
        this.closeBtn.setMargin(new Insets(0, 0, 0, 0));
        Image im = NCApplication.GetImage("/de/netcomputing/swingx/images/minimize.gif");
        if (im != null) {
            this.minimizeBtn.setIcon(new ImageIcon(im));
        } else {
            this.minimizeBtn.setText("_");
        }
        im = NCApplication.GetImage("/de/netcomputing/swingx/images/close.gif");
        if (im != null) {
            this.closeBtn.setIcon(new ImageIcon(im));
        } else {
            this.closeBtn.setText("x");
        }
        this.setLayout(null);
        this.add(this.minimizeBtn);
        this.add(this.closeBtn);
        this.closeBtn.setFocusPainted(false);
        this.minimizeBtn.setFocusPainted(false);
        this.closeBtn.setBorder(BorderFactory.createLineBorder(Color.black));
        this.minimizeBtn.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(false);
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }

    public JButton getMinimizeBtn() {
        return this.minimizeBtn;
    }

    public void doLayout() {
        if (!this.info.getCanClose()) {
            this.closeBtn.setVisible(false);
        }
        int w = this.getWidth();
        int h = this.getHeight();
        Dimension btnDim = this.minimizeBtn.getPreferredSize();
        if (!this.closeBtn.isVisible()) {
            this.minimizeBtn.setBounds(w - this.gap - btnDim.width, (h - btnDim.height) / 2, btnDim.width, btnDim.height);
        } else {
            this.closeBtn.setBounds(w - this.gap - btnDim.width, (h - btnDim.height) / 2, btnDim.width, btnDim.height);
            this.minimizeBtn.setBounds(w - 2 * (this.gap + btnDim.width), (h - btnDim.height) / 2, btnDim.width, btnDim.height);
        }
    }

    public Dimension getMinimumSize() {
        Dimension btnDim = this.closeBtn.getPreferredSize();
        return new Dimension(btnDim.width + 3 * this.gap, btnDim.height + 2 * this.gap);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setTitle(String title) {
        this.info.setTitle(title);
    }

    public void setActivationState(int activationState) {
        this.activationState = activationState;
        this.repaint();
    }

    public int getActivationState() {
        return this.activationState;
    }

    public void addTitleMouseListener(MouseListener mouselistener) {
        this.addMouseListener(mouselistener);
    }

    public void removeTitleMouseListener(MouseListener mouselistener) {
        this.removeMouseListener(mouselistener);
    }

    public String getTitle() {
        return this.info.getTitle();
    }

    public void paint(Graphics g) {
        if (this.activationState == 1) {
            Graphics2D g2D = (Graphics2D)g;
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, NCGradientLabel.col1, this.getWidth(), this.getHeight(), NCGradientLabel.col2);
            Rectangle rec2 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            g2D.setPaint(gradient);
            g2D.fill(rec2);
        } else {
            switch (this.activationState) {
                default: {
                    g.setColor(SystemColor.inactiveCaption);
                    break;
                }
                case 1: {
                    g.setColor(primarySelColor);
                    break;
                }
                case 2: {
                    g.setColor(secondarySelColor);
                }
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setFont(UIManager.getFont("InternalFrame.titleFont"));
        switch (this.activationState) {
            default: {
                g.setColor(SystemColor.inactiveCaptionText);
                break;
            }
            case 1: {
                g.setColor(Color.white);
                break;
            }
            case 2: {
                g.setColor(SystemColor.activeCaptionText);
            }
        }
        int sw = g.getFontMetrics().stringWidth(this.getTitle());
        int fh = g.getFontMetrics().getHeight();
        int maxAsc = g.getFontMetrics().getMaxAscent();
        g.drawString(this.getTitle(), this.gap, maxAsc + (this.getHeight() - fh) / 2);
        super.paint(g);
    }
}

