/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netcomputing.tools.INCPrintOut;

public class NCStringUtilities {
    static String[] escmap = new String[]{"\"", "&#34;", "&", "&amp;"};
    static Hashtable esctab;
    static String[] escmapJava;
    static Hashtable esctabJava;

    public static INCPrintOut GetNCFromStream(final PrintStream ps) {
        return new INCPrintOut(){

            public void printLine(String s) {
                ps.println(s);
            }

            public void processTerminated(int exitValue) {
            }
        };
    }

    public static StringBuffer MakeValidFile(String s) {
        StringBuffer res = new StringBuffer(s.length());
        int i = 0;
        while (i < s.length()) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) {
                res.append(s.charAt(i));
            }
            ++i;
        }
        return res;
    }

    public static String PrepareRegExp(String s) {
        s = s.trim();
        s = NCStringUtilities.Replace(s, ".", "\\.");
        if ((s = NCStringUtilities.Replace(s, "*", ".*")).indexOf(".*") < 0) {
            s = ".*" + s + ".*";
        }
        return s;
    }

    public static String EscapeForJava(String s) {
        if (esctabJava == null) {
            esctabJava = new Hashtable(6);
            int n = 0;
            while (n < escmapJava.length) {
                esctabJava.put(escmapJava[n], escmapJava[n + 1]);
                n += 2;
            }
        }
        StringBuffer result = new StringBuffer(s.length());
        int n = 0;
        while (n < s.length()) {
            String ch = new String(s.substring(n, n + 1));
            String toAdd = (String)esctabJava.get(ch);
            result.append(toAdd == null ? ch : toAdd);
            ++n;
        }
        return result.toString();
    }

    public static String LongestCommonStart(Enumeration en) {
        if (!en.hasMoreElements()) {
            return "";
        }
        String greatest = en.nextElement().toString();
        while (en.hasMoreElements() && greatest.length() > 0) {
            String act = en.nextElement().toString();
            boolean idx = false;
            int mx = Math.min(greatest.length(), act.length());
            int n = 0;
            while (n < mx && greatest.length() > 0) {
                if (greatest.charAt(n) != act.charAt(n)) break;
                ++n;
            }
            if (n == greatest.length()) continue;
            greatest = greatest.substring(0, n);
        }
        return greatest;
    }

    public static String EscapeForHtml(String s) {
        if (esctab == null) {
            esctab = new Hashtable(6);
            int n = 0;
            while (n < escmap.length) {
                esctab.put(escmap[n], escmap[n + 1]);
                n += 2;
            }
        }
        StringBuffer result = new StringBuffer(s.length());
        int n = 0;
        while (n < s.length()) {
            String ch = new String(s.substring(n, n + 1));
            String toAdd = (String)esctab.get(ch);
            result.append(toAdd == null ? ch : toAdd);
            ++n;
        }
        return result.toString();
    }

    public static String Replace(String s, String key, String value) {
        return NCStringUtilities.Replace(s, key, value, 0);
    }

    public static String WordWrap(String s, int prefWidth, String sep) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        int lastApp = 0;
        int i = 0;
        while (i < s.length()) {
            result.append(s.charAt(i));
            if (i - lastApp > prefWidth && Character.isWhitespace(s.charAt(i))) {
                result.append(sep);
                lastApp = i;
            }
            ++i;
        }
        return result.toString();
    }

    public static String Replace(String s, String key, String value, int start) {
        int i = s.indexOf(key, start);
        if (i < 0) {
            return s;
        }
        StringBuffer res = new StringBuffer(s.length());
        res.append(s.substring(0, i));
        res.append(value);
        res.append(s.substring(i + key.length()));
        return NCStringUtilities.Replace(res.toString(), key, value, i + value.length());
    }

    public static String GetLastString(String sep, String str) {
        int i = str.lastIndexOf(sep);
        if (i >= 0) {
            return str.substring(i + sep.length());
        }
        return str;
    }

    public static String GetLastStringComplement(String sep, String str) {
        int i = str.lastIndexOf(sep);
        if (i >= 0) {
            return str.substring(0, i);
        }
        return str;
    }

    public static int[] GetMultiInt(String s, int length) {
        int[] res = new int[length];
        try {
            int resIdx = 0;
            int pot = 1;
            int sign = 1;
            int n = s.length() - 1;
            while (n >= 0 && resIdx < length) {
                int c = s.charAt(n) - 48;
                if (c <= 9 && c >= 0) {
                    int n2 = resIdx;
                    res[n2] = res[n2] + c * pot;
                    pot *= 10;
                } else if (c == 45) {
                    sign = -1;
                } else {
                    pot = 1;
                    int n3 = resIdx++;
                    res[n3] = res[n3] * sign;
                    sign = 1;
                }
                --n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return res;
    }

    public static int GetHexInt(String s) {
        try {
            if (s == null || s.length() == 0) {
                return Integer.MAX_VALUE;
            }
            s = s.trim().toUpperCase();
            int res = 0;
            int pot = 1;
            int n = s.length() - 1;
            while (n >= 0) {
                int c = s.charAt(n) - 48;
                if (c > 9) {
                    c -= 7;
                }
                if (c > 15) break;
                res += c * pot;
                pot *= 16;
                --n;
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    public static void DumpException(INCPrintOut po, Throwable ex) {
        StringWriter out = new StringWriter(1000);
        ex.printStackTrace(new PrintWriter((Writer)out, true));
        Vector v = NCStringUtilities.SplitSeparatedString("\n", out.getBuffer().toString());
        int i = 0;
        while (i < v.size()) {
            po.printLine("" + v.get(i));
            ++i;
        }
    }

    public static String GetNumericDateTime() {
        DateFormat df = DateFormat.getDateTimeInstance(2, 2);
        String res = df.format(new Date());
        res = res.substring(0, res.length() - 3);
        res = res.replace(' ', '_');
        res = res.replace(':', '_');
        res = res.replace('.', '_');
        return res;
    }

    public static Vector SplitSeparatedString(String separator, String toParse) {
        return NCStringUtilities.SplitSeparatedString(separator, toParse, false);
    }

    public static Vector SplitSeparatedString(String separator, String toParse, boolean includeEmpty) {
        if (toParse == null) {
            return new Vector(0);
        }
        Vector<String> res = new Vector<String>(20);
        String s = toParse;
        if (!s.endsWith(separator)) {
            s = s + separator;
        }
        while (s.indexOf(separator) >= 0) {
            String p = s.substring(0, s.indexOf(separator));
            s = s.substring(p.length() + 1);
            if ((p = p.trim()).length() <= 0 && !includeEmpty) continue;
            res.addElement(p);
        }
        return res;
    }

    static {
        escmapJava = new String[]{"\"", "\\\"", "\\", "\\\\"};
    }
}

