/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.dtd;

import de.netcomputing.util.dtd.DTDAttribute;
import de.netcomputing.util.dtd.DTDOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;

public class DTDAttlist
implements DTDOutput {
    public String name;
    public Vector attributes;

    public DTDAttlist() {
        this.attributes = new Vector();
    }

    public DTDAttlist(String aName) {
        this.name = aName;
        this.attributes = new Vector();
    }

    public void write(PrintWriter out) throws IOException {
        out.print("<!ATTLIST ");
        out.println(this.name);
        Iterator itr = this.attributes.iterator();
        while (itr.hasNext()) {
            out.print("           ");
            DTDAttribute attr = (DTDAttribute)itr.next();
            attr.write(out);
            if (itr.hasNext()) {
                out.println();
                continue;
            }
            out.println(">");
        }
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof DTDAttlist)) {
            return false;
        }
        DTDAttlist other = (DTDAttlist)ob;
        if (this.name == null && other.name != null) {
            return false;
        }
        if (this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        return this.attributes.equals(other.attributes);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public DTDAttribute[] getAttribute() {
        Object[] attrs = new DTDAttribute[this.attributes.size()];
        this.attributes.copyInto(attrs);
        return attrs;
    }

    public void setAttribute(DTDAttribute[] attrs) {
        this.attributes = new Vector(attrs.length);
        int i = 0;
        while (i < attrs.length) {
            this.attributes.addElement(attrs[i]);
            ++i;
        }
    }

    public DTDAttribute getAttribute(int i) {
        return (DTDAttribute)this.attributes.elementAt(i);
    }

    public void setAttribute(DTDAttribute attr, int i) {
        this.attributes.setElementAt(attr, i);
    }
}

