/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.BasicPrintStream;
import de.netcomputing.util.xml.PrintOut;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayBuffer
extends BasicPrintStream
implements PrintOut {
    protected byte[] buf = new byte[256];
    protected int pos;
    protected int size = 0;

    public ByteArrayBuffer() {
    }

    public ByteArrayBuffer(String linefeed) {
        super(linefeed);
    }

    protected byte[] ensureSpace(int min) {
        int len = this.buf.length;
        if (this.size + min < len) {
            return this.buf;
        }
        byte[] dst = new byte[Math.max(this.size + min, len * 2)];
        System.arraycopy(this.buf, 0, dst, 0, this.size);
        this.buf = dst;
        return dst;
    }

    public int size() {
        return this.size;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.writeTo(out, 0, this.size());
    }

    public void writeTo(OutputStream out, int offs, int length) throws IOException {
        if (offs + length > this.size) {
            throw new IndexOutOfBoundsException();
        }
        out.write(this.buf, offs, length);
    }

    public InputStream getInputStream() {
        return this.getInputStream(0, this.size());
    }

    public InputStream getInputStream(final int offs, int length) {
        final byte[] data = this.buf;
        final int max = offs + length;
        if (max > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new InputStream(){
            int pos;
            {
                this.pos = offs;
            }

            public int available() throws IOException {
                return max - this.pos;
            }

            public int read() throws IOException {
                if (this.pos >= max) {
                    return -1;
                }
                return data[this.pos++] & 0xFF;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                if (this.pos >= max) {
                    return -1;
                }
                if (len > max - this.pos) {
                    len = max - this.pos;
                }
                if (len > 0) {
                    System.arraycopy(ByteArrayBuffer.this.buf, this.pos, b, off, len);
                    this.pos += len;
                }
                return len;
            }

            public long skip(long n) throws IOException {
                if (this.pos >= max) {
                    return -1L;
                }
                if (n > (long)(max - this.pos)) {
                    n = max - this.pos;
                }
                this.pos = (int)((long)this.pos + n);
                return n;
            }
        };
    }

    public void reset() {
        this.truncate(0);
    }

    public void truncate(int toSize) {
        if (toSize > this.size) {
            throw new IllegalArgumentException();
        }
        this.size = toSize;
    }

    public void delete(int offs, int length) {
        if (offs + length > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (offs + length < this.size) {
            System.arraycopy(this.buf, offs + length, this.buf, offs, this.size - offs - length);
        }
        this.size -= length;
    }

    public String toString() {
        return this.toString(0, this.size());
    }

    public String toString(int offs, int length) {
        if (offs + length > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.buf, 0, offs, length);
    }

    public byte[] getInternal() {
        return this.buf;
    }

    public byte[] getBytes() {
        return this.getBytes(0, this.size());
    }

    public byte[] getBytes(int offs, int length) {
        if (offs + length > this.size) {
            throw new IndexOutOfBoundsException();
        }
        byte[] bytes = new byte[length];
        System.arraycopy(this.buf, offs, bytes, 0, length);
        return bytes;
    }

    public void append(char ch) {
        if (ch == '\n') {
            this.newline();
        } else if (ch != '\r') {
            byte[] bytes = this.ensureSpace(1);
            bytes[this.size++] = (byte)ch;
        }
    }

    public void append(String str, int offs, int len) {
        byte[] bytes = this.ensureSpace(len);
        int idx = 0;
        while (idx < len) {
            char ch;
            if (this.size >= bytes.length) {
                bytes = this.ensureSpace(len - idx);
            }
            if ((ch = str.charAt(offs + idx)) == '\n') {
                this.newline();
            } else if (ch != '\r') {
                bytes[this.size++] = (byte)ch;
            }
            ++idx;
        }
    }

    public void append(char[] arr, int offs, int len) {
        byte[] bytes = this.ensureSpace(len);
        int idx = 0;
        while (idx < len) {
            char ch;
            if (this.size >= bytes.length) {
                bytes = this.ensureSpace(len - idx);
            }
            if ((ch = arr[offs + idx]) == '\n') {
                this.newline();
            } else if (ch != '\r') {
                bytes[this.size++] = (byte)ch;
            }
            ++idx;
        }
    }

    public void append(byte[] arr, int offs, int len) {
        byte[] bytes = this.ensureSpace(len);
        int idx = 0;
        while (idx < len) {
            byte ch;
            if (this.size >= bytes.length) {
                bytes = this.ensureSpace(len - idx);
            }
            if ((ch = arr[offs + idx]) == 10) {
                this.newline();
            } else if (ch != 13) {
                bytes[this.size++] = ch;
            }
            ++idx;
        }
    }

    public void append(ByteArrayBuffer buffer) {
        if (buffer.hasLinefeed(this.linefeed)) {
            this.rawappend(buffer.buf, 0, buffer.size);
        } else {
            this.append(buffer.buf, 0, buffer.size);
        }
    }

    public void append(InputStream stream, int length) throws IOException {
        int read = 0;
        byte[] buf = new byte[8192];
        while (read < length) {
            int len = length - read < buf.length ? length - read : buf.length;
            if ((len = stream.read(buf, 0, len)) > 0) {
                read += len;
                this.append(buf, 0, len);
                continue;
            }
            if (len < 0) break;
        }
    }

    public void rawappend(InputStream stream, int length) throws IOException {
        int offs = this.size();
        int read = 0;
        byte[] dest = this.ensureSpace(length);
        while (read < length) {
            int len = stream.read(dest, offs + read, length - read);
            if (len > 0) {
                read += len;
                continue;
            }
            if (len < 0) break;
        }
        this.size += read;
    }

    public int indexOf(char ch, int from) {
        byte[] buf = this.buf;
        int max = this.size;
        while (from < max) {
            if (buf[from] == ch) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public int indexOf(String str, int from) {
        len = str.length();
        max = this.size - len;
        if (len == 0) {
            return from;
        }
        first = str.charAt(0);
        if (len == 1) {
            return this.indexOf(first, from);
        }
        buf = this.buf;
        ** GOTO lbl19
        {
            if (from > max) {
                return -1;
            }
            do {
                if (buf[from++] != first) continue block0;
                idx = 1;
                idy = from;
                while (str.charAt(idx++) == buf[idy++]) {
                    if (idx != len) continue;
                    return from - 1;
                }
lbl19:
                // 2 sources

            } while (from <= max);
        }
        return -1;
    }

    public int indexOfIgnorecase(char ch, int from) {
        byte[] buf = this.buf;
        char alt = Character.toLowerCase(ch);
        ch = Character.toUpperCase(ch);
        int max = this.size;
        while (from < max) {
            if (buf[from] == ch || buf[from] == ch) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public int indexOfIgnorecase(String str, int from) {
        len = str.length();
        max = this.size - len;
        if (len == 0) {
            return from;
        }
        if (len == 1) {
            return this.indexOfIgnorecase(str.charAt(0), from);
        }
        first = Character.toLowerCase(str.charAt(0));
        alt = Character.toUpperCase(str.charAt(0));
        buf = this.buf;
        ** GOTO lbl25
        {
            if (from > max) {
                return -1;
            }
            ++from;
            do {
                if (buf[from] != first && buf[from] != alt) continue block0;
                idx = 1;
                idy = from;
                while (Character.toLowerCase(str.charAt(idx)) == buf[idy] || Character.toUpperCase(str.charAt(idx)) == buf[idy]) {
                    if (idx == len) {
                        return from;
                    }
                    ++idx;
                    ++idy;
                }
                ++from;
lbl25:
                // 2 sources

            } while (from <= max);
        }
        return -1;
    }

    public void rawappend(byte[] arr, int offs, int len) {
        byte[] dst = this.ensureSpace(len);
        System.arraycopy(arr, offs, dst, this.size, len);
        this.size += len;
    }

    public void rawappend(byte b) {
        if (this.size < this.buf.length) {
            this.buf[this.size++] = b;
        } else {
            this.ensureSpace((int)1)[this.size++] = b;
        }
    }

    public void newline() {
        byte[] bytes = this.ensureSpace(this.linefeed.length);
        int idx = 0;
        while (idx < this.linefeed.length) {
            bytes[this.size++] = (byte)this.linefeed[idx];
            ++idx;
        }
    }
}

