/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

public class MathUtil {
    private static final char[] strValBuf = new char[30];
    private static final double decLogBase = Math.log(10.0);
    private static final long maxLongDiv10 = 0xFFFFFFFFFFFFFFFL;
    protected static final int INT_STRING_BUFFER_MAX = 10000;
    protected static final String[] intStrings = new String[10000];

    public static long longValueOf(String str) {
        int len;
        if (str == null || (len = str.length()) == 0) {
            return 0L;
        }
        long lval = 0L;
        int idx = 0;
        boolean sign = false;
        char ch = str.charAt(idx);
        while (idx < len && ch <= ' ') {
            char c = ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
        }
        if (ch == '-') {
            ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
            sign = true;
        } else if (ch == '+') {
            ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
        }
        while (ch >= '0' && ch <= '9') {
            lval = lval * 10L - (long)ch + 48L;
            char c = ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
        }
        return sign ? lval : -lval;
    }

    public static long longValueOf(byte[] str) {
        if (str == null) {
            return 0L;
        }
        return MathUtil.longValueOf(str, 0, str.length);
    }

    public static long longValueOf(byte[] str, int begin, int end) {
        if (str == null || end == begin) {
            return 0L;
        }
        long lval = 0L;
        int idx = begin;
        boolean sign = false;
        byte ch = str[idx];
        while (idx < end && ch <= 32) {
            byte by = ch = ++idx < end ? str[idx] : (byte)0;
        }
        if (ch == 45) {
            ch = ++idx < end ? str[idx] : (byte)0;
            sign = true;
        } else if (ch == 43) {
            ch = ++idx < end ? str[idx] : (byte)0;
        }
        while (ch >= 48 && ch <= 57) {
            lval = lval * 10L - (long)ch + 48L;
            byte by = ch = ++idx < end ? str[idx] : (byte)0;
        }
        return sign ? lval : -lval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringValueOf(long val) {
        boolean isbuf = val >= 0L && val < 10000L;
        int ival = (int)val;
        if (isbuf && intStrings[ival] != null) {
            return intStrings[ival];
        }
        char[] cArray = strValBuf;
        synchronized (cArray) {
            char[] buf = strValBuf;
            int idx = 30;
            boolean sign = val < 0L;
            if (!sign) {
                val = -val;
            }
            while (val <= -10L) {
                buf[--idx] = (char)(48L - val % 10L);
                val /= 10L;
            }
            buf[--idx] = (char)(48L - val);
            if (sign) {
                buf[--idx] = 45;
            }
            String res = new String(buf, idx, 30 - idx);
            if (isbuf) {
                MathUtil.intStrings[ival] = res;
            }
            String string = res;
            return string;
        }
    }

    public static int stringValueOf(byte[] buf, int bpos, long val) {
        if (val == 0L) {
            buf[bpos] = 48;
            return 1;
        }
        int idx = bpos + 30;
        boolean sign = val < 0L;
        if (!sign) {
            val = -val;
        }
        while (val <= -10L) {
            buf[--idx] = (byte)(48L - val % 10L);
            val /= 10L;
        }
        buf[--idx] = (byte)(48L - val);
        if (sign) {
            buf[--idx] = 45;
        }
        int len = bpos + 30 - idx;
        System.arraycopy(buf, idx, buf, bpos, len);
        return len;
    }

    public static double getCardinality(double value) {
        return Math.log(Math.abs(value)) / decLogBase;
    }

    public static double doubleValueOf(String str) {
        return MathUtil.doubleValueOf(str, 8);
    }

    public static double doubleValueOf(String str, int roundBy) {
        double val;
        int len;
        if (str == null || (len = str.length()) == 0) {
            return 0.0;
        }
        long lval = 0L;
        double base = 10.0;
        double divby = 1.0;
        int idx = 0;
        int exp = 0;
        char ch = str.charAt(0);
        while (idx < len && ch <= ' ') {
            char c = ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
        }
        if (ch == '-') {
            ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
            divby = -1.0;
        } else if (ch == '+') {
            ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
        }
        while (ch >= '0' && ch <= '9' && lval < 0xFFFFFFFFFFFFFFFL) {
            lval = lval * 10L + (long)ch - 48L;
            char c = ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
        }
        if (lval >= 0xFFFFFFFFFFFFFFFL) {
            while (ch >= '0' && ch <= '9') {
                ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
                divby /= 10.0;
            }
        } else if (ch == '.' || ch == ',') {
            ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
            while (ch >= '0' && ch <= '9' && lval < 0xFFFFFFFFFFFFFFFL) {
                lval = lval * 10L + (long)ch - 48L;
                ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
                divby *= 10.0;
            }
        }
        double d = val = divby == 1.0 ? (double)lval : (double)lval / divby;
        if (lval != 0L && (ch == 'e' || ch == 'E')) {
            char c = ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
            if (ch == '-') {
                ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
                base = 0.1;
            } else if (ch == '+') {
                ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
            }
            while (ch >= '0' && ch <= '9') {
                exp = exp * 10 + ch - 48;
                char c2 = ch = ++idx < len ? str.charAt(idx) : (char)'\u0000';
            }
            val *= Math.pow(base, exp);
        }
        if (roundBy > 0) {
            double fakt = Math.pow(10.0, (double)roundBy - Math.floor(MathUtil.getCardinality(val)));
            val = (double)Math.round(val * fakt) / fakt;
        }
        return val;
    }

    public static double doubleValueOf(byte[] str) {
        if (str == null) {
            return 0.0;
        }
        return MathUtil.doubleValueOf(str, 0, str.length, 11);
    }

    public static double doubleValueOf(byte[] str, int roundBy) {
        if (str == null) {
            return 0.0;
        }
        return MathUtil.doubleValueOf(str, 0, str.length, roundBy);
    }

    public static double doubleValueOf(byte[] str, int begin, int end) {
        if (str == null) {
            return 0.0;
        }
        return MathUtil.doubleValueOf(str, begin, end, 11);
    }

    public static double doubleValueOf(byte[] str, int begin, int end, int roundBy) {
        double val;
        if (str == null || begin == end) {
            return 0.0;
        }
        long lval = 0L;
        double base = 10.0;
        double divby = 1.0;
        int idx = begin;
        int exp = 0;
        byte ch = str[idx];
        while (idx < end && ch <= 32) {
            byte by = ch = ++idx < end ? str[idx] : (byte)0;
        }
        if (ch == 45) {
            ch = ++idx < end ? str[idx] : (byte)0;
            divby = -1.0;
        } else if (ch == 43) {
            ch = ++idx < end ? str[idx] : (byte)0;
        }
        while (ch >= 48 && ch <= 57 && lval < 0xFFFFFFFFFFFFFFFL) {
            lval = lval * 10L + (long)ch - 48L;
            byte by = ch = ++idx < end ? str[idx] : (byte)0;
        }
        if (lval >= 0xFFFFFFFFFFFFFFFL) {
            while (ch >= 48 && ch <= 57) {
                ch = ++idx < end ? str[idx] : (byte)0;
                divby /= 10.0;
            }
        } else if (ch == 46 || ch == 44) {
            ch = ++idx < end ? str[idx] : (byte)0;
            while (ch >= 48 && ch <= 57 && lval < 0xFFFFFFFFFFFFFFFL) {
                lval = lval * 10L + (long)ch - 48L;
                ch = ++idx < end ? str[idx] : (byte)0;
                divby *= 10.0;
            }
        }
        double d = val = divby == 1.0 ? (double)lval : (double)lval / divby;
        if (lval != 0L && (ch == 101 || ch == 69)) {
            byte by = ch = ++idx < end ? str[idx] : (byte)0;
            if (ch == 45) {
                ch = ++idx < end ? str[idx] : (byte)0;
                base = 0.1;
            } else if (ch == 43) {
                ch = ++idx < end ? str[idx] : (byte)0;
            }
            while (ch >= 48 && ch <= 57) {
                exp = exp * 10 + ch - 48;
                byte by2 = ch = ++idx < end ? str[idx] : (byte)0;
            }
            val *= Math.pow(base, exp);
        }
        if (roundBy > 0) {
            double fakt = Math.pow(10.0, (double)roundBy - Math.floor(MathUtil.getCardinality(val)));
            val = (double)Math.round(val * fakt) / fakt;
        }
        return val;
    }

    public static String stringValueOf(double val) {
        return MathUtil.stringValueOf(val, 12, 12);
    }

    public static String stringValueOf(double val, int roundBy) {
        return MathUtil.stringValueOf(val, roundBy, 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringValueOf(double val, int roundBy, int noexp) {
        char[] cArray = strValBuf;
        synchronized (cArray) {
            int exp;
            long lval;
            int offs;
            int idx;
            char[] buf;
            block20: {
                if (noexp < 0 || noexp > 15) {
                    noexp = 15;
                }
                if (roundBy < 0 || roundBy > noexp) {
                    roundBy = noexp;
                }
                buf = strValBuf;
                idx = 0;
                offs = (int)Math.floor(MathUtil.getCardinality(val));
                if (offs > roundBy && offs <= noexp) {
                    roundBy = offs;
                }
                long l = roundBy == offs ? (long)((val < 0.0 ? -val : val) + 0.5) : (lval = (long)(Math.abs(val * Math.pow(10.0, roundBy - offs)) + 0.5));
                if (lval != 0L) break block20;
                String string = "0";
                return string;
            }
            int pos = roundBy;
            while (offs < pos && lval % 10L == 0L) {
                lval /= 10L;
                --pos;
            }
            if (pos < 0) {
                ++pos;
                ++offs;
            }
            int n = exp = (offs >= 0 ? offs : -offs + pos - 4) > noexp ? offs : 0;
            if (exp != 0) {
                while (lval % 10L == 0L) {
                    lval /= 10L;
                    --pos;
                }
                offs = 0;
            }
            while (lval > 0L) {
                if (pos-- == offs && idx > 0) {
                    buf[21 - idx++] = 46;
                }
                buf[21 - idx++] = (char)(lval % 10L + 48L);
                lval /= 10L;
            }
            if (offs < 0) {
                pos = -1;
                while (pos != offs) {
                    buf[21 - idx++] = 48;
                    --pos;
                }
                buf[21 - idx++] = 46;
                buf[21 - idx++] = 48;
            }
            if (val < 0.0) {
                buf[21 - idx++] = 45;
                lval = 0L - lval;
            }
            int len = idx;
            if (exp != 0) {
                pos = 22;
                buf[pos++] = 69;
                if (exp < 0) {
                    buf[pos++] = 45;
                    exp = 0 - exp;
                }
                if (exp >= 10) {
                    pos += exp >= 100 ? 2 : 1;
                }
                len += pos - 21;
                while (exp > 0) {
                    buf[pos--] = (char)(exp % 10 + 48);
                    exp /= 10;
                }
            }
            String string = new String(buf, 22 - idx, len);
            return string;
        }
    }

    public static int stringValueOf(byte[] buf, int bpos, double val) {
        return MathUtil.stringValueOf(buf, bpos, val, 12, 12);
    }

    public static int stringValueOf(byte[] buf, int bpos, double val, int roundBy, int noexp) {
        int exp;
        long lval;
        if (noexp < 0 || noexp > 15) {
            noexp = 15;
        }
        if (roundBy < 0 || roundBy > noexp) {
            roundBy = noexp;
        }
        int idx = 0;
        int offs = (int)Math.floor(MathUtil.getCardinality(val));
        if (offs > roundBy && offs <= noexp) {
            roundBy = offs;
        }
        long l = roundBy == offs ? (long)((val < 0.0 ? -val : val) + 0.5) : (lval = (long)(Math.abs(val * Math.pow(10.0, roundBy - offs)) + 0.5));
        if (lval == 0L) {
            buf[bpos] = 48;
            return 1;
        }
        int pos = roundBy;
        while (offs < pos && lval % 10L == 0L) {
            lval /= 10L;
            --pos;
        }
        int n = exp = (offs >= 0 ? offs : -offs + pos - 4) > noexp ? offs : 0;
        if (exp != 0) {
            while (lval % 10L == 0L) {
                lval /= 10L;
                --pos;
            }
            offs = 0;
        }
        bpos += 21;
        while (lval > 0L) {
            if (pos-- == offs && idx > 0) {
                buf[bpos - idx++] = 46;
            }
            buf[bpos - idx++] = (byte)(lval % 10L + 48L);
            lval /= 10L;
        }
        if (offs < 0) {
            pos = -1;
            while (pos != offs) {
                buf[bpos - idx++] = 48;
                --pos;
            }
            buf[bpos - idx++] = 46;
            buf[bpos - idx++] = 48;
        }
        if (val < 0.0) {
            buf[bpos - idx++] = 45;
            lval = 0L - lval;
        }
        int len = idx;
        if (exp != 0) {
            pos = 1;
            buf[bpos + pos++] = 69;
            if (exp < 0) {
                buf[bpos + pos++] = 45;
                exp = 0 - exp;
            }
            if (exp >= 10) {
                pos += exp >= 100 ? 2 : 1;
            }
            len += pos;
            while (exp > 0) {
                buf[bpos + pos--] = (byte)(exp % 10 + 48);
                exp /= 10;
            }
        }
        System.arraycopy(buf, bpos - idx + 1, buf, bpos - 21, len);
        return len;
    }

    public static boolean booleanValueOf(String val) {
        return val != null && val.length() > 0 && !val.equalsIgnoreCase("false") && !val.equals("0") && !val.equals("0.0");
    }

    public static void main(String[] args) {
        float menge = 0.01f;
        menge = (float)((double)Math.round((double)menge * 10000.0) / 10000.0);
        String val = MathUtil.stringValueOf(menge, 5);
        System.err.println("xxx " + menge + ": \"" + val + "\"");
        menge = 0.001f;
        menge = (float)((double)Math.round((double)menge * 10000.0) / 10000.0);
        val = MathUtil.stringValueOf(menge, 5);
        System.err.println("yyy " + menge + ": \"" + val + "\"");
        menge = (float)MathUtil.doubleValueOf("0.01");
        System.err.println("0.01: \"" + menge + "\"");
        menge = (float)((double)Math.round((double)menge * 10000.0) / 10000.0);
        System.err.println("0.01: \"" + menge + "\"");
    }
}

