/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.Array;
import de.netcomputing.util.xml.DataNode;
import de.netcomputing.util.xml.DataNodeConverter;
import de.netcomputing.util.xml.DataNodeFactory;
import de.netcomputing.util.xml.DataNodeReader;
import de.netcomputing.util.xml.Node;
import de.netcomputing.util.xml.ParseException;
import de.netcomputing.util.xml.XmlExternalEntityResolver;
import de.netcomputing.util.xml.XmlHandler;
import de.netcomputing.util.xml.XmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XmlReader
extends DataNodeConverter
implements DataNodeReader,
DataNodeFactory,
XmlExternalEntityResolver {
    public static final String anonymousDocName = "UnnamedDocument.xml";
    protected InputStream in;
    protected DataNode current;
    protected DataNode root;
    protected DataNodeFactory factory;
    protected XmlExternalEntityResolver resolver;
    protected AelfredHandler handler = new AelfredHandler();

    public XmlReader() {
        this(null, null);
    }

    public XmlReader(DataNodeFactory factory) {
        this(factory, null);
    }

    public XmlReader(XmlExternalEntityResolver resolver) {
        this(null, resolver);
    }

    public XmlReader(DataNodeFactory factory, XmlExternalEntityResolver resolver) {
        this.resolver = resolver != null ? resolver : this;
        this.factory = factory != null ? factory : this;
    }

    public static DataNode readFromString(String xml) {
        return new XmlReader().read(xml);
    }

    public static DataNode readFromStream(InputStream in) {
        return new XmlReader().read(in);
    }

    public static DataNode readFromFile(String file2) throws IOException {
        file2 = new File(file2).getCanonicalPath();
        return new XmlReader().read(new FileInputStream(file2), file2);
    }

    public DataNode read(InputStream in) {
        return this.read(in, anonymousDocName);
    }

    public DataNode read(InputStream in, String docname) {
        if (this.in != null) {
            throw new IllegalStateException("parsing in process");
        }
        this.in = in;
        this.handler.parse(in, docname);
        DataNode node = this.root;
        this.root = null;
        this.current = null;
        this.in = null;
        return node;
    }

    public synchronized DataNode read(final String xmlstr) {
        return this.read(new InputStream(){
            int idx = 0;

            public int read() {
                return this.idx < xmlstr.length() ? (int)xmlstr.charAt(this.idx++) : -1;
            }

            public int available() {
                return xmlstr.length() - this.idx;
            }
        });
    }

    public void setFactory(DataNodeFactory factory) {
        this.factory = factory;
    }

    public DataNodeFactory getFactory() {
        return this.factory;
    }

    public void setResolver(XmlExternalEntityResolver resolver) {
        this.resolver = resolver;
    }

    public XmlExternalEntityResolver getResolver() {
        return this.resolver;
    }

    public DataNode createNode(DataNode parent, String name) {
        return new Node(parent, name);
    }

    public Object resolveExternalEntity(String baseId, String systemId) {
        return systemId;
    }

    protected DataNode createNode(String name) {
        this.current = this.factory.createNode(this.current, name);
        if (this.root == null) {
            this.root = this.current;
        }
        return this.current;
    }

    protected void setCurrentNode(DataNode node) {
        this.current = node;
    }

    public static String getLocalURL(String filename) {
        String local = null;
        if (filename.startsWith("file:/")) {
            return filename;
        }
        if ((filename.indexOf(":") & Integer.MAX_VALUE) < 3) {
            if (filename.charAt(0) == '\\') {
                filename = filename.substring(1, filename.length());
            }
            local = "file:";
        } else {
            local = System.getProperty("user.dir", ".");
        }
        if (local.startsWith("url:")) {
            local = local.substring(4, local.length());
        }
        StringBuffer buf = new StringBuffer(100);
        if (!local.startsWith("http:") && !local.startsWith("file:")) {
            buf.append("file:/");
        }
        buf.append(local);
        buf.append("/");
        if (filename != null) {
            buf.append(filename);
        }
        local = buf.toString().replace('\\', '/');
        return local;
    }

    public String getNomalizedCData(char[] ch, int start, int length) {
        int idx = length - 1;
        while (idx >= 0) {
            if (!Character.isWhitespace(ch[start + idx])) break;
            --idx;
        }
        while (idx >= 0) {
            if (!Character.isWhitespace(ch[start])) break;
            --idx;
            ++start;
        }
        return idx < 0 ? null : new String(ch, start, idx + 1);
    }

    class AelfredHandler
    implements XmlHandler {
        protected XmlParser parser;
        protected DataNode node;
        protected Array tmpFields = new Array();
        protected String baseId;
        int prevCol = 0;
        int prevLine = 0;

        public AelfredHandler() {
            this.parser = new XmlParser();
            this.parser.setHandler(this);
        }

        public void parse(InputStream in, String docname) {
            try {
                String local = XmlReader.getLocalURL(docname);
                int idx = local.lastIndexOf(47);
                this.baseId = local.substring(0, idx + 1);
                this.parser.parse(local, null, in, null);
            }
            catch (ParseException pex) {
                throw pex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void startDocument() {
            this.prevCol = this.parser.getColumnNumber();
            this.prevLine = this.parser.getLineNumber();
        }

        public void endDocument() {
        }

        public void startExternalEntity(String systemId) {
        }

        public void endExternalEntity(String systemId) {
        }

        public Object resolveEntity(String publicId, String systemId) {
            return XmlReader.this.resolver.resolveExternalEntity(this.baseId, systemId);
        }

        public void startElement(String elname) {
            this.node = XmlReader.this.createNode(elname);
            this.node.setCol(this.prevCol);
            this.node.setLine(this.prevLine);
            this.prevCol = this.parser.getColumnNumber();
            this.prevLine = this.parser.getLineNumber();
            int idx = 0;
            while (idx < this.tmpFields.size()) {
                this.node.putField((String)this.tmpFields.get(idx), (String)this.tmpFields.get(idx + 1));
                idx += 2;
            }
            this.tmpFields.removeAll();
        }

        public void endElement(String elname) {
            if (this.node != null) {
                this.node.finished();
                this.node = this.node.getParent();
                XmlReader.this.setCurrentNode(this.node);
            }
        }

        public void charData(char[] ch, int start, int length) {
            DataNode last;
            String cdata = XmlReader.this.getNomalizedCData(ch, start, length);
            if (cdata == null) {
                return;
            }
            int idx = this.node.getSubnodeCount() - 1;
            Node cdnode = null;
            if (idx >= 0 && (last = this.node.getSubnode(idx)) instanceof Node && last.getSubnodeCount() == 0 && last.getAttributeCount() == 1 && last.getName().equals(XmlReader.this.getContentName())) {
                cdnode = (Node)last;
                cdata = cdnode.getField("") + cdata;
            }
            if (cdnode == null) {
                cdnode = new Node(this.node, XmlReader.this.getContentName());
                cdnode.setCol(this.prevCol);
                cdnode.setLine(this.prevLine - 1);
                this.prevCol = this.parser.getColumnNumber();
                this.prevLine = this.parser.getLineNumber();
            }
            cdnode.putField("", cdata);
        }

        public void attribute(String aname, String value, boolean isSpecified) {
            if (!XmlReader.this.usesStrictMapping() && aname.equals("default")) {
                aname = "";
            }
            this.tmpFields.add(aname);
            this.tmpFields.add(value);
        }

        public void processingInstruction(String target, String data) {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void error(String message, String systemId, int line, int column) {
            throw new ParseException(message, systemId, line, column);
        }

        public void doctypeDecl(String name, String publicId, String systemId) {
        }
    }
}

