/*
 * Decompiled with CFR 0.152.
 */
package editapp;

import JWVFile.VFile;
import de.netcomputing.anyj.AJCompileAndBuild;
import de.netcomputing.anyj.AJRunDebug;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.util.NCStringUtilities;
import editapp.EditApp;
import editapp.LibraryRepository;
import java.awt.Container;
import java.awt.Image;
import java.io.File;
import java.util.Vector;
import jxeplugins.FileSetupEntry;
import jxeplugins.IApplicationWizard;
import netcomputing.file.RecursiveFileCopier;
import plugins.DebuggerPlugin;
import plugins.JavacPlugin;

public abstract class BasicApplicationWizard
implements IApplicationWizard {
    protected String directory;
    protected String absoluteDir;
    protected String projectName;
    protected EditApp app;
    protected Container toMakeFurtherQueriesIn;
    protected String[] keys;
    protected String[] values;

    protected static String buildSwingClasspath(String cp) {
        LibraryRepository rep = EditApp.App.getLibraryRepository();
        return cp + File.pathSeparator + "($anyjbase)" + File.separator + "lib" + File.separator + "runtime" + File.pathSeparator + "($Swing)" + File.pathSeparator;
    }

    public String buildClasspath() {
        return "($SystemClasses)" + File.pathSeparator + "($outputdir)";
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract Image getDescriptionImage();

    public abstract Image getSmallIconImage();

    public abstract int getProjectType();

    public abstract String getTemplateDir();

    public abstract String getMainClass();

    public abstract String getMainClassCline();

    public abstract void initKeyValues();

    public boolean shouldMapName(String name) {
        return name.endsWith(".java") || name.endsWith(".gml") || name.endsWith(".html") || name.endsWith(".htm");
    }

    public void copyFilesAndReplaceNames(String templateDir) {
    }

    public void setCompileOptions(JavacPlugin pin) {
        pin.setClasspath(this.buildClasspath());
        pin.setOptions(true, false, false, false, false);
        pin.setOutputDir("($workspaceDir)" + File.separator + "classes");
    }

    public void setDebuggerOptions(DebuggerPlugin dbg) {
        dbg.setMainClass(this.getMainClass());
        dbg.setDebugLine(this.getMainClassCline());
        dbg.setClasspath("($classpath)");
        dbg.setSourcepath("");
        dbg.setWorkingDir(this.absoluteDir);
        dbg.insertDefaults();
        dbg.actionSUN(null, null);
    }

    protected Vector getLibraries() {
        return new Vector(13);
    }

    public void createProject(String directory, String name, EditApp app, Container toMakeFurtherQueriesIn) {
        this.directory = directory;
        this.projectName = name;
        this.app = app;
        this.toMakeFurtherQueriesIn = toMakeFurtherQueriesIn;
        this.absoluteDir = directory + File.separator + name;
        EditApp.App.getOptions().putUserProp("tomcat", "($anyjbase)\\lib\\tomcat");
        try {
            new File(this.absoluteDir).mkdirs();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Confirm.ModalMsg(EditApp.App.mainFrame, "Failed to create directory", new String[]{"The project directory could not be created."});
            return;
        }
        File absFile = new File(this.absoluteDir);
        if (!absFile.isDirectory() || !absFile.exists()) {
            Confirm.ModalMsg(EditApp.App.mainFrame, "Failed to create directory", new String[]{"The project directory could not be created."});
            return;
        }
        this.projectName = this.projectName.substring(0, 1).toUpperCase() + this.projectName.substring(1);
        EditApp.currentProject.setApplicationType(this.getProjectType());
        this.initKeyValues();
        this.copyFilesAndReplaceNames(this.getTemplateDir());
        Vector dirs = this.getLibraries();
        EditApp.App.setAndClearProjectDirs(dirs);
        Vector<ListItem> newDirs = new Vector<ListItem>(13);
        int n = 0;
        while (n < dirs.size()) {
            newDirs.addElement(new ListItem(new File(((FileSetupEntry)dirs.elementAt((int)n)).path)));
            ++n;
        }
        EditApp.App.scanAsynchronous(newDirs, false);
        DebuggerPlugin.This().insertDefaults();
        try {
            DebuggerPlugin dbg = DebuggerPlugin.This();
            JavacPlugin cpin = (JavacPlugin)app.getPluginNamed("CompilerPlugin");
            if (dbg != null) {
                this.setDebuggerOptions(dbg);
            }
            if (cpin != null) {
                this.setCompileOptions(cpin);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AJCompileAndBuild.This.applyBtn_actionPerformed(null);
        AJRunDebug.This.applyBtn_actionPerformed(null);
    }

    public void preRunAction(EditApp app) {
    }

    public void pastRunAction(EditApp app) {
    }

    public void preBuildAction(EditApp app) {
    }

    public void pastBuildAction(EditApp app) {
    }

    class MyCopier
    extends RecursiveFileCopier {
        public MyCopier(String[] keys, String[] values) {
            super(keys, values);
        }

        public boolean shouldCopy(String name) {
            return !name.equals("delme");
        }

        public boolean shouldReplace(String name) {
            return name.endsWith(".java") || name.endsWith(".gml") || name.endsWith(".xml") || name.endsWith(".prp") || name.endsWith(".html") || name.endsWith(".txt") || name.endsWith(".htm");
        }

        public String mapFileName(String name) {
            if (!BasicApplicationWizard.this.shouldMapName(name)) {
                return name;
            }
            String tmp = VFile.NameWithoutExtension(name);
            String ext = VFile.Extension(name);
            int n = 0;
            while (n < this.keys.length) {
                if (tmp.indexOf(this.keys[n]) >= 0) {
                    tmp = NCStringUtilities.Replace(tmp, this.keys[n], this.values[n]);
                    return tmp + "." + ext;
                }
                ++n;
            }
            return name;
        }
    }
}

