/*
 * Decompiled with CFR 0.152.
 */
package editapp;

import JCollections.JUnsafeTable;
import JWVFile.VFile;
import editapp.EditApp;
import java.io.File;
import netcomputing.tools.Platforms;

public class LibraryRepository {
    JUnsafeTable table = new JUnsafeTable(13);

    public void setLibraryPath(String name, String path) {
        this.table.put(name, path);
    }

    public String getLibraryPath(String name) {
        String result = (String)this.table.get(name);
        if (result == null) {
            if ("workspace".equals(name)) {
                return EditApp.currentProject.getPath();
            }
            if ("swing".equals(name)) {
                if (Platforms.IsJDK12("" + EditApp.App.getWorkspaceProperty("Directory.jdkHome"))) {
                    return this.getLibraryPath("classes");
                }
                result = (String)EditApp.App.getWorkspaceProperty("Library.Swing");
                if (result == null || !new File(result).exists()) {
                    result = VFile.ResolveName("#jxebase/lib/swingall.jar");
                }
                EditApp.App.setWorkspaceProperty("Library.Swing", result);
            } else if ("aelfred".equals(name)) {
                result = VFile.ResolveName("#jxebase/lib/aelfred.jar");
            } else if ("servlet".equals(name)) {
                result = (String)EditApp.App.getWorkspaceProperty("Library.ServletSDK");
                if (result == null || !new File(result).exists()) {
                    result = VFile.ResolveName("#jxebase/lib/tomcat/lib/servlet.jar");
                }
                EditApp.App.setWorkspaceProperty("Library.ServletSDK", result);
            } else if ("tools".equals(name)) {
                result = (String)EditApp.App.getWorkspaceProperty("Library.Tools");
                if (result == null || !new File(result).exists()) {
                    result = Platforms.GetToolsJar((String)EditApp.App.getWorkspaceProperty("Directory.jdkHome"));
                }
                EditApp.App.setWorkspaceProperty("Library.Tools", result);
            } else if ("classes".equals(name)) {
                result = (String)EditApp.App.getWorkspaceProperty("Library.Classes");
                if (result == null || !new File(result).exists()) {
                    result = Platforms.GetClassesZip((String)EditApp.App.getWorkspaceProperty("Directory.jdkHome"));
                }
                EditApp.App.setWorkspaceProperty("Library.Classes", result);
            } else if ("runtime".equals(name)) {
                result = VFile.ResolveName("#jxebase/lib/runtime");
            }
        }
        return result;
    }

    public String getLibrarySourcePath(String name) {
        String result = (String)this.table.get(name + "src");
        if (result == null) {
            if ("runtime".equals(name)) {
                result = VFile.ResolveName("#jxebase/lib/runtime");
            } else if ("swing".equals(name)) {
                if (Platforms.IsJDK12("" + EditApp.App.getWorkspaceProperty("Directory.jdkHome"))) {
                    return this.getLibrarySourcePath("classes");
                }
                result = (String)EditApp.App.getWorkspaceProperty("Library.Source.Swing");
                if (result == null || !new File(result).exists()) {
                    return this.getLibraryPath(name);
                }
            } else if ("servlet".equals(name)) {
                result = (String)EditApp.App.getWorkspaceProperty("Library.Source.ServletSDK");
                if (result == null || !new File(result).exists()) {
                    return this.getLibraryPath(name);
                }
            } else if ("classes".equals(name)) {
                result = (String)EditApp.App.getWorkspaceProperty("Library.Source.Classes");
                if (result == null || !new File(result).exists()) {
                    return this.getLibraryPath(name);
                }
            } else {
                return this.getLibraryPath(name);
            }
        }
        return result;
    }
}

