/*
 * Decompiled with CFR 0.152.
 */
package editapp.stringstore;

import de.netcomputing.util.Tracer;
import editapp.stringstore.IStringStore;
import editapp.stringstore.JavaStringStore;
import netcomputing.tools.Platforms;

public class StringStore {
    static final int CS = 3000;
    static IStringStore store;
    static String[] cacheString;
    static int[] cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Reset() {
        IStringStore iStringStore = store;
        synchronized (iStringStore) {
            if (store instanceof JavaStringStore) {
                ((JavaStringStore)store).reset();
            }
            cacheString = new String[3000];
            cache = new int[3000];
        }
    }

    public static IStringStore GetStore() {
        if (store == null) {
            store = new JavaStringStore();
            Tracer.This.println("created STORE:" + store.getClass().getName() + " " + Platforms.IsMSVM());
        }
        return store;
    }

    public static synchronized int addString(String s) {
        try {
            int id = StringStore.GetStore().addString(s);
            return id;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static synchronized String getString(int id) {
        try {
            if (cache[id % 3000] == id) {
                return cacheString[id % 3000];
            }
            String s = StringStore.GetStore().getString(id);
            if (s == null) {
                return null;
            }
            StringStore.cache[id % 3000] = id;
            StringStore.cacheString[id % 3000] = s;
            return s;
        }
        catch (Exception e) {
            System.out.println("Source Database invalid, pls delete files");
            return "null";
        }
    }

    public static void saveTo(String file2) {
        StringStore.GetStore().saveTo(file2);
    }

    public static void loadFrom(String file2) throws Exception {
        Tracer.This.println("**** LoadFrom ****" + file2);
        store = null;
        StringStore.GetStore().readFrom(file2);
    }

    static {
        cacheString = new String[3000];
        cache = new int[3000];
    }
}

