/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.ComboBoxItem;
import horst.Element;
import horst.HTMLPane;
import horst.Utilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class FormProcessor
implements ActionListener,
KeyListener {
    Vector m_comps = new Vector();
    Vector m_submits = new Vector();
    Hashtable m_atts;
    HTMLPane m_renderer;

    public FormProcessor(HTMLPane renderer, Hashtable atts) {
        this.m_renderer = renderer;
        this.m_atts = atts;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JButton) {
            JButton btn = (JButton)src;
            String method = (String)this.m_atts.get("method");
            String action = (String)this.m_atts.get("action");
            if (action != null) {
                String formString = this.getFormString();
                if (method != null && method.equalsIgnoreCase("POST")) {
                    URL u = Utilities.getURL(action);
                    if (u != null) {
                        try {
                            URLConnection conn = u.openConnection();
                            conn.setDoInput(true);
                            conn.setDoOutput(true);
                            conn.setUseCaches(false);
                            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            DataOutputStream printout = new DataOutputStream(conn.getOutputStream());
                            printout.writeBytes(formString);
                            printout.close();
                            DataInputStream input = new DataInputStream(conn.getInputStream());
                            InputStreamReader reader = new InputStreamReader(input);
                            this.m_renderer.openPage(reader, u);
                        }
                        catch (IOException ex) {}
                    }
                } else {
                    formString = "?" + formString;
                    URL u = Utilities.getURL(action + formString);
                    if (u == null && this.m_renderer != null) {
                        u = Utilities.getURL(this.m_renderer.getDocument().getBaseURL(), action + formString);
                    }
                    this.m_renderer.openPage(u);
                }
            }
        }
    }

    void addComponent(Element e) {
        this.m_comps.addElement(e);
        Component c = (Component)e.getAttribute("component");
        String type = (String)e.getAttribute("type");
        if (type != null && (type.equalsIgnoreCase("submit") || type.equalsIgnoreCase("image")) && c != null && c instanceof JButton) {
            this.m_submits.addElement(c);
            ((JButton)c).addActionListener(this);
        }
        if (c instanceof JTextField) {
            ((JTextField)c).addKeyListener(this);
        }
    }

    Hashtable getComponentAttributes(Component c) {
        Enumeration e = this.m_comps.elements();
        while (e.hasMoreElements()) {
            Element e1 = (Element)e.nextElement();
            Component c1 = (Component)e1.getAttribute("component");
            if (c1 != c) continue;
            return e1.getAttributes();
        }
        return null;
    }

    public Vector getComponents() {
        return this.m_comps;
    }

    public Hashtable getFormAttributes() {
        return this.m_atts;
    }

    String getFormString() {
        String str = "";
        int nCount = 0;
        Enumeration e = this.m_comps.elements();
        while (e.hasMoreElements()) {
            Element e1 = (Element)e.nextElement();
            Component c1 = (Component)e1.getAttribute("component");
            if (c1 != null && this.m_submits.contains(c1)) continue;
            String type = (String)e1.getAttribute("type");
            String name = (String)e1.getAttribute("name");
            String value = "";
            if (c1 != null && c1 instanceof JTextField) {
                value = ((JTextField)c1).getText();
            } else if (c1 instanceof JComboBox) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)((JComboBox)c1).getModel();
                ComboBoxItem item = (ComboBoxItem)model.getSelectedItem();
                if (item != null) {
                    value = (String)item.m_atts.get("value");
                }
            } else {
                value = (String)e1.getAttribute("value");
            }
            if (value == null || name == null) continue;
            value = URLEncoder.encode(value);
            str = nCount++ == 0 ? str + name + "=" + value : str + "&" + name + "=" + value;
        }
        return str;
    }

    public void keyPressed(KeyEvent keyevent) {
    }

    public void keyReleased(KeyEvent e) {
        String action;
        if (e.getKeyCode() == 10 && (action = (String)this.m_atts.get("action")) != null) {
            String formString = this.getFormString();
            URL u = Utilities.getURL(action + formString);
            if (u == null && this.m_renderer != null) {
                u = Utilities.getURL(this.m_renderer.getDocument().getBaseURL(), action + formString);
            }
            this.m_renderer.openPage(u);
        }
    }

    public void keyTyped(KeyEvent keyevent) {
    }
}

