/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.FloatStackItem;
import java.awt.Rectangle;
import java.util.Stack;
import java.util.Vector;

public class LayoutInfo {
    private Stack left = new Stack();
    private Stack right = new Stack();
    Vector pendingFloaters = new Vector();
    int leftMargin;
    int rightMargin;
    int insetsRight;
    int insetsLeft;
    int nPageBreaks;
    int pageBreakHeight = 40;
    int pageHeight = 300;
    int pageWidth;
    Rectangle pageBreak = new Rectangle(0, this.pageHeight, Integer.MAX_VALUE, this.pageBreakHeight);
    boolean bPaginate = false;

    void clear() {
        this.left.removeAllElements();
        this.right.removeAllElements();
        this.leftMargin = 0;
        this.rightMargin = 0;
        this.nPageBreaks = 0;
        this.pageBreak = new Rectangle(0, this.pageHeight, Integer.MAX_VALUE, this.pageBreakHeight);
    }

    int clearLeftMargin() {
        int yEnd = -1;
        while (this.left.size() > 0) {
            FloatStackItem item = (FloatStackItem)this.left.pop();
            yEnd = Math.max(yEnd, item.yEnd);
        }
        this.leftMargin = 0;
        return yEnd;
    }

    int clearMargins() {
        int leftEnd = this.clearLeftMargin();
        int rightEnd = this.clearRightMargin();
        return Math.max(rightEnd, leftEnd);
    }

    int clearRightMargin() {
        int yEnd = -1;
        while (this.right.size() > 0) {
            FloatStackItem item = (FloatStackItem)this.right.pop();
            yEnd = Math.max(yEnd, item.yEnd);
        }
        this.rightMargin = 0;
        return yEnd;
    }

    void decreaseInsetsLeft(int amount) {
        this.insetsLeft -= amount;
        if (this.insetsLeft < 0) {
            this.insetsLeft = 0;
        }
    }

    void decreaseInsetsRight(int amount) {
        this.insetsRight -= amount;
        if (this.insetsRight < 0) {
            this.insetsRight = 0;
        }
    }

    int getLeftYEnd() {
        if (this.left.size() > 0) {
            FloatStackItem item = (FloatStackItem)this.left.peek();
            return item.yEnd;
        }
        return -1;
    }

    int getRightYEnd() {
        if (this.right.size() > 0) {
            FloatStackItem item = (FloatStackItem)this.right.peek();
            return item.yEnd;
        }
        return -1;
    }

    void increaseInsetsLeft(int amount) {
        this.insetsLeft += amount;
    }

    void increaseInsetsRight(int amount) {
        this.insetsRight += amount;
    }

    FloatStackItem popLeft() {
        FloatStackItem item = null;
        if (this.left.size() > 0) {
            item = (FloatStackItem)this.left.pop();
            this.leftMargin -= item.width;
            this.leftMargin = Math.max(0, this.leftMargin);
        }
        return item;
    }

    FloatStackItem popRight() {
        FloatStackItem item = null;
        if (this.right.size() > 0) {
            item = (FloatStackItem)this.right.pop();
            this.rightMargin -= item.width;
            this.rightMargin = Math.max(0, this.rightMargin);
        }
        return item;
    }

    void pushLeft(FloatStackItem item) {
        this.leftMargin += item.width;
        this.left.push(item);
    }

    void pushRight(FloatStackItem item) {
        this.rightMargin += item.width;
        this.right.push(item);
    }

    void setPageBreak(int y) {
        if (this.bPaginate) {
            int start = this.pageHeight;
            int end = start + this.pageBreakHeight;
            while (true) {
                if (y >= start && y <= end || y < start) {
                    this.pageBreak.setBounds(0, start, Integer.MAX_VALUE, this.pageBreakHeight);
                    return;
                }
                start = end + this.pageHeight;
                end = start + this.pageBreakHeight;
            }
        }
    }
}

