/*
 * Decompiled with CFR 0.152.
 */
package horst;

import de.netcomputing.util.Tracer;
import horst.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class URLClassLoader
extends ClassLoader {
    private Hashtable classes = new Hashtable();
    private String urlString;
    private char classNameReplacementChar;
    private boolean bReadingJar;

    protected String formatClassName(String className) {
        if (this.classNameReplacementChar == '\u0000') {
            return className.replace('.', '/') + ".class";
        }
        return className.replace('.', this.classNameReplacementChar) + ".class";
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        Class<?> result = (Class<?>)this.classes.get(className);
        if (result != null) {
            return result;
        }
        byte[] classBytes = null;
        try {
            result = super.findSystemClass(className);
            return result;
        }
        catch (ClassNotFoundException ex) {
            classBytes = this.loadClassBytes(className);
            if (classBytes == null) {
                throw new ClassNotFoundException();
            }
            result = this.defineClass(classBytes, 0, classBytes.length);
            if (result == null) {
                throw new ClassFormatError();
            }
            if (resolveIt) {
                Tracer.This.println("resolving : " + result);
                this.resolveClass(result);
            }
            this.classes.put(className, result);
            return result;
        }
    }

    protected byte[] loadClassBytes(String className) {
        className = this.formatClassName(className);
        if (this.bReadingJar) {
            return this.readJAREntry(className);
        }
        try {
            URL url = new URL(this.urlString + "/" + className);
            URLConnection connection = url.openConnection();
            InputStream inputStream = connection.getInputStream();
            int length = connection.getContentLength();
            byte[] data = new byte[length];
            int numRead = 0;
            do {
                try {
                    numRead += inputStream.read(data, numRead, length - numRead);
                }
                catch (IOException ioe) {
                    Tracer.This.println("URLClassLoader :" + ioe.getMessage());
                    break;
                }
            } while (numRead < length);
            inputStream.close();
            return data;
        }
        catch (Exception ex) {
            Tracer.This.print("### URLClassLoader.loadClassBytes() - Exception:");
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void loadJAR(String base, String jarFile) {
        this.bReadingJar = true;
        separator = "/";
        jarStr = "";
        jarStr = base.endsWith(separator) != false ? base + jarFile : base + separator + jarFile;
        this.setURLString(jarStr);
        u = Utilities.getURL(jarStr);
        if (u != null) {
            try {
                is = new ZipInputStream(u.openStream());
                zipEntry = null;
                while ((zipEntry = is.getNextEntry()) != null) {
                    className = zipEntry.getName();
                    if (!className.endsWith(".class") || (result = (Class<?>)this.classes.get(className = className.substring(0, (len = className.length()) - 6))) != null) continue;
                    try {
                        result = super.findSystemClass(className);
                        continue;
                    }
                    catch (ClassNotFoundException ex) {
                        out = new ByteArrayOutputStream();
                        currByte = 0;
                        ** while ((currByte = is.read()) >= 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        out.write(currByte);
                        continue;
                    }
lbl23:
                    // 1 sources

                    classBytes = out.toByteArray();
                    Tracer.This.println("className=" + className);
                    result = this.defineClass(classBytes, 0, classBytes.length);
                    if (result == null) continue;
                    this.classes.put(className, result);
                }
                is.close();
            }
            catch (ZipException ex) {
                Tracer.This.println("ZipException!");
            }
            catch (IOException ex) {
                Tracer.This.println("IOException!");
            }
        }
        this.bReadingJar = false;
    }

    byte[] readJAREntry(String className) {
        byte[] classBytes = new byte[]{};
        try {
            URL u = Utilities.getURL(this.urlString);
            ZipInputStream is = new ZipInputStream(u.openStream());
            ZipEntry zipEntry = null;
            while ((zipEntry = is.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (!entryName.equalsIgnoreCase(className)) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int currByte = 0;
                while ((currByte = is.read()) >= 0) {
                    out.write(currByte);
                }
                classBytes = out.toByteArray();
                break;
            }
            is.close();
        }
        catch (ZipException ex) {
            Tracer.This.println("readJAREntry ZipException!");
        }
        catch (IOException ex) {
            Tracer.This.println("readJAREntry IOException!");
        }
        return classBytes;
    }

    public void setClassNameReplacementChar(char replacement) {
        this.classNameReplacementChar = replacement;
    }

    void setURLString(String url) {
        this.urlString = url;
    }
}

