/*
 * Decompiled with CFR 0.152.
 */
package jazzware.freestyle;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jazzware.freestyle.JWGradientVisual;
import jazzware.freestyle.JWUtil;

public class JWColorWheelVisual
extends JWGradientVisual {
    protected float brightness = 1.0f;
    static final int[] dj = new int[]{72, 304, 36, 268, 18, 322};

    public JWColorWheelVisual() {
        this(1.0f, (Color)null);
    }

    public JWColorWheelVisual(float brightness) {
        this(brightness, (Color)null);
    }

    public JWColorWheelVisual(float brightness, Color color) {
        this.setBrightness(brightness);
        this.setBackground(color);
    }

    public JWColorWheelVisual(Color color) {
        this.setColor(color);
    }

    public void setBrightness(float brightness) {
        if (brightness > 1.0f) {
            brightness = 1.0f;
        }
        if (brightness < 0.0f) {
            brightness = 0.0f;
        }
        if (this.brightness != brightness) {
            this.invalidate();
        }
        this.brightness = brightness;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBackground(Color color) {
        if (JWUtil.changed(this.startcolor, color)) {
            this.invalidate();
        }
        this.startcolor = color;
    }

    public Color getBackground() {
        return this.startcolor;
    }

    public int getBackgroundRGB() {
        return this.startcolor != null ? this.startcolor.getRGB() : 0;
    }

    public boolean setColor(Color color) {
        return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public boolean setColor(int rgb) {
        return this.setColor(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public boolean setColor(int red, int green, int blue) {
        this.setBrightness((float)(green > red || blue > red ? (green > blue ? green : blue) : red) / 255.0f);
        return this.image == null;
    }

    public Point getHotspot(Color color) {
        return this.getHotspot(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Point getHotspot(int red, int green, int blue) {
        Point hotspot = new Point(0, 0);
        if (this.width <= 0 || this.height <= 0) {
            return hotspot;
        }
        float[] hsb = Color.RGBtoHSB(red, green, blue, null);
        double ang = ((double)(this.rotation + hsb[0]) + 0.25) * (double)JWGradientVisual.PI2;
        hotspot.x = (int)(((double)this.width + Math.cos(ang) * (double)hsb[1] * (double)this.width) / 2.0);
        hotspot.y = (int)(((double)this.height + -Math.sin(ang) * (double)hsb[1] * (double)this.height) / 2.0);
        return hotspot;
    }

    public Color getColor(int x, int y) {
        if (this.width <= 0 || this.height <= 0) {
            return new Color((int)((double)this.brightness * 255.99), (int)((double)this.brightness * 255.99), (int)((double)this.brightness * 255.99));
        }
        return new Color(this.getRGB(x, y));
    }

    public int getRGB(int x, int y) {
        return this.getRGB((double)(this.width - x - x) / (double)this.width, (double)(this.height - y - y) / (double)this.height, (double)this.brightness * 255.99, this.getBackgroundRGB());
    }

    public int getDitherRGB(int x, int y, int dither) {
        return this.getDitherRGB((double)(this.width - x - x) / (double)this.width, (double)(this.height - y - y) / (double)this.height, (double)this.brightness * 255.99, this.getBackgroundRGB(), dither);
    }

    public Color getColorConstrained(int x, int y) {
        return this.getColorConstrained(x, y, this.brightness);
    }

    public Color getColorConstrained(int x, int y, float bright) {
        if (this.width <= 0 || this.height <= 0) {
            return new Color((int)((double)bright * 255.99), (int)((double)bright * 255.99), (int)((double)bright * 255.99));
        }
        double rx = (double)(this.width - x - x) / (double)this.width;
        double ry = (double)(this.height - y - y) / (double)this.height;
        double rad = Math.sqrt(rx * rx + ry * ry);
        double cx = (Math.atan2(rx, ry) + (double)this.rotation) / (double)JWGradientVisual.PI2;
        return new Color(JWColorWheelVisual.HSBtoRGB256(cx, rad > 1.0 ? 1.0 : rad, (double)bright * 255.99));
    }

    public static int HSBtoRGB256(double hue, double sat, double bri256) {
        if (sat == 0.0) {
            return 0xFF000000 | (int)bri256 << 16 | (int)bri256 << 8 | (int)bri256;
        }
        hue = (hue - Math.floor(hue)) * 6.0;
        int d = dj[(int)hue];
        hue -= Math.floor(hue);
        return 0xFF000000 | (int)bri256 << (d >> 2 & 0x18) | (int)(bri256 * (1.0 - sat * ((d & 0x100) != 0 ? hue : 1.0 - hue))) << (d & 0x18) | (int)(bri256 * (1.0 - sat)) << (d << 2 & 0x18);
    }

    public int getDitherRGB(double rx, double ry, double bri256, int col, double dither) {
        double rad = Math.sqrt(rx * rx + ry * ry);
        double cx = (Math.atan2(rx, ry) + (double)this.rotation) / (double)JWGradientVisual.PI2;
        if ((bri256 += (double)(JWGradientVisual.rand = JWGradientVisual.rand * 7621 + 1 & Short.MAX_VALUE) / dither) > 255.99) {
            bri256 = 255.99;
        }
        return rad > 1.0 ? col : JWColorWheelVisual.HSBtoRGB256(cx, rad, bri256);
    }

    public int getRGB(double rx, double ry, double bri256, int col) {
        double rad = Math.sqrt(rx * rx + ry * ry);
        double cx = (Math.atan2(rx, ry) + (double)this.rotation) / (double)JWGradientVisual.PI2;
        return rad > 1.0 ? col : JWColorWheelVisual.HSBtoRGB256(cx, rad, bri256);
    }

    protected void preProduction() {
        this.offset = 0;
        this.line = new int[this.width];
    }

    protected int[] produceLine(int y) {
        int rgb = this.getBackgroundRGB();
        double ry = (double)(this.height - y - y) / (double)this.height;
        double bri = (double)this.brightness * 255.99;
        if (this.dither != 0) {
            int idx = 0;
            while (idx < this.width) {
                this.line[idx] = this.getRGB((double)(this.width - idx - idx) / (double)this.width, ry, bri, rgb);
                ++idx;
            }
        } else {
            int idx = 0;
            while (idx < this.width) {
                this.line[idx] = this.getDitherRGB((double)(this.width - idx - idx) / (double)this.width, ry, bri, rgb, (double)this.dither * 1000.0);
                ++idx;
            }
        }
        return this.line;
    }

    public void paint(Graphics g, int width, int height) {
        super.paint(g, width, height);
    }

    public boolean isOpaque() {
        return (this.getBackgroundRGB() >> 24 & 0xFF) == 255;
    }
}

