/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.AttributeOwnerComponent;
import koala.dynamicjava.classfile.CodeAttribute;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.ExceptionsAttribute;
import koala.dynamicjava.classfile.JVMUtilities;

public class MethodInfo
extends AttributeOwnerComponent {
    private short descriptorIndex;

    public MethodInfo(ConstantPool constantPool, String string, String string2, String[] stringArray) {
        this.constantPool = constantPool;
        this.nameIndex = this.constantPool.putUTF8(string2);
        this.setSignature(string, stringArray);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.descriptorIndex);
        dataOutputStream.writeShort(this.attributes.size());
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            ((AttributeInfo)iterator.next()).write(dataOutputStream);
        }
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public void setPublic() {
        this.accessFlags = (short)(this.accessFlags | 1);
    }

    public void setPrivate() {
        this.accessFlags = (short)(this.accessFlags | 2);
    }

    public void setProtected() {
        this.accessFlags = (short)(this.accessFlags | 4);
    }

    public void setStatic() {
        this.accessFlags = (short)(this.accessFlags | 8);
    }

    public void setFinal() {
        this.accessFlags = (short)(this.accessFlags | 0x10);
    }

    public void setSynchronized() {
        this.accessFlags = (short)(this.accessFlags | 0x20);
    }

    public void setNative() {
        this.accessFlags = (short)(this.accessFlags | 0x100);
    }

    public void setAbstract() {
        this.accessFlags = (short)(this.accessFlags | 0x400);
    }

    public void setStrict() {
        this.accessFlags = (short)(this.accessFlags | 0x800);
    }

    public ExceptionsAttribute createExceptionsAttribute() {
        ExceptionsAttribute exceptionsAttribute = new ExceptionsAttribute(this.constantPool);
        this.attributes.add(exceptionsAttribute);
        return exceptionsAttribute;
    }

    public CodeAttribute createCodeAttribute() {
        CodeAttribute codeAttribute = new CodeAttribute(this.constantPool);
        this.attributes.add(codeAttribute);
        return codeAttribute;
    }

    private void setSignature(String string, String[] stringArray) {
        String string2 = JVMUtilities.getReturnTypeName(string);
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = JVMUtilities.getParameterTypeName(stringArray[n]);
            ++n;
        }
        String string3 = JVMUtilities.createMethodDescriptor(string2, stringArray2);
        this.descriptorIndex = this.constantPool.putUTF8(string3);
    }
}

