/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.classfile.InnerClassesEntry;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.ClassInfoUtilities;
import koala.dynamicjava.classinfo.ConstructorInfo;
import koala.dynamicjava.classinfo.FieldInfo;
import koala.dynamicjava.classinfo.JavaClassInfo;
import koala.dynamicjava.classinfo.MethodInfo;
import koala.dynamicjava.classinfo.TreeClassInfo;
import koala.dynamicjava.classinfo.TreeConstructorInfo;
import koala.dynamicjava.interpreter.ClassFactory;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TreeClassFinder;
import koala.dynamicjava.interpreter.TreeClassLoader;
import koala.dynamicjava.interpreter.TreeInterpreter;
import koala.dynamicjava.interpreter.context.VariableContext;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BooleanLiteral;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoubleLiteral;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldAccess;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FloatLiteral;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.IntegerLiteral;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.LongLiteral;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnaryExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VoidType;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.AmbiguousFieldException;
import koala.dynamicjava.util.ImportationManager;

public class ClassInfoCompiler {
    protected TreeClassInfo classInfo;
    protected TypeDeclaration typeDeclaration;
    protected ClassFactory classFactory;
    protected TreeClassFinder classFinder;
    protected TreeInterpreter interpreter;
    protected boolean isInterface;
    protected boolean hasAbstractMethod;
    protected List classInitializer = new LinkedList();
    protected List instanceInitializer = new LinkedList();
    protected MembersVisitor membersVisitor = new MembersVisitor();
    protected ImportationManager importationManager;

    public ClassInfoCompiler(ClassInfo classInfo) {
        this.classInfo = (TreeClassInfo)classInfo;
        this.typeDeclaration = this.classInfo.getTypeDeclaration();
        this.classFinder = (TreeClassFinder)this.classInfo.getClassFinder();
        this.importationManager = classInfo.getDeclaringClass() != null ? this.classFinder.getImportationManager() : (ImportationManager)this.classFinder.getImportationManager().clone();
        this.interpreter = (TreeInterpreter)this.classFinder.getInterpreter();
        this.isInterface = this.classInfo.isInterface();
    }

    public Class compile() {
        Object object;
        Object object2;
        ClassInfo classInfo = this.classInfo.getDeclaringClass();
        String string = classInfo != null ? classInfo.getName() : null;
        int n = this.typeDeclaration.getAccessFlags();
        String string2 = this.classInfo.getName();
        if (this.isInterface) {
            n |= 0x200;
        }
        this.classFactory = new ClassFactory(n, string2, this.classInfo.getSuperclass().getName(), this.interpreter.getClass(), this.interpreter.getExceptionClass(), this.interpreter.getClassLoader().toString());
        if (classInfo != null) {
            this.addInnerClassesAttribute(this.classInfo);
        }
        ClassInfo[] classInfoArray = this.classInfo.getDeclaredClasses();
        int n2 = 0;
        while (n2 < classInfoArray.length) {
            object2 = classInfoArray[n2].getName();
            InnerClassesEntry innerClassesEntry = this.classFactory.addInnerClassesEntry();
            innerClassesEntry.setInnerClassInfo((String)object2);
            innerClassesEntry.setOuterClassInfo(string2);
            innerClassesEntry.setInnerName(((String)object2).substring(string2.length() + 1, ((String)object2).length()));
            innerClassesEntry.setInnerClassAccessFlags((short)classInfoArray[n2].getModifiers());
            ++n2;
        }
        object2 = this.classInfo.getInterfaces();
        int n3 = 0;
        while (n3 < ((ClassInfo[])object2).length) {
            this.classFactory.addInterface(object2[n3].getName());
            ++n3;
        }
        Iterator iterator = this.typeDeclaration.getMembers().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this.membersVisitor);
        }
        if (!this.isInterface && this.hasAbstractMethod && !Modifier.isAbstract(n)) {
            this.typeDeclaration.setProperty("errorStrings", new String[]{string2});
            throw new ExecutionError("misplaced.abstract", this.typeDeclaration);
        }
        if (!this.isInterface) {
            object = this.classInfo.getConstructors();
            int n4 = 0;
            while (n4 < ((ConstructorInfo[])object).length) {
                this.addConstructor((TreeConstructorInfo)object[n4]);
                ++n4;
            }
        }
        if (this.classInitializer.size() > 0) {
            this.interpreter.registerMethod(this.classFactory.createClassInitializer(), new MethodDeclaration(1, new VoidType(), "<clinit>", new LinkedList(), new LinkedList(), new BlockStatement(this.classInitializer)), this.importationManager);
        }
        object = (TreeClassLoader)this.interpreter.getClassLoader();
        return ((TreeClassLoader)object).defineClass(string2, this.classFactory.getByteCode());
    }

    protected void addConstructor(TreeConstructorInfo treeConstructorInfo) {
        Object object;
        ClassInfo[] classInfoArray = treeConstructorInfo.getParameterTypes();
        String[] stringArray = new String[classInfoArray.length];
        int n = 0;
        while (n < classInfoArray.length) {
            stringArray[n] = classInfoArray[n].getName();
            ++n;
        }
        classInfoArray = treeConstructorInfo.getExceptionTypes();
        String[] stringArray2 = new String[classInfoArray.length];
        int n2 = 0;
        while (n2 < classInfoArray.length) {
            stringArray2[n2] = classInfoArray[n2].getName();
            ++n2;
        }
        String string = ClassFactory.getMethodIdentifier(this.classInfo.getName(), "<init>", stringArray, this.interpreter.getClassLoader().toString());
        ConstructorDeclaration constructorDeclaration = treeConstructorInfo.getConstructorDeclaration();
        if (!constructorDeclaration.getName().equals(this.typeDeclaration.getName())) {
            constructorDeclaration.setProperty("errorStrings", new String[]{constructorDeclaration.getName()});
            throw new ExecutionError("constructor.name", constructorDeclaration);
        }
        ConstructorInvocation constructorInvocation = constructorDeclaration.getConstructorInvocation();
        ConstructorVisitor constructorVisitor = new ConstructorVisitor();
        if (constructorInvocation != null) {
            object = constructorDeclaration.getParameters().iterator();
            while (object.hasNext()) {
                ((Node)object.next()).acceptVisitor(constructorVisitor);
            }
            constructorInvocation.acceptVisitor(constructorVisitor);
            this.interpreter.registerConstructorArguments(string, constructorDeclaration.getParameters(), constructorInvocation.getArguments(), this.importationManager);
        } else {
            this.interpreter.registerConstructorArguments(string, new LinkedList(), new LinkedList(), this.importationManager);
        }
        object = new MethodDeclaration(constructorDeclaration.getAccessFlags(), new VoidType(), "<init>", constructorDeclaration.getParameters(), new LinkedList(), new BlockStatement(constructorDeclaration.getStatements()));
        this.interpreter.registerMethod(string, (MethodDeclaration)object, this.importationManager);
        if (!constructorVisitor.superConstructor.equals(this.classInfo.getName())) {
            ListIterator listIterator = constructorDeclaration.getStatements().listIterator();
            Iterator iterator = this.instanceInitializer.iterator();
            while (iterator.hasNext()) {
                listIterator.add(iterator.next());
            }
        }
        this.classFactory.addConstructor(constructorDeclaration.getAccessFlags(), stringArray, stringArray2, constructorVisitor.superConstructor, constructorVisitor.constructorParameters);
    }

    protected void addInnerClassesAttribute(ClassInfo classInfo) {
        ClassInfo classInfo2 = classInfo.getDeclaringClass();
        while (classInfo2 != null) {
            String string = classInfo.getName();
            String string2 = classInfo2.getName();
            InnerClassesEntry innerClassesEntry = this.classFactory.addInnerClassesEntry();
            innerClassesEntry.setInnerClassInfo(string);
            innerClassesEntry.setOuterClassInfo(string2);
            innerClassesEntry.setInnerName(string.substring(string2.length() + 1, string.length()));
            innerClassesEntry.setInnerClassAccessFlags((short)classInfo.getModifiers());
            classInfo = classInfo2;
            classInfo2 = classInfo2.getDeclaringClass();
        }
    }

    protected void addToClassInitializer(Node node) {
        this.classInitializer.add(node);
    }

    protected void addToInstanceInitializer(Node node) {
        this.instanceInitializer.add(node);
    }

    protected class MembersVisitor
    extends VisitorObject {
        protected MembersVisitor() {
        }

        public Object visit(ClassInitializer classInitializer) {
            Iterator iterator = classInitializer.getBlock().getStatements().iterator();
            while (iterator.hasNext()) {
                ClassInfoCompiler.this.addToClassInitializer((Node)iterator.next());
            }
            return null;
        }

        public Object visit(InstanceInitializer instanceInitializer) {
            Iterator iterator = instanceInitializer.getBlock().getStatements().iterator();
            while (iterator.hasNext()) {
                ClassInfoCompiler.this.addToInstanceInitializer((Node)iterator.next());
            }
            return null;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object visit(FieldDeclaration fieldDeclaration) {
            Expression expression;
            FieldInfo fieldInfo = ClassInfoCompiler.this.classInfo.getField(fieldDeclaration);
            int n = fieldDeclaration.getAccessFlags();
            String string = fieldInfo.getType().getName();
            String string2 = fieldDeclaration.getName();
            if (ClassInfoCompiler.this.isInterface) {
                if (Modifier.isPrivate(n) || Modifier.isProtected(n)) {
                    fieldDeclaration.setProperty("errorStrings", new String[]{string2, ClassInfoCompiler.this.classInfo.getName()});
                    throw new ExecutionError("interface.field.modifier", fieldDeclaration);
                }
                n |= 0x19;
            }
            if ((expression = fieldDeclaration.getInitializer()) != null) {
                if (expression instanceof Literal && Modifier.isFinal(n) && Modifier.isStatic(n)) {
                    if (expression instanceof IntegerLiteral) {
                        Integer n2 = (Integer)((Literal)expression).getValue();
                        if (string.equals("byte")) {
                            if (n2.intValue() != n2.byteValue()) {
                                throw new ExecutionError("invalid.constant", fieldDeclaration);
                            }
                            ClassInfoCompiler.this.classFactory.addConstantIntField(n, string, string2, n2);
                            return null;
                        } else if (string.equals("short")) {
                            if (n2.intValue() != n2.shortValue()) {
                                throw new ExecutionError("invalid.constant", fieldDeclaration);
                            }
                            ClassInfoCompiler.this.classFactory.addConstantIntField(n, string, string2, n2);
                            return null;
                        } else if (string.equals("int")) {
                            ClassInfoCompiler.this.classFactory.addConstantIntField(n, string, string2, n2);
                            return null;
                        } else if (string.equals("long")) {
                            ClassInfoCompiler.this.classFactory.addConstantLongField(n, string, string2, new Long(n2.longValue()));
                            return null;
                        } else if (string.equals("float")) {
                            ClassInfoCompiler.this.classFactory.addConstantFloatField(n, string, string2, new Float(n2.floatValue()));
                            return null;
                        } else {
                            if (!string.equals("double")) throw new ExecutionError("invalid.constant", fieldDeclaration);
                            ClassInfoCompiler.this.classFactory.addConstantDoubleField(n, string, string2, new Double(n2.doubleValue()));
                        }
                        return null;
                    } else if (expression instanceof LongLiteral) {
                        Long l = (Long)((Literal)expression).getValue();
                        if (string.equals("long")) {
                            ClassInfoCompiler.this.classFactory.addConstantLongField(n, string, string2, new Long(l));
                            return null;
                        } else if (string.equals("float")) {
                            ClassInfoCompiler.this.classFactory.addConstantFloatField(n, string, string2, new Float(l.floatValue()));
                            return null;
                        } else {
                            if (!string.equals("double")) throw new ExecutionError("invalid.constant", fieldDeclaration);
                            ClassInfoCompiler.this.classFactory.addConstantDoubleField(n, string, string2, new Double(l.doubleValue()));
                        }
                        return null;
                    } else if (expression instanceof FloatLiteral) {
                        Float f = (Float)((Literal)expression).getValue();
                        if (string.equals("float")) {
                            ClassInfoCompiler.this.classFactory.addConstantFloatField(n, string, string2, new Float(f.floatValue()));
                            return null;
                        } else {
                            if (!string.equals("double")) throw new ExecutionError("invalid.constant", fieldDeclaration);
                            ClassInfoCompiler.this.classFactory.addConstantDoubleField(n, string, string2, new Double(f.doubleValue()));
                        }
                        return null;
                    } else if (expression instanceof DoubleLiteral) {
                        Double d = (Double)((Literal)expression).getValue();
                        if (!string.equals("double")) throw new ExecutionError("invalid.constant", fieldDeclaration);
                        ClassInfoCompiler.this.classFactory.addConstantDoubleField(n, string, string2, new Double(d));
                        return null;
                    } else if (expression instanceof BooleanLiteral) {
                        Boolean bl = (Boolean)((Literal)expression).getValue();
                        if (!string.equals("boolean")) throw new ExecutionError("invalid.constant", fieldDeclaration);
                        ClassInfoCompiler.this.classFactory.addConstantBooleanField(n, string, string2, bl);
                        return null;
                    } else {
                        String string3 = (String)((Literal)expression).getValue();
                        ClassInfoCompiler.this.classFactory.addConstantStringField(n, string, string2, string3);
                    }
                    return null;
                } else {
                    void var7_17;
                    Object object;
                    ClassInfoCompiler.this.classFactory.addField(n & 0xFFFFFFEF, string, string2);
                    Object var7_13 = null;
                    if (Modifier.isStatic(n)) {
                        object = new ReferenceType(ClassInfoCompiler.this.classInfo.getName());
                        StaticFieldAccess staticFieldAccess = new StaticFieldAccess((ReferenceType)object, string2);
                    } else {
                        object = new Identifier("this");
                        LinkedList<Object> linkedList = new LinkedList<Object>();
                        linkedList.add(object);
                        QualifiedName qualifiedName = new QualifiedName(linkedList);
                        ObjectFieldAccess objectFieldAccess = new ObjectFieldAccess(qualifiedName, string2);
                    }
                    object = new SimpleAssignExpression((Expression)var7_17, expression);
                    if (Modifier.isStatic(n)) {
                        ClassInfoCompiler.this.addToClassInitializer((Node)object);
                        return null;
                    } else {
                        ((Node)object).setProperty("instanceInitializer", null);
                        ClassInfoCompiler.this.addToInstanceInitializer((Node)object);
                    }
                }
                return null;
            } else {
                ClassInfoCompiler.this.classFactory.addField(n, string, string2);
            }
            return null;
        }

        public Object visit(MethodDeclaration methodDeclaration) {
            boolean bl;
            MethodInfo methodInfo = ClassInfoCompiler.this.classInfo.getMethod(methodDeclaration);
            int n = methodInfo.getModifiers();
            String string = methodDeclaration.getName();
            String string2 = methodInfo.getReturnType().getName();
            if (ClassInfoCompiler.this.isInterface) {
                if (Modifier.isPrivate(n) || Modifier.isProtected(n) || Modifier.isFinal(n) || Modifier.isStatic(n)) {
                    methodDeclaration.setProperty("errorStrings", new String[]{methodDeclaration.getName(), ClassInfoCompiler.this.classInfo.getName()});
                    throw new ExecutionError("interface.method.modifier", methodDeclaration);
                }
                n |= 0x401;
                bl = true;
            } else {
                bl = Modifier.isAbstract(n);
            }
            ClassInfoCompiler.this.hasAbstractMethod |= bl;
            ClassInfo[] classInfoArray = methodInfo.getParameterTypes();
            String[] stringArray = new String[classInfoArray.length];
            int n2 = 0;
            while (n2 < classInfoArray.length) {
                stringArray[n2] = classInfoArray[n2].getName();
                ++n2;
            }
            classInfoArray = methodInfo.getExceptionTypes();
            String[] stringArray2 = new String[classInfoArray.length];
            int n3 = 0;
            while (n3 < classInfoArray.length) {
                stringArray2[n3] = classInfoArray[n3].getName();
                ++n3;
            }
            ClassInfoCompiler.this.classFactory.addMethod(n, string2, string, stringArray, stringArray2);
            if (!ClassInfoCompiler.this.isInterface && !bl && this.isRedefinedMethod(methodInfo)) {
                ClassInfoCompiler.this.classFactory.addSuperMethodAccessor(n, string2, string, stringArray, stringArray2);
            }
            BlockStatement blockStatement = methodDeclaration.getBody();
            if (bl && blockStatement != null || ClassInfoCompiler.this.isInterface && blockStatement != null) {
                methodDeclaration.setProperty("errorStrings", new String[]{methodDeclaration.getName()});
                throw new ExecutionError("abstract.method.body", methodDeclaration);
            }
            if (!bl && blockStatement == null) {
                methodDeclaration.setProperty("errorStrings", new String[]{methodDeclaration.getName()});
                throw new ExecutionError("missing.method.body", methodDeclaration);
            }
            if (blockStatement != null) {
                String string3 = ClassFactory.getMethodIdentifier(ClassInfoCompiler.this.classInfo.getName(), string, stringArray, ClassInfoCompiler.this.interpreter.getClassLoader().toString());
                ClassInfoCompiler.this.interpreter.registerMethod(string3, methodDeclaration, ClassInfoCompiler.this.importationManager);
            }
            return null;
        }

        protected boolean isRedefinedMethod(MethodInfo methodInfo) {
            ClassInfo classInfo = ClassInfoCompiler.this.classInfo.getSuperclass();
            String string = methodInfo.getName();
            ClassInfo[] classInfoArray = methodInfo.getParameterTypes();
            while (classInfo != null) {
                MethodInfo[] methodInfoArray = classInfo.getMethods();
                int n = 0;
                while (n < methodInfoArray.length) {
                    block5: {
                        ClassInfo[] classInfoArray2;
                        if (methodInfoArray[n].getName().equals(string) && (classInfoArray2 = methodInfoArray[n].getParameterTypes()).length == classInfoArray.length) {
                            int n2 = 0;
                            while (n2 < classInfoArray2.length) {
                                if (classInfoArray2[n2].equals(classInfoArray[n2])) {
                                    ++n2;
                                    continue;
                                }
                                break block5;
                            }
                            return true;
                        }
                    }
                    ++n;
                }
                classInfo = classInfo.getSuperclass();
            }
            return false;
        }
    }

    protected class ConstructorVisitor
    extends VisitorObject {
        String superConstructor;
        String[] constructorParameters = new String[0];
        VariableContext context = new VariableContext();
        static /* synthetic */ Class class$java$lang$Object;
        static /* synthetic */ Class class$java$lang$String;

        protected ConstructorVisitor() {
        }

        public Object visit(ConstructorInvocation constructorInvocation) {
            Object object;
            Object object2;
            ListIterator<Object> listIterator;
            LinkedList<Expression> linkedList;
            Expression expression = constructorInvocation.getExpression();
            if (expression == null) {
                linkedList = ClassInfoCompiler.this.classInfo.getSuperclass();
                listIterator = linkedList.getDeclaringClass();
                object2 = ClassInfoCompiler.this.classInfo.getDeclaringClass();
                if (object2 != null && object2.equals(listIterator) && !Modifier.isStatic(linkedList.getModifiers())) {
                    object = new LinkedList();
                    object.add(new Identifier("param$0"));
                    expression = new QualifiedName((List)object);
                    constructorInvocation.setExpression(expression);
                } else if (listIterator != null && listIterator.equals(ClassInfoCompiler.this.classInfo.getAnonymousDeclaringClass()) && !Modifier.isStatic(linkedList.getModifiers())) {
                    object = new LinkedList();
                    object.add(new Identifier("param$0"));
                    expression = new QualifiedName((List)object);
                    constructorInvocation.setExpression(expression);
                }
            }
            linkedList = constructorInvocation.getArguments();
            if (expression != null) {
                if (linkedList == null) {
                    linkedList = new LinkedList<Expression>();
                    constructorInvocation.setArguments(linkedList);
                }
                linkedList.add(0, expression);
            }
            if (linkedList != null) {
                int n;
                listIterator = linkedList.listIterator();
                while (listIterator.hasNext()) {
                    object2 = ((Expression)listIterator.next()).acceptVisitor(this);
                    if (object2 == null) continue;
                    if (object2 instanceof Expression) {
                        listIterator.set(object2);
                        continue;
                    }
                    throw new ExecutionError("malformed.argument", constructorInvocation);
                }
                object2 = null;
                try {
                    object = null;
                    listIterator = linkedList.listIterator();
                    n = 0;
                    object = new ClassInfo[linkedList.size()];
                    while (listIterator.hasNext()) {
                        object[n++] = NodeProperties.getClassInfo((Expression)listIterator.next());
                    }
                    if (constructorInvocation.isSuper()) {
                        ClassInfo classInfo = ClassInfoCompiler.this.classInfo.getSuperclass();
                        object2 = ClassInfoUtilities.lookupConstructor(classInfo, (ClassInfo[])object);
                        this.superConstructor = classInfo.getName();
                    } else {
                        object2 = ClassInfoUtilities.lookupConstructor(ClassInfoCompiler.this.classInfo, (ClassInfo[])object);
                        this.superConstructor = ClassInfoCompiler.this.classInfo.getName();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new CatchedExceptionError(noSuchMethodException, (Node)constructorInvocation);
                }
                object = object2.getParameterTypes();
                this.constructorParameters = new String[((Object)object).length];
                n = 0;
                while (n < ((Object)object).length) {
                    this.constructorParameters[n] = object[n].getName();
                    ++n;
                }
            }
            if (this.superConstructor == null) {
                listIterator = ClassInfoCompiler.this.classInfo.getSuperclass();
                this.superConstructor = listIterator.getName();
            }
            return null;
        }

        public Object visit(PrimitiveType primitiveType) {
            JavaClassInfo javaClassInfo = new JavaClassInfo(primitiveType.getValue());
            primitiveType.setProperty("type", javaClassInfo);
            return javaClassInfo;
        }

        public Object visit(ReferenceType referenceType) {
            ClassInfo classInfo = null;
            String string = referenceType.getRepresentation();
            try {
                classInfo = ClassInfoCompiler.this.classFinder.lookupClass(string, ClassInfoCompiler.this.classInfo);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CatchedExceptionError(classNotFoundException, (Node)referenceType);
            }
            referenceType.setProperty("type", classInfo);
            return classInfo;
        }

        public Object visit(ArrayType arrayType) {
            Type type = arrayType.getElementType();
            type.acceptVisitor(this);
            ClassInfo classInfo = NodeProperties.getClassInfo(type);
            ClassInfo classInfo2 = classInfo instanceof JavaClassInfo ? new JavaClassInfo((JavaClassInfo)classInfo) : new TreeClassInfo((TreeClassInfo)classInfo);
            arrayType.setProperty("type", classInfo2);
            return classInfo2;
        }

        public Object visit(FormalParameter formalParameter) {
            ClassInfo classInfo = (ClassInfo)formalParameter.getType().acceptVisitor(this);
            if (formalParameter.isFinal()) {
                this.context.defineConstant(formalParameter.getName(), classInfo);
            } else {
                this.context.define(formalParameter.getName(), classInfo);
            }
            return null;
        }

        public Object visit(Literal literal) {
            Class clazz = literal.getType();
            literal.setProperty("type", clazz == null ? null : new JavaClassInfo(clazz));
            return null;
        }

        public Object visit(SimpleAssignExpression simpleAssignExpression) {
            Expression expression = simpleAssignExpression.getLeftExpression();
            Object object = expression.acceptVisitor(this);
            if (object != null) {
                if (object instanceof Expression) {
                    Expression expression2;
                    expression = expression2 = (Expression)object;
                    simpleAssignExpression.setLeftExpression(expression2);
                } else {
                    throw new ExecutionError("left.expression", simpleAssignExpression);
                }
            }
            simpleAssignExpression.setProperty("type", NodeProperties.getClassInfo(expression));
            return null;
        }

        public Object visit(ObjectFieldAccess objectFieldAccess) {
            ClassInfo classInfo;
            Object object = objectFieldAccess.getExpression().acceptVisitor(this);
            if (object != null) {
                if (object instanceof Expression) {
                    objectFieldAccess.setExpression((Expression)object);
                } else {
                    StaticFieldAccess staticFieldAccess = new StaticFieldAccess((ReferenceType)object, objectFieldAccess.getFieldName());
                    ((Node)staticFieldAccess).acceptVisitor(this);
                    return staticFieldAccess;
                }
            }
            if (!(classInfo = NodeProperties.getClassInfo(objectFieldAccess.getExpression())).isArray()) {
                FieldInfo fieldInfo = null;
                try {
                    fieldInfo = ClassInfoUtilities.getField(classInfo, objectFieldAccess.getFieldName());
                }
                catch (Exception exception) {
                    throw new CatchedExceptionError(exception, (Node)objectFieldAccess);
                }
                objectFieldAccess.setProperty("type", fieldInfo.getType());
            } else {
                if (!objectFieldAccess.getFieldName().equals("length")) {
                    String string = "length";
                    String string2 = classInfo.getComponentType().getName() + " array";
                    objectFieldAccess.setProperty("errorStrings", new String[]{string, string2});
                    throw new ExecutionError("no.such.field", objectFieldAccess);
                }
                objectFieldAccess.setProperty("type", JavaClassInfo.INT);
            }
            return null;
        }

        public Object visit(StaticFieldAccess staticFieldAccess) {
            ClassInfo classInfo = (ClassInfo)staticFieldAccess.getFieldType().acceptVisitor(this);
            FieldInfo fieldInfo = null;
            try {
                fieldInfo = ClassInfoUtilities.getField(classInfo, staticFieldAccess.getFieldName());
            }
            catch (Exception exception) {
                try {
                    fieldInfo = ClassInfoUtilities.getOuterField(classInfo, staticFieldAccess.getFieldName());
                }
                catch (Exception exception2) {
                    throw new CatchedExceptionError(exception, (Node)staticFieldAccess);
                }
            }
            staticFieldAccess.setProperty("type", fieldInfo.getType());
            return null;
        }

        public Object visit(SuperFieldAccess superFieldAccess) {
            TreeClassInfo treeClassInfo = ClassInfoCompiler.this.classInfo;
            FieldInfo fieldInfo = null;
            try {
                fieldInfo = ClassInfoUtilities.getField(treeClassInfo.getSuperclass(), superFieldAccess.getFieldName());
            }
            catch (Exception exception) {
                throw new CatchedExceptionError(exception, (Node)superFieldAccess);
            }
            superFieldAccess.setProperty("type", fieldInfo.getType());
            return null;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object visit(ObjectMethodCall var1_1) {
            block8: {
                block7: {
                    if (var1_1.getExpression() == null) {
                        var2_3 = new Identifier(ClassInfoCompiler.this.classInfo.getName());
                        var3_5 = new LinkedList<Identifier>();
                        var3_5.add(var2_3);
                        var4_8 = new ReferenceType(var3_5);
                        var4_8.acceptVisitor(this);
                        var5_11 = new StaticMethodCall(var4_8, var1_1.getMethodName(), var1_1.getArguments(), var1_1.getFilename(), var1_1.getBeginLine(), var1_1.getBeginColumn(), var1_1.getEndLine(), var1_1.getEndColumn());
                        var5_11.acceptVisitor(this);
                        return var5_11;
                    }
                    var2_2 = var1_1.getExpression().acceptVisitor(this);
                    if (var2_2 != null) {
                        if (!(var2_2 instanceof Expression)) {
                            var3_4 = new StaticMethodCall((ReferenceType)var2_2, var1_1.getMethodName(), var1_1.getArguments(), var1_1.getFilename(), var1_1.getBeginLine(), var1_1.getBeginColumn(), var1_1.getEndLine(), var1_1.getEndColumn());
                            var3_4.acceptVisitor(this);
                            return var3_4;
                        }
                        var1_1.setExpression((Expression)var2_2);
                    }
                    if ((var2_2 = NodeProperties.getClassInfo(var1_1.getExpression())).isArray() && (!var2_2.isArray() || var1_1.getMethodName().equals("clone"))) break block7;
                    var3_6 = new ClassInfo[]{};
                    var4_9 = var1_1.getArguments();
                    if (var4_9 == null) break block8;
                    this.checkList(var4_9, "malformed.argument", var1_1);
                    var3_6 = new ClassInfo[var4_9.size()];
                    var5_12 = var4_9.listIterator();
                    var6_13 = 0;
                    if (true) ** GOTO lbl40
                }
                if (!var1_1.getMethodName().equals("clone") || var1_1.getArguments() != null) {
                    var3_7 = "clone";
                    var4_10 = var2_2.getComponentType().getName() + " array";
                    var1_1.setProperty("errorStrings", new String[]{var3_7, var4_10});
                    throw new ExecutionError("no.such.method", var1_1);
                }
                var1_1.setProperty("type", new JavaClassInfo(ConstructorVisitor.class$java$lang$Object == null ? (ConstructorVisitor.class$java$lang$Object = ConstructorVisitor.class$("java.lang.Object")) : ConstructorVisitor.class$java$lang$Object));
                return null;
                do {
                    var3_6[var6_13++] = NodeProperties.getClassInfo((Node)var5_12.next());
lbl40:
                    // 2 sources

                } while (var5_12.hasNext());
            }
            var5_12 = null;
            try {
                var5_12 = ClassInfoUtilities.lookupMethod((ClassInfo)var2_2, var1_1.getMethodName(), var3_6);
            }
            catch (NoSuchMethodException var6_14) {
                throw new CatchedExceptionError(var6_14, (Node)var1_1);
            }
            var1_1.setProperty("type", var5_12.getReturnType());
            return null;
        }

        public Object visit(StaticMethodCall staticMethodCall) {
            Object object;
            List list = staticMethodCall.getArguments();
            ClassInfo[] classInfoArray = new ClassInfo[]{};
            if (list != null) {
                this.checkList(list, "malformed.argument", staticMethodCall);
                classInfoArray = new ClassInfo[list.size()];
                object = list.listIterator();
                int n = 0;
                while (object.hasNext()) {
                    classInfoArray[n++] = NodeProperties.getClassInfo((Node)object.next());
                }
            }
            object = null;
            ReferenceType referenceType = staticMethodCall.getMethodType();
            ClassInfo classInfo = NodeProperties.getClassInfo(referenceType);
            try {
                object = ClassInfoUtilities.lookupMethod(classInfo, staticMethodCall.getMethodName(), classInfoArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (referenceType.getBeginLine() == referenceType.getEndLine() && referenceType.getBeginColumn() == referenceType.getEndLine()) {
                    try {
                        object = ClassInfoUtilities.lookupOuterMethod(classInfo, staticMethodCall.getMethodName(), classInfoArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        throw new CatchedExceptionError(noSuchMethodException2, (Node)staticMethodCall);
                    }
                } else {
                    throw new CatchedExceptionError(noSuchMethodException, (Node)staticMethodCall);
                }
                throw new CatchedExceptionError(noSuchMethodException, (Node)staticMethodCall);
            }
            staticMethodCall.setProperty("type", object.getReturnType());
            return null;
        }

        public Object visit(SuperMethodCall superMethodCall) {
            Object object;
            ClassInfo classInfo = ClassInfoCompiler.this.classInfo.getSuperclass();
            List list = superMethodCall.getArguments();
            ClassInfo[] classInfoArray = new ClassInfo[]{};
            if (list != null) {
                this.checkList(list, "malformed.argument", superMethodCall);
                classInfoArray = new ClassInfo[list.size()];
                object = list.listIterator();
                int n = 0;
                while (object.hasNext()) {
                    classInfoArray[n++] = NodeProperties.getClassInfo((Node)object.next());
                }
            }
            object = null;
            try {
                object = ClassInfoUtilities.lookupMethod(classInfo, superMethodCall.getMethodName(), classInfoArray);
            }
            catch (Exception exception) {
                throw new CatchedExceptionError(exception, (Node)superMethodCall);
            }
            superMethodCall.setProperty("type", object.getReturnType());
            return null;
        }

        public Object visit(QualifiedName qualifiedName) {
            Object object;
            List list = qualifiedName.getIdentifiers();
            IdentifierToken identifierToken = (IdentifierToken)list.get(0);
            if (this.context.isDefinedVariable(identifierToken.image()) || this.fieldExists(ClassInfoCompiler.this.classInfo, identifierToken.image())) {
                Object object2;
                PrimaryExpression primaryExpression = null;
                if (this.context.isDefinedVariable(identifierToken.image())) {
                    if (list.size() == 1) {
                        ClassInfo classInfo = (ClassInfo)this.context.get(identifierToken.image());
                        qualifiedName.setProperty("type", classInfo);
                        return null;
                    }
                    object2 = new LinkedList<IdentifierToken>();
                    object2.add(identifierToken);
                    primaryExpression = new QualifiedName((List)object2);
                } else {
                    primaryExpression = new StaticFieldAccess(new ReferenceType(ClassInfoCompiler.this.classInfo.getName()), identifierToken.image());
                }
                object2 = list.iterator();
                object2.next();
                while (object2.hasNext()) {
                    IdentifierToken identifierToken2 = (IdentifierToken)object2.next();
                    primaryExpression = new ObjectFieldAccess(primaryExpression, identifierToken2.image(), qualifiedName.getFilename(), identifierToken.beginLine(), identifierToken.beginColumn(), identifierToken2.endLine(), identifierToken2.endColumn());
                }
                primaryExpression.acceptVisitor(this);
                return primaryExpression;
            }
            List list2 = (List)((LinkedList)list).clone();
            boolean bl = false;
            while (list2.size() > 0) {
                object = TreeUtilities.listToName(list2);
                try {
                    ClassInfoCompiler.this.classFinder.lookupClass((String)object, ClassInfoCompiler.this.classInfo);
                    bl = true;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    list2.remove(list2.size() - 1);
                }
            }
            if (!bl) {
                qualifiedName.setProperty("errorStrings", new String[]{identifierToken.image()});
                throw new ExecutionError("undefined.class", qualifiedName);
            }
            object = (IdentifierToken)list2.get(list2.size() - 1);
            ReferenceType referenceType = new ReferenceType(list2, qualifiedName.getFilename(), identifierToken.beginLine(), identifierToken.beginColumn(), object.endLine(), object.endColumn());
            if (list2.size() != list.size()) {
                ListIterator listIterator = list.listIterator(list2.size());
                object = (IdentifierToken)listIterator.next();
                FieldAccess fieldAccess = new StaticFieldAccess(referenceType, object.image(), qualifiedName.getFilename(), identifierToken.beginLine(), identifierToken.beginColumn(), object.endLine(), object.endColumn());
                while (listIterator.hasNext()) {
                    object = (IdentifierToken)listIterator.next();
                    fieldAccess = new ObjectFieldAccess(fieldAccess, object.image(), qualifiedName.getFilename(), identifierToken.beginLine(), identifierToken.beginColumn(), object.endLine(), object.endColumn());
                }
                ((Node)fieldAccess).acceptVisitor(this);
                return fieldAccess;
            }
            referenceType.acceptVisitor(this);
            return referenceType;
        }

        public Object visit(ThisExpression thisExpression) {
            throw new ExecutionError("this.undefined", thisExpression);
        }

        public Object visit(SimpleAllocation simpleAllocation) {
            Type type = simpleAllocation.getCreationType();
            simpleAllocation.setProperty("type", type.acceptVisitor(this));
            return null;
        }

        public Object visit(ArrayAllocation arrayAllocation) {
            Type type = arrayAllocation.getCreationType();
            ClassInfo classInfo = (ClassInfo)type.acceptVisitor(this);
            int n = 0;
            while (n < arrayAllocation.getDimension()) {
                classInfo = classInfo instanceof JavaClassInfo ? new JavaClassInfo((JavaClassInfo)classInfo) : new TreeClassInfo((TreeClassInfo)classInfo);
                ++n;
            }
            arrayAllocation.setProperty("type", classInfo);
            return null;
        }

        public Object visit(ArrayAccess arrayAccess) {
            ClassInfo classInfo;
            Object object = arrayAccess.getExpression().acceptVisitor(this);
            if (object != null) {
                if (object instanceof Expression) {
                    arrayAccess.setExpression((Expression)object);
                } else {
                    throw new ExecutionError("malformed.expression", arrayAccess);
                }
            }
            if (!(classInfo = NodeProperties.getClassInfo(arrayAccess.getExpression())).isArray()) {
                arrayAccess.setProperty("errorStrings", new String[]{classInfo.getName()});
                throw new ExecutionError("array.required", arrayAccess);
            }
            arrayAccess.setProperty("type", classInfo.getComponentType());
            return null;
        }

        public Object visit(TypeExpression typeExpression) {
            typeExpression.setProperty("type", JavaClassInfo.CLASS);
            return null;
        }

        public Object visit(NotExpression notExpression) {
            notExpression.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object visit(ComplementExpression complementExpression) {
            this.visitUnaryExpression(complementExpression);
            Expression expression = complementExpression.getExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            if (!(classInfo instanceof JavaClassInfo)) throw new ExecutionError("malformed.expression", complementExpression);
            Class clazz = ((JavaClassInfo)classInfo).getJavaClass();
            if (clazz == Character.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE) {
                complementExpression.setProperty("type", JavaClassInfo.INT);
                return null;
            } else {
                if (clazz != Integer.TYPE && clazz != Long.TYPE) throw new ExecutionError("malformed.expression", complementExpression);
                complementExpression.setProperty("type", new JavaClassInfo(clazz));
            }
            return null;
        }

        public Object visit(PlusExpression plusExpression) {
            this.visitUnaryExpression(plusExpression);
            this.visitUnaryOperation(plusExpression, "malformed.expression");
            return null;
        }

        public Object visit(MinusExpression minusExpression) {
            this.visitUnaryExpression(minusExpression);
            this.visitUnaryOperation(minusExpression, "malformed.expression");
            return null;
        }

        public Object visit(AddExpression addExpression) {
            this.visitBinaryExpression(addExpression);
            Expression expression = addExpression.getLeftExpression();
            Expression expression2 = addExpression.getRightExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            ClassInfo classInfo2 = NodeProperties.getClassInfo(expression2);
            Class clazz = null;
            Class clazz2 = null;
            if (!(classInfo instanceof JavaClassInfo) || !(classInfo2 instanceof JavaClassInfo)) {
                throw new ExecutionError("addition.type", addExpression);
            }
            clazz = classInfo.getJavaClass();
            clazz2 = classInfo2.getJavaClass();
            if (clazz == (class$java$lang$String == null ? (class$java$lang$String = ConstructorVisitor.class$("java.lang.String")) : class$java$lang$String) || clazz2 == (class$java$lang$String == null ? (class$java$lang$String = ConstructorVisitor.class$("java.lang.String")) : class$java$lang$String)) {
                addExpression.setProperty("type", JavaClassInfo.STRING);
            } else {
                this.visitNumericExpression(addExpression, "addition.type");
            }
            return null;
        }

        public Object visit(AddAssignExpression addAssignExpression) {
            this.visitBinaryExpression(addAssignExpression);
            Expression expression = addAssignExpression.getLeftExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            addAssignExpression.setProperty("type", classInfo);
            return null;
        }

        public Object visit(SubtractExpression subtractExpression) {
            this.visitBinaryExpression(subtractExpression);
            this.visitNumericExpression(subtractExpression, "subtraction.type");
            return null;
        }

        public Object visit(SubtractAssignExpression subtractAssignExpression) {
            this.visitBinaryExpression(subtractAssignExpression);
            Expression expression = subtractAssignExpression.getLeftExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            subtractAssignExpression.setProperty("type", classInfo);
            return null;
        }

        public Object visit(MultiplyExpression multiplyExpression) {
            this.visitBinaryExpression(multiplyExpression);
            this.visitNumericExpression(multiplyExpression, "multiplication.type");
            return null;
        }

        public Object visit(MultiplyAssignExpression multiplyAssignExpression) {
            this.visitBinaryExpression(multiplyAssignExpression);
            Expression expression = multiplyAssignExpression.getLeftExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            multiplyAssignExpression.setProperty("type", classInfo);
            return null;
        }

        public Object visit(DivideExpression divideExpression) {
            this.visitBinaryExpression(divideExpression);
            this.visitNumericExpression(divideExpression, "division.type");
            return null;
        }

        public Object visit(DivideAssignExpression divideAssignExpression) {
            this.visitBinaryExpression(divideAssignExpression);
            Expression expression = divideAssignExpression.getLeftExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            divideAssignExpression.setProperty("type", classInfo);
            return null;
        }

        public Object visit(RemainderExpression remainderExpression) {
            this.visitBinaryExpression(remainderExpression);
            this.visitNumericExpression(remainderExpression, "remainder.type");
            return null;
        }

        public Object visit(RemainderAssignExpression remainderAssignExpression) {
            this.visitBinaryExpression(remainderAssignExpression);
            Expression expression = remainderAssignExpression.getLeftExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            remainderAssignExpression.setProperty("type", classInfo);
            return null;
        }

        public Object visit(EqualExpression equalExpression) {
            equalExpression.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        public Object visit(NotEqualExpression notEqualExpression) {
            notEqualExpression.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        public Object visit(LessExpression lessExpression) {
            lessExpression.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        public Object visit(LessOrEqualExpression lessOrEqualExpression) {
            lessOrEqualExpression.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        public Object visit(GreaterExpression greaterExpression) {
            greaterExpression.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        public Object visit(GreaterOrEqualExpression greaterOrEqualExpression) {
            greaterOrEqualExpression.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        public Object visit(BitAndExpression bitAndExpression) {
            this.visitBinaryExpression(bitAndExpression);
            this.visitBitwiseExpression(bitAndExpression, "bit.and.type");
            return null;
        }

        public Object visit(BitAndAssignExpression bitAndAssignExpression) {
            this.visitBinaryExpression(bitAndAssignExpression);
            bitAndAssignExpression.setProperty("type", NodeProperties.getClassInfo(bitAndAssignExpression.getLeftExpression()));
            return null;
        }

        public Object visit(ExclusiveOrExpression exclusiveOrExpression) {
            this.visitBinaryExpression(exclusiveOrExpression);
            this.visitBitwiseExpression(exclusiveOrExpression, "xor.type");
            return null;
        }

        public Object visit(ExclusiveOrAssignExpression exclusiveOrAssignExpression) {
            this.visitBinaryExpression(exclusiveOrAssignExpression);
            exclusiveOrAssignExpression.setProperty("type", NodeProperties.getClassInfo(exclusiveOrAssignExpression.getLeftExpression()));
            return null;
        }

        public Object visit(BitOrExpression bitOrExpression) {
            this.visitBinaryExpression(bitOrExpression);
            this.visitBitwiseExpression(bitOrExpression, "bit.or.type");
            return null;
        }

        public Object visit(BitOrAssignExpression bitOrAssignExpression) {
            this.visitBinaryExpression(bitOrAssignExpression);
            bitOrAssignExpression.setProperty("type", NodeProperties.getClassInfo(bitOrAssignExpression.getLeftExpression()));
            return null;
        }

        public Object visit(ShiftLeftExpression shiftLeftExpression) {
            this.visitBinaryExpression(shiftLeftExpression);
            this.visitShiftExpression(shiftLeftExpression, "shift.left.type");
            return null;
        }

        public Object visit(ShiftLeftAssignExpression shiftLeftAssignExpression) {
            this.visitBinaryExpression(shiftLeftAssignExpression);
            this.visitShiftExpression(shiftLeftAssignExpression, "shift.left.type");
            return null;
        }

        public Object visit(ShiftRightExpression shiftRightExpression) {
            this.visitBinaryExpression(shiftRightExpression);
            this.visitShiftExpression(shiftRightExpression, "shift.right.type");
            return null;
        }

        public Object visit(ShiftRightAssignExpression shiftRightAssignExpression) {
            this.visitBinaryExpression(shiftRightAssignExpression);
            this.visitShiftExpression(shiftRightAssignExpression, "shift.right.type");
            return null;
        }

        public Object visit(UnsignedShiftRightExpression unsignedShiftRightExpression) {
            this.visitBinaryExpression(unsignedShiftRightExpression);
            this.visitShiftExpression(unsignedShiftRightExpression, "unsigned.shift.right.type");
            return null;
        }

        public Object visit(UnsignedShiftRightAssignExpression unsignedShiftRightAssignExpression) {
            this.visitBinaryExpression(unsignedShiftRightAssignExpression);
            this.visitShiftExpression(unsignedShiftRightAssignExpression, "unsigned.shift.right.type");
            return null;
        }

        public Object visit(AndExpression andExpression) {
            andExpression.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        public Object visit(OrExpression orExpression) {
            orExpression.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        public Object visit(InstanceOfExpression instanceOfExpression) {
            instanceOfExpression.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        public Object visit(ConditionalExpression conditionalExpression) {
            Object object = conditionalExpression.getIfTrueExpression().acceptVisitor(this);
            if (object != null) {
                if (object instanceof ReferenceType) {
                    throw new ExecutionError("malformed.second.operand", conditionalExpression);
                }
                conditionalExpression.setIfTrueExpression((Expression)object);
            }
            if ((object = conditionalExpression.getIfFalseExpression().acceptVisitor(this)) != null) {
                if (object instanceof ReferenceType) {
                    throw new ExecutionError("malformed.third.operand", conditionalExpression);
                }
                conditionalExpression.setIfFalseExpression((Expression)object);
            }
            Expression expression = conditionalExpression.getIfTrueExpression();
            Expression expression2 = conditionalExpression.getIfFalseExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            ClassInfo classInfo2 = NodeProperties.getClassInfo(expression2);
            ClassInfo classInfo3 = null;
            if (classInfo == null) {
                classInfo3 = classInfo2;
            } else if (classInfo2 == null) {
                classInfo3 = classInfo;
            } else if (classInfo.equals(classInfo2)) {
                classInfo3 = classInfo;
            } else if (ClassInfoUtilities.isAssignableFrom(classInfo, classInfo2)) {
                classInfo3 = classInfo;
            } else if (ClassInfoUtilities.isAssignableFrom(classInfo2, classInfo)) {
                classInfo3 = classInfo2;
            } else {
                throw new ExecutionError("conditional.type", conditionalExpression);
            }
            conditionalExpression.setProperty("type", classInfo3);
            return null;
        }

        public Object visit(PostIncrement postIncrement) {
            this.visitUnaryExpression(postIncrement);
            Expression expression = postIncrement.getExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            if (!(classInfo instanceof JavaClassInfo)) {
                throw new ExecutionError("post.increment.type", postIncrement);
            }
            postIncrement.setProperty("type", classInfo);
            return null;
        }

        public Object visit(PreIncrement preIncrement) {
            this.visitUnaryExpression(preIncrement);
            Expression expression = preIncrement.getExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            if (!(classInfo instanceof JavaClassInfo)) {
                throw new ExecutionError("pre.increment.type", preIncrement);
            }
            preIncrement.setProperty("type", classInfo);
            return null;
        }

        public Object visit(PostDecrement postDecrement) {
            this.visitUnaryExpression(postDecrement);
            Expression expression = postDecrement.getExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            if (!(classInfo instanceof JavaClassInfo)) {
                throw new ExecutionError("post.decrement.type", postDecrement);
            }
            postDecrement.setProperty("type", classInfo);
            return null;
        }

        public Object visit(PreDecrement preDecrement) {
            this.visitUnaryExpression(preDecrement);
            Expression expression = preDecrement.getExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            if (!(classInfo instanceof JavaClassInfo)) {
                throw new ExecutionError("pre.decrement.type", preDecrement);
            }
            preDecrement.setProperty("type", classInfo);
            return null;
        }

        public Object visit(CastExpression castExpression) {
            Type type = castExpression.getTargetType();
            castExpression.setProperty("type", type.acceptVisitor(this));
            return null;
        }

        protected void visitUnaryExpression(UnaryExpression unaryExpression) {
            Object object = unaryExpression.getExpression().acceptVisitor(this);
            if (object != null) {
                if (object instanceof ReferenceType) {
                    throw new ExecutionError("malformed.expression", unaryExpression);
                }
                unaryExpression.setExpression((Expression)object);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void visitUnaryOperation(UnaryExpression unaryExpression, String string) {
            Expression expression = unaryExpression.getExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            if (!classInfo.isPrimitive()) throw new ExecutionError(string, unaryExpression);
            Class clazz = classInfo.getJavaClass();
            if (clazz == Character.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE) {
                unaryExpression.setProperty("type", JavaClassInfo.INT);
                return;
            } else {
                if (clazz != Long.TYPE && clazz != Float.TYPE && clazz != Double.TYPE) throw new ExecutionError(string, unaryExpression);
                unaryExpression.setProperty("type", new JavaClassInfo(clazz));
            }
        }

        protected void visitBinaryExpression(BinaryExpression binaryExpression) {
            Object object = binaryExpression.getLeftExpression().acceptVisitor(this);
            if (object != null) {
                if (object instanceof ReferenceType) {
                    throw new ExecutionError("left.operand", binaryExpression);
                }
                binaryExpression.setLeftExpression((Expression)object);
            }
            if ((object = binaryExpression.getRightExpression().acceptVisitor(this)) != null) {
                if (object instanceof ReferenceType) {
                    throw new ExecutionError("right.operand", binaryExpression);
                }
                binaryExpression.setRightExpression((Expression)object);
            }
        }

        protected void visitNumericExpression(BinaryExpression binaryExpression, String string) {
            ClassInfo classInfo = NodeProperties.getClassInfo(binaryExpression.getLeftExpression());
            ClassInfo classInfo2 = NodeProperties.getClassInfo(binaryExpression.getRightExpression());
            Class clazz = classInfo.getJavaClass();
            Class clazz2 = classInfo2.getJavaClass();
            if (clazz == null || clazz2 == null || clazz == Boolean.TYPE || clazz2 == Boolean.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive() || clazz == Void.TYPE || clazz2 == Void.TYPE) {
                throw new ExecutionError(string, binaryExpression);
            }
            if (clazz == Double.TYPE || clazz2 == Double.TYPE) {
                binaryExpression.setProperty("type", JavaClassInfo.DOUBLE);
            } else if (clazz == Float.TYPE || clazz2 == Float.TYPE) {
                binaryExpression.setProperty("type", JavaClassInfo.FLOAT);
            } else if (clazz == Long.TYPE || clazz2 == Long.TYPE) {
                binaryExpression.setProperty("type", JavaClassInfo.LONG);
            } else {
                binaryExpression.setProperty("type", JavaClassInfo.INT);
            }
        }

        protected void visitBitwiseExpression(BinaryExpression binaryExpression, String string) {
            Expression expression = binaryExpression.getLeftExpression();
            Expression expression2 = binaryExpression.getRightExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            ClassInfo classInfo2 = NodeProperties.getClassInfo(expression2);
            Class clazz = null;
            Class clazz2 = null;
            if (!(classInfo instanceof JavaClassInfo) || !(classInfo2 instanceof JavaClassInfo)) {
                throw new ExecutionError(string, binaryExpression);
            }
            clazz = classInfo.getJavaClass();
            clazz2 = classInfo2.getJavaClass();
            if (clazz == null || clazz2 == null || clazz == Void.TYPE || clazz2 == Void.TYPE || clazz == Float.TYPE || clazz2 == Float.TYPE || clazz == Double.TYPE || clazz2 == Double.TYPE || clazz == Boolean.TYPE ^ clazz2 == Boolean.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
                throw new ExecutionError(string, binaryExpression);
            }
            if (clazz == Long.TYPE || clazz2 == Long.TYPE) {
                binaryExpression.setProperty("type", JavaClassInfo.LONG);
            } else if (clazz == Boolean.TYPE) {
                binaryExpression.setProperty("type", JavaClassInfo.BOOLEAN);
            } else {
                binaryExpression.setProperty("type", JavaClassInfo.INT);
            }
        }

        protected void visitShiftExpression(BinaryExpression binaryExpression, String string) {
            Expression expression = binaryExpression.getLeftExpression();
            Expression expression2 = binaryExpression.getRightExpression();
            ClassInfo classInfo = NodeProperties.getClassInfo(expression);
            ClassInfo classInfo2 = NodeProperties.getClassInfo(expression2);
            Class clazz = null;
            Class clazz2 = null;
            if (!(classInfo instanceof JavaClassInfo) || !(classInfo2 instanceof JavaClassInfo)) {
                throw new ExecutionError(string, binaryExpression);
            }
            clazz = classInfo.getJavaClass();
            clazz2 = classInfo2.getJavaClass();
            if (clazz == null || clazz2 == null || clazz == Boolean.TYPE || clazz2 == Boolean.TYPE || clazz == Void.TYPE || clazz2 == Void.TYPE || clazz == Float.TYPE || clazz2 == Float.TYPE || clazz == Double.TYPE || clazz2 == Double.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
                throw new ExecutionError(string, binaryExpression);
            }
            if (clazz == Long.TYPE) {
                binaryExpression.setProperty("type", JavaClassInfo.LONG);
            } else {
                binaryExpression.setProperty("type", JavaClassInfo.INT);
            }
        }

        protected void checkList(List list, String string, Node node) {
            ListIterator<Object> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Object object = ((Node)listIterator.next()).acceptVisitor(this);
                if (object == null) continue;
                if (object instanceof ReferenceType) {
                    throw new ExecutionError(string, node);
                }
                listIterator.set(object);
            }
        }

        protected boolean fieldExists(ClassInfo classInfo, String string) {
            boolean bl = false;
            try {
                ClassInfoUtilities.getField(classInfo, string);
                bl = true;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    ClassInfoUtilities.getOuterField(classInfo, string);
                    bl = true;
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                }
                catch (AmbiguousFieldException ambiguousFieldException) {
                    bl = true;
                }
            }
            catch (AmbiguousFieldException ambiguousFieldException) {
                bl = true;
            }
            return bl;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

