/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.interpreter.ClassLoaderContainer;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.tree.TypeDeclaration;

public class TreeClassLoader
extends ClassLoader
implements ClassLoaderContainer {
    protected Map classes = new HashMap(11);
    protected Map trees = new HashMap(11);
    protected Interpreter interpreter;
    protected ClassLoader classLoader;

    public TreeClassLoader(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Class defineClass(String string, byte[] byArray) {
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
        this.classes.put(string, clazz);
        this.trees.remove(string);
        return clazz;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean hasDefined(String string) {
        return this.classes.containsKey(string);
    }

    public Set getClassNames() {
        return this.classes.keySet();
    }

    public void addTree(String string, TypeDeclaration typeDeclaration) {
        this.trees.put(string, typeDeclaration);
    }

    public TypeDeclaration getTree(String string) {
        return (TypeDeclaration)this.trees.get(string);
    }

    public void addURL(URL uRL) {
        this.classLoader = this.classLoader == null ? new URLClassLoader(new URL[]{uRL}) : new URLClassLoader(new URL[]{uRL}, this.classLoader);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (this.classes.containsKey(string)) {
            return (Class)this.classes.get(string);
        }
        try {
            if (this.classLoader != null) {
                return Class.forName(string, true, this.classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.interpreter.loadClass(string);
    }
}

