/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.interpreter.EvaluationVisitor;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.InterpreterException;
import koala.dynamicjava.interpreter.InterpreterUtilities;
import koala.dynamicjava.interpreter.NameVisitor;
import koala.dynamicjava.interpreter.TreeClassLoader;
import koala.dynamicjava.interpreter.TreeCompiler;
import koala.dynamicjava.interpreter.TypeChecker;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.GlobalContext;
import koala.dynamicjava.interpreter.context.MethodContext;
import koala.dynamicjava.interpreter.context.StaticContext;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.throwable.ReturnException;
import koala.dynamicjava.parser.wrapper.ParseError;
import koala.dynamicjava.parser.wrapper.ParserFactory;
import koala.dynamicjava.parser.wrapper.SourceCodeParser;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.visitor.Visitor;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.ImportationManager;
import koala.dynamicjava.util.LibraryFinder;

public class TreeInterpreter
implements Interpreter {
    protected ParserFactory parserFactory;
    protected LibraryFinder libraryFinder = new LibraryFinder();
    protected TreeClassLoader classLoader;
    protected static Map methods = new HashMap();
    List localMethods = new LinkedList();
    protected static Map constructorParameters = new HashMap();
    List localConstructorParameters = new LinkedList();
    protected static int nClass;
    protected Context nameVisitorContext;
    protected Context checkVisitorContext;
    protected Context evalVisitorContext;
    protected boolean accessible;
    static /* synthetic */ Class class$koala$dynamicjava$interpreter$error$CatchedExceptionError;

    public TreeInterpreter(ParserFactory parserFactory) {
        this.parserFactory = parserFactory;
        this.classLoader = new TreeClassLoader(this);
        this.nameVisitorContext = new GlobalContext(this);
        this.nameVisitorContext.setAdditionalClassLoaderContainer(this.classLoader);
        this.checkVisitorContext = new GlobalContext(this);
        this.checkVisitorContext.setAdditionalClassLoaderContainer(this.classLoader);
        this.evalVisitorContext = new GlobalContext(this);
        this.evalVisitorContext.setAdditionalClassLoaderContainer(this.classLoader);
    }

    public Object interpret(Reader reader, String string) throws InterpreterException {
        try {
            SourceCodeParser sourceCodeParser = this.parserFactory.createParser(reader, string);
            List list = sourceCodeParser.parseStream();
            ListIterator listIterator = list.listIterator();
            Object object = null;
            while (listIterator.hasNext()) {
                VisitorObject visitorObject;
                Node node = (Node)listIterator.next();
                Object object2 = node.acceptVisitor(visitorObject = new NameVisitor(this.nameVisitorContext));
                if (object2 != null) {
                    node = (Node)object2;
                }
                visitorObject = new TypeChecker(this.checkVisitorContext);
                node.acceptVisitor(visitorObject);
                this.evalVisitorContext.defineVariables(this.checkVisitorContext.getCurrentScopeVariables());
                visitorObject = new EvaluationVisitor(this.evalVisitorContext);
                object = node.acceptVisitor(visitorObject);
            }
            return object;
        }
        catch (ExecutionError executionError) {
            throw new InterpreterException(executionError);
        }
        catch (ParseError parseError) {
            throw new InterpreterException(parseError);
        }
    }

    public Object interpret(InputStream inputStream, String string) throws InterpreterException {
        return this.interpret(new InputStreamReader(inputStream), string);
    }

    public Object interpret(String string) throws InterpreterException, IOException {
        return this.interpret(new FileReader(string), string);
    }

    public List buildStatementList(Reader reader, String string) throws InterpreterException {
        try {
            SourceCodeParser sourceCodeParser = this.parserFactory.createParser(reader, string);
            List list = sourceCodeParser.parseStream();
            ListIterator listIterator = list.listIterator();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            while (listIterator.hasNext()) {
                VisitorObject visitorObject;
                Node node = (Node)listIterator.next();
                Object object = node.acceptVisitor(visitorObject = new NameVisitor(this.nameVisitorContext));
                if (object != null) {
                    node = (Node)object;
                }
                arrayList.add(node);
                visitorObject = new TypeChecker(this.checkVisitorContext);
                node.acceptVisitor(visitorObject);
                this.evalVisitorContext.defineVariables(this.checkVisitorContext.getCurrentScopeVariables());
            }
            return arrayList;
        }
        catch (ParseError parseError) {
            throw new InterpreterException(parseError);
        }
    }

    public Object interpret(List list) throws InterpreterException {
        try {
            ListIterator listIterator = list.listIterator();
            Object object = null;
            while (listIterator.hasNext()) {
                Node node = (Node)listIterator.next();
                EvaluationVisitor evaluationVisitor = new EvaluationVisitor(this.evalVisitorContext);
                object = node.acceptVisitor(evaluationVisitor);
            }
            return object;
        }
        catch (ExecutionError executionError) {
            throw new InterpreterException(executionError);
        }
        catch (ParseError parseError) {
            throw new InterpreterException(parseError);
        }
    }

    public void defineVariable(String string, Object object, Class clazz) {
        this.nameVisitorContext.define(string, clazz);
        this.checkVisitorContext.define(string, clazz);
        this.evalVisitorContext.define(string, object);
    }

    public void defineVariable(String string, Object object) {
        this.defineVariable(string, object, object == null ? null : object.getClass());
    }

    public void defineVariable(String string, boolean bl) {
        Class<Boolean> clazz = Boolean.TYPE;
        this.nameVisitorContext.define(string, clazz);
        this.checkVisitorContext.define(string, clazz);
        this.evalVisitorContext.define(string, new Boolean(bl));
    }

    public void defineVariable(String string, byte by) {
        Class<Byte> clazz = Byte.TYPE;
        this.nameVisitorContext.define(string, clazz);
        this.checkVisitorContext.define(string, clazz);
        this.evalVisitorContext.define(string, new Byte(by));
    }

    public void defineVariable(String string, short s) {
        Class<Short> clazz = Short.TYPE;
        this.nameVisitorContext.define(string, clazz);
        this.checkVisitorContext.define(string, clazz);
        this.evalVisitorContext.define(string, new Short(s));
    }

    public void defineVariable(String string, char c) {
        Class<Character> clazz = Character.TYPE;
        this.nameVisitorContext.define(string, clazz);
        this.checkVisitorContext.define(string, clazz);
        this.evalVisitorContext.define(string, new Character(c));
    }

    public void defineVariable(String string, int n) {
        Class<Integer> clazz = Integer.TYPE;
        this.nameVisitorContext.define(string, clazz);
        this.checkVisitorContext.define(string, clazz);
        this.evalVisitorContext.define(string, new Integer(n));
    }

    public void defineVariable(String string, long l) {
        Class<Long> clazz = Long.TYPE;
        this.nameVisitorContext.define(string, clazz);
        this.checkVisitorContext.define(string, clazz);
        this.evalVisitorContext.define(string, new Long(l));
    }

    public void defineVariable(String string, float f) {
        Class<Float> clazz = Float.TYPE;
        this.nameVisitorContext.define(string, clazz);
        this.checkVisitorContext.define(string, clazz);
        this.evalVisitorContext.define(string, new Float(f));
    }

    public void defineVariable(String string, double d) {
        Class<Double> clazz = Double.TYPE;
        this.nameVisitorContext.define(string, clazz);
        this.checkVisitorContext.define(string, clazz);
        this.evalVisitorContext.define(string, new Double(d));
    }

    public void setVariable(String string, Object object) {
        Class clazz = (Class)this.checkVisitorContext.get(string);
        if (!InterpreterUtilities.isValidAssignment(clazz, object)) {
            throw new IllegalStateException(string);
        }
        this.evalVisitorContext.set(string, object);
    }

    public Object getVariable(String string) {
        return this.evalVisitorContext.get(string);
    }

    public Class getVariableClass(String string) {
        return (Class)this.checkVisitorContext.get(string);
    }

    public Set getVariableNames() {
        return this.evalVisitorContext.getCurrentScopeVariableNames();
    }

    public void setAccessible(boolean bl) {
        this.accessible = bl;
        this.nameVisitorContext.setAccessible(bl);
        this.checkVisitorContext.setAccessible(bl);
        this.evalVisitorContext.setAccessible(bl);
    }

    public boolean getAccessible() {
        return this.accessible;
    }

    public Set getClassNames() {
        return this.classLoader.getClassNames();
    }

    public void addClassPath(String string) {
        try {
            this.classLoader.addURL(new File(string).toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void addClassURL(URL uRL) {
        this.classLoader.addURL(uRL);
    }

    public void addLibraryPath(String string) {
        this.libraryFinder.addPath(string);
    }

    public void addLibrarySuffix(String string) {
        this.libraryFinder.addSuffix(string);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return new TreeCompiler(this).compile(string);
    }

    public Class defineClass(String string, byte[] byArray) {
        return this.classLoader.defineClass(string, byArray);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public LibraryFinder getLibraryFinder() {
        return this.libraryFinder;
    }

    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public Class getExceptionClass() {
        return class$koala$dynamicjava$interpreter$error$CatchedExceptionError == null ? (class$koala$dynamicjava$interpreter$error$CatchedExceptionError = TreeInterpreter.class$("koala.dynamicjava.interpreter.error.CatchedExceptionError")) : class$koala$dynamicjava$interpreter$error$CatchedExceptionError;
    }

    public void registerMethod(String string, MethodDeclaration methodDeclaration, ImportationManager importationManager) {
        this.localMethods.add(string);
        methods.put(string, new MethodDescriptor(methodDeclaration, importationManager));
    }

    public static Object invokeMethod(String string, Object object, Object[] objectArray) {
        MethodDescriptor methodDescriptor = (MethodDescriptor)methods.get(string);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string.substring(0, string.lastIndexOf(35)), true, methodDescriptor.interpreter.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return methodDescriptor.interpreter.interpretMethod(clazz, methodDescriptor, object, objectArray);
    }

    protected Object interpretMethod(Class clazz, MethodDescriptor methodDescriptor, Object object, Object[] objectArray) {
        Object object2;
        Object object3;
        VisitorObject visitorObject;
        Object object4;
        MethodDeclaration methodDeclaration = methodDescriptor.method;
        List list = methodDeclaration.getParameters();
        List list2 = methodDeclaration.getBody().getStatements();
        String string = methodDeclaration.getName();
        StaticContext staticContext = null;
        if (Modifier.isStatic(methodDescriptor.method.getAccessFlags())) {
            if (methodDescriptor.variables == null) {
                methodDescriptor.importationManager.setClassLoader(this.classLoader);
                object4 = new StaticContext((Interpreter)this, clazz, methodDescriptor.importationManager);
                object4.setAdditionalClassLoaderContainer(this.classLoader);
                visitorObject = new NameVisitor((Context)object4);
                object3 = list.listIterator();
                while (object3.hasNext()) {
                    ((Node)object3.next()).acceptVisitor(visitorObject);
                }
                object3 = list2.listIterator();
                while (object3.hasNext()) {
                    object2 = ((Node)object3.next()).acceptVisitor(visitorObject);
                    if (object2 == null) continue;
                    object3.set(object2);
                }
                object4 = new StaticContext((Interpreter)this, clazz, methodDescriptor.importationManager);
                object4.setAdditionalClassLoaderContainer(this.classLoader);
                visitorObject = new TypeChecker((Context)object4);
                object3 = list.listIterator();
                while (object3.hasNext()) {
                    ((Node)object3.next()).acceptVisitor(visitorObject);
                }
                object3 = list2.listIterator();
                while (object3.hasNext()) {
                    ((Node)object3.next()).acceptVisitor(visitorObject);
                }
                methodDescriptor.variables = object4.getCurrentScopeVariables();
                if (!string.equals("<clinit>") && !string.equals("<init>")) {
                    try {
                        methodDescriptor.contextField = clazz.getField("local$Variables$Reference$0");
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
            staticContext = new StaticContext((Interpreter)this, clazz, methodDescriptor.variables);
        } else {
            if (methodDescriptor.variables == null) {
                Object object5;
                ListIterator<Object[]> listIterator;
                methodDescriptor.importationManager.setClassLoader(this.classLoader);
                object4 = new MethodContext((Interpreter)this, clazz, (Object)clazz, methodDescriptor.importationManager);
                object4.setAdditionalClassLoaderContainer(this.classLoader);
                visitorObject = new NameVisitor((Context)object4);
                object3 = new MethodContext((Interpreter)this, clazz, (Object)clazz, methodDescriptor.importationManager);
                object3.setAdditionalClassLoaderContainer(this.classLoader);
                object2 = new NameVisitor((Context)object3);
                Object[][] objectArray2 = null;
                try {
                    listIterator = clazz.getField("local$Variables$Class$0");
                    objectArray2 = (Object[][])((Field)((Object)listIterator)).get(object);
                    int n = 0;
                    while (n < objectArray2.length) {
                        object5 = objectArray2[n];
                        if (!((String)object5[0]).equals("this")) {
                            object4.defineConstant((String)object5[0], object5[1]);
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ((Node)listIterator.next()).acceptVisitor(visitorObject);
                }
                listIterator = list2.listIterator();
                while (listIterator.hasNext()) {
                    Node node = (Node)listIterator.next();
                    object5 = null;
                    object5 = node.hasProperty("instanceInitializer") ? node.acceptVisitor((Visitor)object2) : node.acceptVisitor(visitorObject);
                    if (object5 == null) continue;
                    listIterator.set((Object[])object5);
                }
                object4 = new MethodContext((Interpreter)this, clazz, (Object)clazz, methodDescriptor.importationManager);
                object4.setAdditionalClassLoaderContainer(this.classLoader);
                visitorObject = new TypeChecker((Context)object4);
                object3 = new MethodContext((Interpreter)this, clazz, (Object)clazz, methodDescriptor.importationManager);
                object3.setAdditionalClassLoaderContainer(this.classLoader);
                object2 = new TypeChecker((Context)object3);
                if (objectArray2 != null) {
                    int n = 0;
                    while (n < objectArray2.length) {
                        object5 = objectArray2[n];
                        if (!((String)object5[0]).equals("this")) {
                            object4.defineConstant((String)object5[0], object5[1]);
                        }
                        ++n;
                    }
                }
                listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ((Node)listIterator.next()).acceptVisitor(visitorObject);
                }
                listIterator = list2.listIterator();
                while (listIterator.hasNext()) {
                    Node node = (Node)listIterator.next();
                    if (node.hasProperty("instanceInitializer")) {
                        node.acceptVisitor((Visitor)object2);
                        continue;
                    }
                    node.acceptVisitor(visitorObject);
                }
                methodDescriptor.variables = object4.getCurrentScopeVariables();
                if (!string.equals("<clinit>") && !string.equals("<init>")) {
                    try {
                        methodDescriptor.contextField = clazz.getField("local$Variables$Reference$0");
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
            staticContext = new MethodContext((Interpreter)this, clazz, object, methodDescriptor.variables);
        }
        staticContext.setAdditionalClassLoaderContainer(this.classLoader);
        object4 = list.iterator();
        int n = 0;
        while (object4.hasNext()) {
            staticContext.set(((FormalParameter)object4.next()).getName(), objectArray[n++]);
        }
        if (methodDescriptor.contextField != null) {
            object3 = null;
            try {
                object3 = (Map)methodDescriptor.contextField.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (object3 != null) {
                object4 = object3.keySet().iterator();
                while (object4.hasNext()) {
                    object2 = (String)object4.next();
                    if (((String)object2).equals("this")) continue;
                    staticContext.setConstant((String)object2, object3.get(object2));
                }
            }
        }
        object3 = new EvaluationVisitor(staticContext);
        object4 = list2.iterator();
        try {
            while (object4.hasNext()) {
                ((Node)object4.next()).acceptVisitor((Visitor)object3);
            }
        }
        catch (ReturnException returnException) {
            return returnException.getValue();
        }
        return null;
    }

    public void registerConstructorArguments(String string, List list, List list2, ImportationManager importationManager) {
        this.localConstructorParameters.add(string);
        constructorParameters.put(string, new ConstructorParametersDescriptor(list, list2, importationManager));
    }

    public static Object[] interpretArguments(String string, Object[] objectArray) {
        ConstructorParametersDescriptor constructorParametersDescriptor = (ConstructorParametersDescriptor)constructorParameters.get(string);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string.substring(0, string.lastIndexOf(35)), true, constructorParametersDescriptor.interpreter.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return constructorParametersDescriptor.interpreter.interpretArguments(clazz, constructorParametersDescriptor, objectArray);
    }

    protected Object[] interpretArguments(Class clazz, ConstructorParametersDescriptor constructorParametersDescriptor, Object[] objectArray) {
        ListIterator<Object> listIterator;
        VisitorObject visitorObject;
        Object[] objectArray2;
        StaticContext staticContext;
        if (constructorParametersDescriptor.variables == null) {
            constructorParametersDescriptor.importationManager.setClassLoader(this.classLoader);
            staticContext = new StaticContext((Interpreter)this, clazz, constructorParametersDescriptor.importationManager);
            staticContext.setAdditionalClassLoaderContainer(this.classLoader);
            objectArray2 = new NameVisitor(staticContext);
            visitorObject = new TypeChecker(staticContext);
            if (constructorParametersDescriptor.parameters != null) {
                listIterator = constructorParametersDescriptor.parameters.listIterator();
                while (listIterator.hasNext()) {
                    ((Node)listIterator.next()).acceptVisitor(visitorObject);
                }
            }
            if (constructorParametersDescriptor.arguments != null) {
                listIterator = constructorParametersDescriptor.arguments.listIterator();
                while (listIterator.hasNext()) {
                    Node node = (Node)listIterator.next();
                    Object object = node.acceptVisitor((Visitor)objectArray2);
                    if (object == null) continue;
                    listIterator.set(object);
                }
                listIterator = constructorParametersDescriptor.arguments.listIterator();
                while (listIterator.hasNext()) {
                    ((Node)listIterator.next()).acceptVisitor(visitorObject);
                }
            }
            constructorParametersDescriptor.variables = staticContext.getCurrentScopeVariables();
        }
        staticContext = new StaticContext((Interpreter)this, clazz, constructorParametersDescriptor.variables);
        staticContext.setAdditionalClassLoaderContainer(this.classLoader);
        if (constructorParametersDescriptor.parameters != null) {
            objectArray2 = constructorParametersDescriptor.parameters.iterator();
            int n = 0;
            while (objectArray2.hasNext()) {
                staticContext.set(((FormalParameter)objectArray2.next()).getName(), objectArray[n++]);
            }
        }
        objectArray2 = new Object[]{};
        if (constructorParametersDescriptor.arguments != null) {
            visitorObject = new EvaluationVisitor(staticContext);
            listIterator = constructorParametersDescriptor.arguments.listIterator();
            objectArray2 = new Object[constructorParametersDescriptor.arguments.size()];
            int n = 0;
            while (listIterator.hasNext()) {
                objectArray2[n++] = ((Node)listIterator.next()).acceptVisitor(visitorObject);
            }
        }
        return objectArray2;
    }

    protected void finalize() throws Throwable {
        Iterator iterator = this.localMethods.iterator();
        while (iterator.hasNext()) {
            methods.remove(iterator.next());
        }
        iterator = this.localConstructorParameters.iterator();
        while (iterator.hasNext()) {
            constructorParameters.remove(iterator.next());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class ConstructorParametersDescriptor {
        Set variables;
        List parameters;
        List arguments;
        ImportationManager importationManager;
        TreeInterpreter interpreter;

        ConstructorParametersDescriptor(List list, List list2, ImportationManager importationManager) {
            this.parameters = list;
            this.arguments = list2;
            this.importationManager = importationManager;
            this.interpreter = TreeInterpreter.this;
        }
    }

    protected class MethodDescriptor {
        Set variables;
        MethodDeclaration method;
        ImportationManager importationManager;
        TreeInterpreter interpreter;
        Field contextField;

        MethodDescriptor(MethodDeclaration methodDeclaration, ImportationManager importationManager) {
            this.method = methodDeclaration;
            this.importationManager = importationManager;
            this.interpreter = TreeInterpreter.this;
        }
    }
}

