/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.error;

import java.io.PrintStream;
import java.io.PrintWriter;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.util.LocalizedMessageReader;

public class ExecutionError
extends Error {
    protected Throwable thrown;
    private static final String BUNDLE = "koala.dynamicjava.interpreter.resources.messages";
    public static final String SHOW_CAUSE_PROPERTY = "koala.dynamicjava.interpreter.showCause";
    public static final String SHOW_TRACE_PROPERTY = "koala.dynamicjava.interpreter.showTrace";
    private static final LocalizedMessageReader reader = new LocalizedMessageReader("koala.dynamicjava.interpreter.resources.messages");
    private Node node;
    private String rawMessage;

    public ExecutionError() {
        this("");
    }

    public ExecutionError(String string) {
        this(string, (Node)null);
    }

    public ExecutionError(String string, Node node) {
        this.rawMessage = string;
        this.node = node;
    }

    public ExecutionError(Throwable throwable) {
        this.thrown = throwable;
    }

    public Node getNode() {
        return this.node;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream, true));
    }

    public void printStackTrace(PrintWriter printWriter) {
        String string = System.getProperty(SHOW_TRACE_PROPERTY);
        if (string != null && !new Boolean(string).booleanValue()) {
            printWriter.println(this);
        } else {
            super.printStackTrace(printWriter);
            String string2 = System.getProperty(SHOW_CAUSE_PROPERTY);
            if ((string2 == null || new Boolean(string2).booleanValue()) && this.thrown != null) {
                printWriter.println("Caused by: ");
                this.thrown.printStackTrace(printWriter);
            }
        }
    }

    public String getMessage() {
        return reader.getMessage(this.rawMessage, this.node != null && this.node.hasProperty("errorStrings") ? (String[])this.node.getProperty("errorStrings") : null);
    }
}

