/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.collections;

import java.util.Enumeration;
import java.util.Vector;
import netcomputing.collections.INCCollection;
import netcomputing.collections.INCEnumerateable;
import netcomputing.collections.INCIndexed;
import netcomputing.collections.NCArray;
import netcomputing.collections.NCArrayEnumerator;
import netcomputing.collections.NCCollectionUtil;
import netcomputing.collections.NCComparator;
import netcomputing.collections.NCIndexedCollection;
import netcomputing.collections.adaptors.NCArrayAdaptor;
import netcomputing.collections.adaptors.NCVectorAdaptor;

public class Algorithms {
    public static void AddSeparatedStringTo(INCCollection coll, String separator, String toParse) {
        if (toParse == null) {
            return;
        }
        String s = toParse;
        if (!s.endsWith(separator)) {
            s = s + separator;
        }
        while (s.indexOf(separator) >= 0) {
            String p = s.substring(0, s.indexOf(separator));
            s = s.substring(p.length() + 1);
            if ((p = p.trim()).length() <= 0) continue;
            coll.add(p);
        }
    }

    public static boolean Contains(INCIndexed arr, Object what) {
        return Algorithms.IndexOf(arr, what) >= 0;
    }

    public static Enumeration AsEnumeration(Object[] arr) {
        return new NCArrayEnumerator(arr);
    }

    public static int Count(Enumeration en) {
        int res = 0;
        while (en.hasMoreElements()) {
            ++res;
            en.nextElement();
        }
        return res;
    }

    public static void AddAll(INCCollection coll, Object[] arr) {
        coll.addAll(new NCArrayEnumerator(arr));
    }

    public static void ToArray(INCEnumerateable source, Object[] result) {
        Enumeration en = source.enumerate();
        int n = 0;
        while (en.hasMoreElements()) {
            result[n++] = en.nextElement();
        }
    }

    public static Object[] AsArray(Enumeration en) {
        NCArray tmp = new NCArray(50);
        tmp.addAll(en);
        return Algorithms.AsArray(tmp);
    }

    public static Object[] AsArray(INCEnumerateable en) {
        return Algorithms.AsArray(en.enumerate());
    }

    public static Object[] AsArray(INCIndexed arr) {
        int size = arr.size();
        Object[] result = new Object[size];
        int n = 0;
        while (n < size) {
            result[n] = arr.at(n);
            ++n;
        }
        return result;
    }

    public static Object[] AsArray(Vector arr) {
        return Algorithms.AsArray(new NCVectorAdaptor(arr));
    }

    public static void QuickSortByString(Object[] a) {
        Algorithms.QuickSortByString(new NCArrayAdaptor(a));
    }

    public static void QuickSort(Object[] a, NCComparator comp) {
        Algorithms.QuickSort(new NCArrayAdaptor(a), comp);
    }

    public static void QuickSortByString(INCIndexed a) {
        Algorithms.QuickSort(a, (NCComparator)NCCollectionUtil.ToStringComparator);
    }

    public static void QuickSort(INCIndexed a, NCComparator ge) {
        NCIndexedCollection.QuickSort(a, 0, a.size() - 1, ge);
    }

    public static int IndexOf(INCIndexed arr, Object what) {
        int maxN = arr.size();
        int n = 0;
        while (n < maxN) {
            Object act = arr.at(n);
            if (act != null && act.equals(what) || act == null && what == null) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int IndexOfByIdentity(INCIndexed arr, Object what) {
        return Algorithms.IndexOfByIdentity(arr, what, 0);
    }

    public static int IndexOfByIdentity(INCIndexed arr, Object what, int startIdx) {
        int maxN = arr.size();
        int n = startIdx;
        while (n < maxN) {
            Object act = arr.at(n);
            if (act == what) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean ContainsByIdentity(INCIndexed arr, Object what) {
        return Algorithms.IndexOfByIdentity(arr, what) >= 0;
    }
}

