/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.collections;

import de.netcomputing.util.Tracer;
import java.io.Serializable;
import java.util.Enumeration;
import netcomputing.collections.INCCollection;
import netcomputing.collections.INCEnumerateable;
import netcomputing.collections.INCIterationFunc;
import netcomputing.collections.NCArray;
import netcomputing.collections.NCCollectionCounter;
import netcomputing.collections.NCCollectionUtil;
import netcomputing.collections.NCComparator;
import netcomputing.collections.NCEnumerationFilter;
import netcomputing.collections.NCEqualsComparator;
import netcomputing.collections.NCSet;
import netcomputing.collections.NCSortedCollection;
import netcomputing.collections.NCSortedSet;

public abstract class NCBasicCollection
implements INCEnumerateable,
Serializable,
Cloneable {
    protected NCComparator comparator = new NCEqualsComparator();

    protected NCBasicCollection() {
    }

    public void setComparator(NCComparator comparator) {
        this.comparator = comparator;
    }

    public NCComparator getComparator() {
        return this.comparator;
    }

    public Object find(Object what) {
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!this.comparator.isEqual(o, what)) continue;
            return o;
        }
        return null;
    }

    public Object findString(String what) {
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!o.toString().equals(what)) continue;
            return o;
        }
        return null;
    }

    public boolean contains(Object what) {
        return this.find(what) != null;
    }

    public Enumeration select(final INCIterationFunc what) {
        return new NCEnumerationFilter(this.enumerate()){

            public boolean filter(Object o) {
                Tracer.This.println("NCBasicCollection::filter" + o);
                return what.func(o);
            }
        };
    }

    public void select(INCIterationFunc what, INCCollection result) {
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!what.func(o)) continue;
            result.add(o);
        }
    }

    public int count(INCIterationFunc what) {
        NCCollectionCounter cnt = new NCCollectionCounter();
        this.select(what, cnt);
        return cnt.count;
    }

    public boolean equals(Object o) {
        Enumeration en;
        try {
            en = (Enumeration)o;
        }
        catch (ClassCastException e) {
            try {
                en = ((INCEnumerateable)o).enumerate();
            }
            catch (ClassCastException ee) {
                return false;
            }
        }
        Enumeration me2 = this.enumerate();
        boolean isEqual = true;
        while (en.hasMoreElements() && me2.hasMoreElements()) {
            if (this.comparator.isEqual(en.nextElement(), me2.nextElement())) continue;
            isEqual = false;
            break;
        }
        return isEqual && !en.hasMoreElements() && !me2.hasMoreElements();
    }

    public abstract Enumeration enumerate();

    public void addAllTo(INCCollection result) {
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
    }

    public int countElements() {
        return this.count(NCCollectionUtil.AlwaysTrue);
    }

    public NCArray toNCArray() {
        NCArray result = new NCArray(this.countElements());
        this.addAllTo(result);
        return result;
    }

    public NCSortedCollection toNCSortedCollection(NCComparator comp) {
        NCArray jwa = this.toNCArray();
        jwa.sortBy(comp);
        return new NCSortedCollection(jwa, comp);
    }

    public NCSortedSet toNCSortedSet(NCComparator comp) {
        NCArray jwa = this.toNCArray();
        NCSortedSet res = new NCSortedSet(new NCArray(jwa.size()), comp);
        int n = jwa.array.length - 1;
        while (n >= 0) {
            res.add(jwa.array[n]);
            --n;
        }
        return res;
    }

    public NCSortedCollection toNCSortedCollection() {
        return this.toNCSortedCollection(NCCollectionUtil.ToStringComparator);
    }

    public NCSortedSet toNCSortedSet() {
        return this.toNCSortedSet(NCCollectionUtil.ToStringComparator);
    }

    public NCSet toNCSet() {
        NCSet result = new NCSet(this.countElements() * 3 / 2);
        this.addAllTo(result);
        return result;
    }

    public NCSet toNCSet(NCComparator comp) {
        NCSet result = new NCSet(this.countElements() * 3 / 2, comp);
        this.addAllTo(result);
        return result;
    }

    public Object[] toArray() {
        int len = this.countElements();
        Object[] result = new Object[len];
        Enumeration e = this.enumerate();
        int n = 0;
        while (e.hasMoreElements()) {
            result[n++] = e.nextElement();
        }
        return result;
    }

    public void common(NCBasicCollection other, INCCollection result) {
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!other.contains(obj)) continue;
            result.add(obj);
        }
    }

    public boolean isSorted() {
        return false;
    }

    public void forAll(INCIterationFunc jf) {
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!jf.func(obj)) continue;
            return;
        }
    }

    public abstract INCEnumerateable copyShallow();

    public abstract INCEnumerateable copyDeep();
}

