/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.collections;

import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.util.Tracer;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import netcomputing.collections.INCGenericTarget;
import netcomputing.collections.INCTarget;
import netcomputing.collections.NCHashtable;
import netcomputing.collections.TargetAndSelector;

public class NCBinder
implements Serializable {
    protected NCHashtable ht = null;
    protected Object owner;
    static Class[] ActionTypes;
    static NCHashtable methodCache;
    static Object[] args;

    public NCBinder(Object _owner) {
        this.owner = _owner;
    }

    public void addTarget(Object client, String selector) {
        if (this.ht == null) {
            this.ht = new NCHashtable(2);
        }
        this.ht.put(new TargetAndSelector(client, selector), Boolean.TRUE);
    }

    public void removeTarget(Object client, String selector) {
        if (this.ht == null) {
            this.ht = new NCHashtable(2);
        }
        this.ht.rem(new TargetAndSelector(client, selector));
    }

    public void removeTarget(Object client) {
        if (this.ht == null) {
            this.ht = new NCHashtable(2);
        }
        Enumeration en = this.ht.enumerateKeys();
        while (en.hasMoreElements()) {
            TargetAndSelector cas = (TargetAndSelector)en.nextElement();
            if (cas.client.equals(client)) {
                // empty if block
            }
            this.ht.rem(cas);
        }
    }

    public void setOwner(Object newOwner) {
        this.owner = newOwner;
    }

    public void removeAll() {
        this.ht = null;
    }

    public Object notifyTargets(int value) {
        return this.notifyTargets(new Integer(value), this.owner);
    }

    public Object notifyTargets(double value) {
        return this.notifyTargets(new Double(value), this.owner);
    }

    public Object notifyTargets(Object value) {
        return this.notifyTargets(value, this.owner);
    }

    public static boolean RespondsToAction(Object obj, String name) {
        try {
            obj.getClass().getMethod(name, ActionTypes);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object PerformAction(Object obj, String name, Object arg, Object sender) {
        if (obj instanceof INCGenericTarget && ((INCGenericTarget)obj).accepts(name, arg, sender)) {
            return ((INCGenericTarget)obj).action(name, arg, sender);
        }
        String s = obj.getClass().getName() + ":" + name;
        Method m = null;
        if (m == null) {
            try {
                m = obj.getClass().getMethod(name, ActionTypes);
                methodCache.put(s, m);
            }
            catch (Exception e) {
                JWidgetsUtil.StackTrace();
                return null;
            }
        }
        try {
            Object[] e = args;
            synchronized (e) {
                NCBinder.args[0] = arg;
                NCBinder.args[1] = sender;
            }
            return m.invoke(obj, args);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                ((InvocationTargetException)e).getTargetException().printStackTrace();
            } else {
                Tracer.This.println(e);
            }
            JWidgetsUtil.StackTrace();
            return null;
        }
    }

    public Object notifyTargets(Object value, Object trigger) {
        if (this.ht == null) {
            return null;
        }
        Enumeration en = this.ht.enumerateKeys();
        while (en.hasMoreElements()) {
            TargetAndSelector cas = (TargetAndSelector)en.nextElement();
            if (NCBinder.RespondsToAction(cas.client, cas.selector)) {
                NCBinder.PerformAction(cas.client, cas.selector, value, trigger);
                continue;
            }
            INCTarget target = (INCTarget)cas.client;
            target.action(cas.selector, value, trigger);
        }
        return null;
    }

    public int size() {
        return this.ht.size();
    }

    public String toString() {
        Enumeration en = this.ht.enumerateKeys();
        String res = "Binder [";
        while (en.hasMoreElements()) {
            res = res + en.nextElement();
        }
        return res + "] ";
    }

    static {
        try {
            Class[] o = new Class[]{Class.forName("java.lang.Object"), Class.forName("java.lang.Object")};
            ActionTypes = o;
        }
        catch (Exception e) {
            Tracer.This.println(e);
        }
        methodCache = new NCHashtable(100);
        args = new Object[]{null, null};
    }
}

