/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.data;

import de.netcomputing.util.Tracer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import netcomputing.collections.NCEnumerationFilter;
import netcomputing.collections.NCEnumerationSupport;
import netcomputing.data.IRecord;

public class TableSupport
extends NCEnumerationSupport {
    public static final int ST_ANY = 0;
    public static final int ST_ALL = 1;
    public static final int CMP_EQUAL = 0;
    public static final int CMP_STARTS = 1;
    public static final int CMP_ENDS = 2;

    public static Enumeration SelectAll(Enumeration recordsFrom, String[] fields, String[] values) {
        return TableSupport.Select(recordsFrom, fields, values, 1, 0);
    }

    public static Enumeration SelectAny(Enumeration recordsFrom, String[] fields, String[] values) {
        return TableSupport.Select(recordsFrom, fields, values, 0, 0);
    }

    public static Enumeration SelectAllStartingWith(Enumeration recordsFrom, String[] fields, String[] values) {
        return TableSupport.Select(recordsFrom, fields, values, 1, 1);
    }

    public static Enumeration SelectAnyStartingWith(Enumeration recordsFrom, String[] fields, String[] values) {
        return TableSupport.Select(recordsFrom, fields, values, 0, 1);
    }

    public static Enumeration SelectAllEndsWith(Enumeration recordsFrom, String[] fields, String[] values) {
        return TableSupport.Select(recordsFrom, fields, values, 1, 2);
    }

    public static Enumeration SelectAnyEndsWith(Enumeration recordsFrom, String[] fields, String[] values) {
        return TableSupport.Select(recordsFrom, fields, values, 0, 2);
    }

    public static Enumeration Select(Enumeration recordsFrom, final String[] fields, final String[] values, final int selType, final int compareType) {
        return new NCEnumerationFilter(recordsFrom){

            public boolean filter(Object o) {
                IRecord rec = (IRecord)o;
                int n = 0;
                while (n < fields.length) {
                    String val = rec.getStringValue(fields[n]);
                    boolean matches = false;
                    switch (compareType) {
                        case 0: {
                            if (!values[n].equals(val)) break;
                            matches = true;
                            break;
                        }
                        case 1: {
                            if (!values[n].startsWith(val)) break;
                            matches = true;
                            break;
                        }
                        case 2: {
                            if (!values[n].endsWith(val)) break;
                            matches = true;
                        }
                    }
                    Tracer.This.println("result:" + matches);
                    if (matches && selType == 0) {
                        return true;
                    }
                    if (!matches && selType == 1) {
                        return false;
                    }
                    ++n;
                }
                return selType == 1;
            }
        };
    }

    public static boolean LoadRecord(IRecord rec, DataInput in, StringBuffer buff) throws IOException {
        int[] c = new int[]{0, 0, 0};
        int cnt = 0;
        boolean end = false;
        buff.setLength(0);
        int fieldIndex = 0;
        try {
            while (!end) {
                c[cnt] = in.readByte();
                if (c[cnt] < 0) {
                    Tracer.This.println(c[cnt]);
                }
                if (c[cnt] == 124) {
                    if (fieldIndex < rec.getColumnCount()) {
                        rec.setStringValue(fieldIndex, buff.toString());
                    }
                    ++fieldIndex;
                    buff.setLength(0);
                } else if (c[cnt] < 32) {
                    if (c[cnt] == 10 && c[(cnt + 2) % 3] == 13) {
                        if (buff.length() > 0 && fieldIndex < rec.getColumnCount()) {
                            rec.setStringValue(fieldIndex, buff.toString());
                        }
                        return true;
                    }
                    if (c[cnt] < 0) {
                        if (buff.length() > 0 && fieldIndex < rec.getColumnCount()) {
                            rec.setStringValue(fieldIndex, buff.toString());
                        }
                        return false;
                    }
                } else {
                    buff.append((char)c[cnt]);
                }
                cnt = (cnt + 1) % 3;
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        return false;
    }

    public static void StoreRecord(IRecord rec, DataOutput out) throws IOException {
        int n = 0;
        while (n < rec.getColumnCount()) {
            out.writeBytes(rec.getStringValue(n));
            out.writeBytes("|");
            ++n;
        }
        out.writeBytes("\r\n");
    }

    public static void StoreToFile(Enumeration records, File file2) throws IOException {
        FileOutputStream out = new FileOutputStream(file2);
        DataOutputStream dout = new DataOutputStream(out);
        while (records.hasMoreElements()) {
            TableSupport.StoreRecord((IRecord)records.nextElement(), dout);
        }
        out.close();
    }
}

