/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.data.impl;

import java.util.Enumeration;
import netcomputing.collections.NCArray;
import netcomputing.collections.NCHashtable;
import netcomputing.data.IDataField;
import netcomputing.data.IFieldMetaInfo;
import netcomputing.data.IRecord;
import netcomputing.data.RecordSupport;
import netcomputing.data.impl.BasicDataField;

public class BasicRecord
extends RecordSupport {
    NCHashtable tab = new NCHashtable(15);
    NCHashtable idToMeta = new NCHashtable(15);
    NCArray meta;

    public BasicRecord(NCArray meta) {
        this.meta = meta;
        this.createFields();
    }

    public void createFields() {
        int n = 0;
        while (n < this.meta.size()) {
            String key = ((IFieldMetaInfo)this.meta.at(n)).getId();
            if (this.tab.get(key) == null) {
                this.tab.put(key, new BasicDataField());
                this.idToMeta.put(key, this.meta.at(n));
            }
            ++n;
        }
    }

    public void rem(String field) {
        this.tab.rem(field);
        this.idToMeta.rem(field);
        int n = 0;
        while (n < this.meta.size()) {
            if (((IFieldMetaInfo)this.meta.at(n)).getId().equals(field)) {
                this.meta.remAt(n);
                --n;
            }
            ++n;
        }
    }

    public IRecord copy() {
        BasicRecord res = new BasicRecord(this.getMetaInfo());
        int n = 0;
        while (n < this.getColumnCount()) {
            res.setStringValue(n, this.getStringValue(n));
            ++n;
        }
        return res;
    }

    public IDataField getField(String name) {
        return (IDataField)this.tab.get(name);
    }

    public IDataField getFieldAt(int index) {
        IFieldMetaInfo fm = (IFieldMetaInfo)this.meta.at(index);
        return this.getField(fm.getId());
    }

    public Enumeration enumerate() {
        return this.tab.enumerate();
    }

    public int getColumnCount() {
        return this.meta.size();
    }

    public NCArray getMetaInfo() {
        return this.meta;
    }

    public String toString() {
        String res = "BasicRecord:-----------\n";
        int n = 0;
        while (n < this.getColumnCount()) {
            res = res + this.getMetaInfo(n).getLabelString() + ":" + this.getStringValue(n) + "\n";
            ++n;
        }
        return res + "------------\n";
    }

    public IFieldMetaInfo getMetaInfo(String id) {
        return (IFieldMetaInfo)this.idToMeta.get(id);
    }
}

