/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.tools;

import de.netcomputing.util.Tracer;
import netcomputing.tools.INCPrintOut;
import netcomputing.tools.MissingApi;
import netcomputing.tools.Sucker;

public class ClineProcess
implements Runnable {
    INCPrintOut out = null;
    int[] phandle = new int[]{0};
    int[] ohandle = new int[]{0, 0, 0};
    int exitValue = -9999;
    Sucker sucker;
    Thread runner;

    public static void main(String[] a) {
        ClineProcess.ExecAndForget("javac ListCanvas.java", "g:\\j11\\Source\\JWidgets");
    }

    public static ClineProcess Exec(String cline) throws Exception {
        return ClineProcess.Exec(cline, null, null);
    }

    public static ClineProcess Exec(String cline, String workDir) throws Exception {
        return ClineProcess.Exec(cline, workDir, null);
    }

    public static ClineProcess Exec(String cline, INCPrintOut out) throws Exception {
        return ClineProcess.Exec(cline, null, out);
    }

    public static ClineProcess Exec(String cline, String wDir, INCPrintOut out) throws Exception {
        ClineProcess result = new ClineProcess();
        result.exec(cline, wDir, out);
        return result;
    }

    public static void ExecAndForget(String cline, String workingDir) {
        Tracer.This.println("ExecAndForget:" + cline + " wd:" + workingDir);
        MissingApi.CreateProcessAndForget(cline, workingDir);
    }

    void exec(String cline, String workingDir, INCPrintOut out) throws Exception {
        this.out = out;
        if (workingDir == null || workingDir.trim().length() == 0) {
            workingDir = ".";
        }
        Tracer.This.println("Exec:" + cline);
        MissingApi.CreateProcess(cline, workingDir, this.phandle, this.ohandle);
        this.sucker = new Sucker(this);
        this.sucker.start();
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void run() {
        while (!this.isTerminated()) {
            try {
                Thread.sleep(400L);
                Tracer.This.println("waiting:" + this.exitValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Tracer.This.println("exitValue:" + this.exitValue);
        if (this.out != null) {
            this.out.processTerminated(this.exitValue);
        }
        this.close();
        Tracer.This.println("terminated " + this.exitValue());
    }

    public boolean isTerminated() {
        this.exitValue = MissingApi.GetExitCode(this.phandle[0]);
        return MissingApi.IsTerminated(this.phandle[0]);
    }

    public int exitValue() {
        if (this.exitValue == -9999) {
            this.exitValue = MissingApi.GetExitCode(this.phandle[0]);
        }
        return this.exitValue;
    }

    public int close() {
        if (!this.isTerminated()) {
            MissingApi.TerminateProcess(this.phandle[0], 1);
        }
        if (this.sucker != null) {
            this.sucker.stopMe();
            this.sucker = null;
            this.exitValue = this.exitValue();
            MissingApi.Close(this.phandle[0], this.ohandle[0], this.ohandle[1]);
        }
        if (this.runner != null) {
            this.runner.stop();
            this.runner = null;
        }
        return this.exitValue;
    }

    public String read() {
        if (this.isTerminated()) {
            return null;
        }
        if (this.sucker != null && this.sucker.buffer != null) {
            return this.sucker.buffer.toString();
        }
        return "";
    }

    String privateRead() {
        try {
            String c = MissingApi.ReadChars(this.ohandle[0]);
            if (c.length() == 0 && this.isTerminated()) {
                return "";
            }
            return c;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

