/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.undo;

import de.netcomputing.util.Tracer;
import java.util.Vector;
import netcomputing.undo.IUndoAction;

public class UndoTracker {
    Vector v = new Vector();
    int maxUndoSize = 999999;
    int undoCount = -1;
    boolean lockAdd = false;
    boolean lockMode = true;
    boolean isChanged = false;

    public void setIsChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public boolean getIsChanged() {
        return this.isChanged;
    }

    public void addUndoAction(IUndoAction action) {
        Tracer.This.println("adding undo action:" + action.getDescription());
        if (this.lockAdd && this.lockMode) {
            return;
        }
        this.setIsChanged(true);
        this.v.setSize(this.undoCount + 1);
        this.v.addElement(action);
        this.undoCount = this.v.size() - 1;
    }

    public void setMark() {
        if (this.undoCount < 0 || this.undoCount >= this.v.size()) {
            return;
        }
        this.actionAt(this.undoCount).setMark(true);
    }

    public IUndoAction last() {
        return this.actionAt(this.undoCount);
    }

    IUndoAction actionAt(int i) {
        return (IUndoAction)this.v.elementAt(i);
    }

    public boolean canUndo() {
        return this.undoCount >= 0 && this.undoCount < this.v.size();
    }

    public boolean canRedo() {
        return this.undoCount >= -1 && this.undoCount < this.v.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean undo() {
        if (this.undoCount < 0 || this.undoCount >= this.v.size()) {
            return false;
        }
        boolean res = false;
        try {
            this.lockAdd = true;
            IUndoAction action = this.actionAt(this.undoCount);
            res = action.performAction(true);
            Tracer.This.println("undo:" + this.undoCount + " " + action);
            --this.undoCount;
            while (this.undoCount > 0 && !(action = this.actionAt(this.undoCount)).getMark()) {
                res = action.performAction(true);
                Tracer.This.println("undo:" + this.undoCount + " " + action);
                action = this.actionAt(this.undoCount);
                --this.undoCount;
            }
            this.lockAdd = false;
            Object var4_3 = null;
            this.lockAdd = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lockAdd = false;
            throw throwable;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean redo() {
        boolean res = false;
        if (this.undoCount == this.v.size() - 1) {
            return false;
        }
        try {
            IUndoAction action;
            this.lockAdd = true;
            while (this.undoCount + 1 < this.v.size() && !(action = this.actionAt(this.undoCount + 1)).getMark()) {
                void var2_2;
                ++this.undoCount;
                Tracer.This.println("redo:" + this.undoCount + " " + var2_2);
                res = var2_2.performAction(false);
            }
            if (this.undoCount + 1 < this.v.size()) {
                ++this.undoCount;
                action = this.actionAt(this.undoCount);
                Tracer.This.println("redo:" + this.undoCount + " " + action);
                res = action.performAction(false);
            }
            this.lockAdd = false;
            Object var4_3 = null;
            this.lockAdd = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lockAdd = false;
            throw throwable;
        }
        return res;
    }

    public void setLockMode(boolean lockMode) {
        this.lockMode = lockMode;
    }

    public boolean getLockMode() {
        return this.lockMode;
    }
}

