/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import de.netcomputing.anyj.filenodes.FileType;
import de.netcomputing.anyj.filenodes.FileTypes;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.NCStringUtilities;
import editapp.EditApp;
import java.util.Vector;
import jxeplugins.JEBasicPlugin;

public class FileTypesPlugin
extends JEBasicPlugin {
    public void init(EditApp app) {
        super.init(app);
    }

    public void propertyChanged() {
        String s = (String)this.app.getWorkspaceProperty("StringList.Filetypes");
        if (s != null) {
            Vector v = NCStringUtilities.SplitSeparatedString(";", s);
            int n = 0;
            while (n < v.size()) {
                String type = v.elementAt(n).toString();
                NCApplication.PutImage("lbox-" + type, type + ".gif");
                NCApplication.PutImage("lbox-" + type + "-ro", type + "ro.gif");
                NCApplication.PutImage("lbox-" + type + "-ro-sc", type + "ro.gif");
                NCApplication.PutImage("lbox-" + type + "-sc", type + ".gif");
                FileType.RegisterType(new FileType(type, null));
                ++n;
            }
        }
        FileTypes.RegisterTypes();
    }

    public void addProperties(EditApp app) {
        if (app.getWorkspaceProperty("StringList.Filetypes") == null) {
            app.setGlobalProperty("StringList.Filetypes", "html;htm;txt");
        }
        this.propertyChanged();
    }

    public String getDescription() {
        return "This plugin enables you specify file-extensions, which should be visible in the main windows' file tree. You have to set the \"StringList.Filetypes\" property.The images to be displayed must be stored in the images directory. The name of the images are [extension].gif (simple), [ext]ro.gif (read only icon). Example name [AnyJdir]\\images\\html.gif, [AnyJdir]\\images\\htmlro.gif";
    }
}

