/*
 * Decompiled with CFR 0.152.
 */
package plugins.bookmarks;

import de.netcomputing.anyj.application.FileSet;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.JListPanel;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import java.awt.Image;
import java.io.File;
import java.util.Vector;

public class BookmarkItem
extends ListItem {
    static Image im;
    public File file;
    public int posX;
    public int posY;
    public String name = "";
    Vector contentVector;

    public BookmarkItem(String name, int x, int y, File f) {
        super(name);
        this.setDepth(0);
        this.name = name;
        this.posX = x;
        this.posY = y;
        this.file = f;
        this.object = f;
        if (this.object == null) {
            this.object = "_NULL_";
        }
    }

    public BookmarkItem deepCopy() {
        BookmarkItem cop = new BookmarkItem(this.name, this.posX, this.posY, this.file);
        if (this.contentVector != null) {
            Vector<BookmarkItem> contV = new Vector<BookmarkItem>(this.contentVector.size());
            int n = 0;
            while (n < this.contentVector.size()) {
                contV.addElement(((BookmarkItem)this.contentVector.elementAt(n)).deepCopy());
                ++n;
            }
            cop.contentVector = contV;
            cop.contents(null);
        }
        return cop;
    }

    public String getDisplayString() {
        if (this.name == null) {
            this.name = "_";
        }
        if (this.file != null) {
            if (this.file.getName().equals(this.name)) {
                return this.name + "  (" + this.posY + ")";
            }
            return this.name + "  (" + this.file.getName() + " " + this.posY + ")";
        }
        return this.name;
    }

    public IListItem[] contents() {
        if (this.contentVector == null) {
            return super.contents();
        }
        IListItem[] il = new IListItem[this.contentVector.size()];
        int n = 0;
        while (n < il.length) {
            il[n] = (IListItem)this.contentVector.elementAt(n);
            ++n;
        }
        return il;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        return ((BookmarkItem)o).getDisplayString().equals(this.getDisplayString());
    }

    public Image getOpenImage() {
        return NCApplication.GetImage("bookmark-folder-open");
    }

    public Image getImage() {
        if (this.isDir()) {
            return NCApplication.GetImage("bookmark-folder");
        }
        return NCApplication.GetImage("/images/menus/add bookmark.gif");
    }

    public boolean isDir() {
        return this.file == null;
    }

    public void setContentVector(Vector contentVector) {
        this.contentVector = contentVector;
    }

    public Vector getContentVector() {
        return this.contentVector;
    }

    public void clearContent() {
        this.contentVector = null;
    }

    public int readContentFromListBox(int index, JListPanel lp, int selDepth) {
        BookmarkItem bi = (BookmarkItem)lp.at(index);
        this.contentVector = new Vector();
        while (index < lp.listSize() && lp.at(index).getDepth() > selDepth) {
            if (lp.at(index).getDepth() == selDepth + 1) {
                this.contentVector.addElement(lp.at(index));
                ++index;
                continue;
            }
            index = ((BookmarkItem)lp.at(index - 1)).readContentFromListBox(index, lp, lp.at(index - 1).getDepth());
        }
        return index;
    }

    public Object wrappedObject() {
        return this.dataObject();
    }

    public Object dataObject() {
        if (this.file == null) {
            if (this.getContentVector() == null) {
                return null;
            }
            FileSet fs = new FileSet(this.getContentVector().size() * 2);
            int n = 0;
            while (n < this.getContentVector().size()) {
                BookmarkItem bi = (BookmarkItem)this.getContentVector().elementAt(n);
                if (bi.getFile() != null) {
                    fs.add(bi.getFile());
                }
                ++n;
            }
            return fs;
        }
        return this.file;
    }

    public boolean hasContent() {
        return this.contentVector != null && this.contentVector.size() > 0;
    }

    public File getFile() {
        return this.file;
    }

    static {
        NCApplication.PutImage("bookmark-folder", "folder8.gif");
        NCApplication.PutImage("bookmark-folder-open", "folder8o.gif");
    }
}

