/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import util.ConstantPoolInfo;

public class AttributeInfo {
    public ConstantPoolInfo name;
    byte[] data;

    public AttributeInfo(ConstantPoolInfo newName, byte[] newData) {
        this.name = this.name;
        this.data = newData;
    }

    public AttributeInfo() {
    }

    public boolean read(DataInputStream di, ConstantPoolInfo[] pool) throws IOException {
        this.name = pool[di.readShort()];
        int len = di.readInt();
        this.data = new byte[len];
        len = di.read(this.data);
        return len == this.data.length;
    }

    public void write(DataOutputStream dos, ConstantPoolInfo[] pool) throws IOException, Exception {
        dos.writeShort(ConstantPoolInfo.indexOf(this.name, pool));
        dos.writeInt(this.data.length);
        dos.write(this.data, 0, this.data.length);
    }

    short indexFromBytes(byte[] a) {
        return (short)(a[0] << 8 & 0xFF00 | a[1] << 0 & 0xFF);
    }

    public String toString(ConstantPoolInfo[] pool) {
        StringBuffer x = new StringBuffer();
        String type = this.name.toString();
        if (type.compareTo("ConstantValue") == 0) {
            ConstantPoolInfo item = pool[this.indexFromBytes(this.data)];
            return item.toString();
        }
        if (type.compareTo("SourceFile") == 0) {
            ConstantPoolInfo item = pool[this.indexFromBytes(this.data)];
            return item.toString();
        }
        x.append(type + "<" + this.data.length + " bytes>");
        return x.toString();
    }

    public String toBoolean(ConstantPoolInfo[] pool) {
        ConstantPoolInfo item = pool[this.indexFromBytes(this.data)];
        if (item.intValue == 0) {
            return "= false";
        }
        return "= true";
    }

    public String toString() {
        return this.name.toString() + " <" + this.data.length + " bytes>";
    }
}

