/******************************************************
 * File: MainSessionBean.java
 * created 21.05.2002 05:00:19 by ruedi
 */
package sample.ejb;
import javax.ejb.*;
import java.util.*;
import java.rmi.*;
import java.beans.AppletInitializer;

/**
 * A stateful session bean.<br>
 * This is the basic class for your EJB. The Home/Remote/Local/LocalHome interfaces
 * are generated by AnyJ. See comments below for further explanation.
 */
//@EJB:remote,stateful,local,bmp
public class MainSessionBean implements SessionBean
{
	/**
	 * A stateless Session Bean must have a public empty constructor
	 */
	public MainSessionBean()
	{
	}
	
	/**
	 * called by the container when the create() method is called on the home interface
	 */
	//@EJB:remote,local
	public void ejbCreate() throws CreateException 
	{
		System.out.println( "ejbCreate" );
	}

	/**
	 * session timed out or remove() has been called by the client
	 */
	public void ejbRemove() 
	{
		System.out.println( "ejbRemove" );
	}
	
	/**
	 * called by the container to awake a session bean after it has been put to sleep
	 * by a ejbPassivate() call.
	 */
	public void ejbActivate() 
	{
		System.out.println( "ejbActivate" );
	}
	
	/**
	 * called by the container to tell the session bean that it has been suspended
	 * from use ('sleep').
	 */
	public void ejbPassivate() 
	{
		System.out.println( "ejbPassivate" );
	}
	
	SessionContext sessionContext;
	public void setSessionContext(SessionContext sessionContext) 
	{
		this.sessionContext = sessionContext;
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	//@EJB:remote,local
	public String getHello( int times )
	{
		String result = "";
		for ( int i = 0; i < times; i++ )
		{
			result += "HELLO "; 
		}
		return result; 
	}
	
	//@EJB:remote
	public String doubleString( String testString )
    {
		return testString+" "+testString;  
	}
	
	/*
	
	to add methods to your home / local home methods, declare them (name must start with 'ejbHome')
	and specify wether they are local,remote or both. 
	After successful compilation choose 'Generate Home/Remote/Local interfaces' from the Tools|EJB menu
    Please use a declaration syntax similar to that below to avoid parsing trouble. 
	
	//@EJB:remote,local
	public void ejbHomeMyMethod( int arg )
	{
		 
	}
	
	*/


	/*
	
	to add methods to your bean just declare them and specify
	in the @EJB statement wether they are local or remote or both.
	After successful compilation choose 'Generate Home/Remote/Local interfaces' from the Tools|EJB menu
	Please use a declaration syntax similar to that below to avoid parsing trouble.
	
	//@EJB:remote,local
	public void myMethod()
	{
	}
	
	*/

}
