/******************************************************
 * File: Sample.java
 * created 26.05.2002 00:15:45 by ruedi
 */
package sample;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sample.ejb.MainSessionHome;
import sample.ejb.MainSessionRemote;

public class SampleServlet extends HttpServlet
{
	
	public SampleServlet() throws NamingException {
		Properties props = new Properties();
		props.put( Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory" );
		context = new InitialContext(props);
	}

	Context context;
	
	 /**
	 * Handle the GET and HEAD methods by building a simple web page.
	 * HEAD is just like GET, except that the server returns only the
	 * headers (including content length) not the body we write.
	 */
	public void doGet( HttpServletRequest request, HttpServletResponse response )
		throws ServletException, IOException
	{
		PrintWriter out;
		out = response.getWriter();
		response.setContentType("text/html");

		out.println("<HTML><HEAD><TITLE>");
		out.println("Title");
		out.println("</TITLE></HEAD><BODY>");
		out.println("<H2>A Servlet accessing an EJB</H2>");
		
		// accessing an EJB
		// note that the Home and Remote classes have to be added to the servlets 
		// webmodule.war deployment configuration (Tools|Deploy Jar)
		try {
			MainSessionHome home = (MainSessionHome) PortableRemoteObject.narrow( 
				context.lookup( "MainSessionRemote" ),
				MainSessionHome.class
			);
			MainSessionRemote mainSess = home.create();
			out.println( "<b>result of calling getHello( 5 ) </b><br>" );
			out.println( mainSess.getHello( 5 ) );
			out.println( "<BR><br>" );
			out.println( "<b>result of calling doubleString( .. ) </b><br>" );
			out.println( mainSess.doubleString( "EJB Test" ) );

			mainSess.remove();
		} catch ( Exception ex ) {
			ex.printStackTrace();
		}
		
		
		out.println("<P>This is output from: " + getClass().getName() );
		out.println("</BODY></HTML>");
		out.close();
	}	

}
