/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit;

import edu.rice.cs.cunit.instrumentors.DoNotInstrument;
import edu.rice.cs.cunit.record.syncPoints.ISyncPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DoNotInstrument(instrumentors="***.*Synchronized*;***.ObjectCallStrategy;***.AssignObjectIDStrategy")
public class SyncPointBuffer {
    public static final int SIZE = 512;
    private static volatile ISyncPoint[] _syncPoints = new ISyncPoint[512];
    private static volatile int _index = 0;
    public static final int COMPACT_RECORD_SIZE = 2;
    public static final int COMPACT_DEBUG_RECORD_SIZE = 5;
    public static final int COMPACT_SIZE = 512;
    private static volatile long[] _compactSyncPoints = new long[512];
    private static volatile int _compactIndex = 0;
    public static final int REPLAY_SIZE = 512;
    private static volatile long[] _replaySyncPoints = new long[512];
    private static volatile Object[] _replayWaitArray = new Object[256];
    private static final Object _waitAlgoObj = new Object();
    private static final Object _newBufferWaitObj = new Object();
    private static volatile int _replayIndex = 0;
    private static volatile int _replayWaitIndex = 0;
    private static volatile boolean _recording = false;
    private static volatile boolean _transferImmediately = false;
    private static volatile long[] _immediateTransfer = new long[5];
    private static volatile boolean _replaying = false;
    private static volatile boolean _replayBufferLoaded = false;
    public static volatile long _nextObjectID = 0L;
    public static volatile long _nextThreadID = 0L;
    public static volatile String _message = null;
    public static volatile long _runningThreads = 0L;
    public static final int RANDOM_DELAY_MIN = 0;
    public static final int RANDOM_DELAY_MAGNITUDE = 5000;
    public static boolean RANDOM_DELAY_THREAD_START = true;
    public static boolean RANDOM_DELAY_THREAD_EXIT = true;
    public static boolean RANDOM_DELAY_THREAD_RUN = true;
    public static boolean RANDOM_DELAY_THREAD_JOIN = true;
    public static boolean RANDOM_DELAY_PRE_NOTIFY = true;
    public static boolean RANDOM_DELAY_POST_NOTIFY = true;
    public static boolean RANDOM_DELAY_PRE_WAIT = true;
    public static boolean RANDOM_DELAY_POST_WAIT = true;
    public static boolean RANDOM_DELAY_PRE_MONITOR = true;
    public static boolean RANDOM_DELAY_POST_MONITOR = true;
    public static float RANDOM_YIELD_PROB = 1.0f;
    public static boolean RANDOM_YIELD_THREAD_START = true;
    public static boolean RANDOM_YIELD_THREAD_EXIT = true;
    public static boolean RANDOM_YIELD_THREAD_RUN = true;
    public static boolean RANDOM_YIELD_THREAD_JOIN = true;
    public static boolean RANDOM_YIELD_PRE_NOTIFY = true;
    public static boolean RANDOM_YIELD_POST_NOTIFY = true;
    public static boolean RANDOM_YIELD_PRE_WAIT = true;
    public static boolean RANDOM_YIELD_POST_WAIT = true;
    public static boolean RANDOM_YIELD_PRE_MONITOR = true;
    public static boolean RANDOM_YIELD_POST_MONITOR = true;

    public static final Class<?> _class() {
        return SyncPointBuffer.class;
    }

    public static synchronized void add(ISyncPoint sp) {
        if (!_recording) {
            return;
        }
        SyncPointBuffer._syncPoints[SyncPointBuffer._index] = sp;
        if (512 == ++_index) {
            SyncPointBuffer.transfer();
        }
    }

    public static void transfer() {
        for (int i = 0; i < 512; ++i) {
            SyncPointBuffer._syncPoints[i] = null;
        }
        _index = 0;
    }

    public static synchronized void compactAdd(long code, long tid) {
        if (!_recording) {
            return;
        }
        if (_transferImmediately) {
            SyncPointBuffer._immediateTransfer[0] = tid;
            SyncPointBuffer._immediateTransfer[1] = code;
            SyncPointBuffer.compactImmediateTransfer();
        } else {
            SyncPointBuffer._compactSyncPoints[SyncPointBuffer._compactIndex++] = tid;
            SyncPointBuffer._compactSyncPoints[SyncPointBuffer._compactIndex++] = code;
            if (512 <= _compactIndex) {
                SyncPointBuffer.compactTransfer();
            }
        }
    }

    public static synchronized void compactDebugAdd(long oid, long code, long tid, long classIndex, long methodAndPC) {
        if (!_recording) {
            return;
        }
        if (_transferImmediately) {
            SyncPointBuffer._immediateTransfer[0] = tid;
            SyncPointBuffer._immediateTransfer[1] = code;
            SyncPointBuffer._immediateTransfer[2] = classIndex;
            SyncPointBuffer._immediateTransfer[3] = methodAndPC;
            SyncPointBuffer._immediateTransfer[4] = oid;
            SyncPointBuffer.compactImmediateTransfer();
        } else {
            SyncPointBuffer._compactSyncPoints[SyncPointBuffer._compactIndex++] = tid;
            SyncPointBuffer._compactSyncPoints[SyncPointBuffer._compactIndex++] = code;
            SyncPointBuffer._compactSyncPoints[SyncPointBuffer._compactIndex++] = classIndex;
            SyncPointBuffer._compactSyncPoints[SyncPointBuffer._compactIndex++] = methodAndPC;
            SyncPointBuffer._compactSyncPoints[SyncPointBuffer._compactIndex++] = oid;
            if (510 <= _compactIndex) {
                SyncPointBuffer.compactTransfer();
            }
        }
    }

    public static void compactTransfer() {
        for (int i = 0; i < 512; ++i) {
            SyncPointBuffer._compactSyncPoints[i] = 0L;
        }
    }

    public static void compactImmediateTransfer() {
        for (int i = 0; i < 5; ++i) {
            SyncPointBuffer._immediateTransfer[i] = 0L;
        }
    }

    public static synchronized void compactWait(long code, long tid) {
        SyncPointBuffer.compactWait(code, tid, -1L, -1L);
    }

    public static synchronized void compactThreadExit(long tid) {
        SyncPointBuffer.compactThreadExit(tid, -1L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void compactWait(long code, long tid, long classIndex, long methodAndPC) {
        if (!_replaying) {
            return;
        }
        boolean oldReplaying = _replaying;
        try {
            _replaying = false;
            SyncPointBuffer.monitorEnter(_waitAlgoObj);
            SyncPointBuffer.setMessage(tid + " " + code + " - compactWait class=" + Long.toHexString(classIndex) + " method=" + Long.toHexString(methodAndPC >>> 32) + ", PC=" + Long.toHexString(methodAndPC & 0xFFFFL));
            if (SyncPointBuffer.isOldThread()) {
                _replayIndex += 2;
                ++_replayWaitIndex;
                SyncPointBuffer.setMessage("\told thread");
            } else {
                SyncPointBuffer.setOldThread();
                SyncPointBuffer.setMessage("\tnew thread, oldThread = " + SyncPointBuffer.isOldThread());
            }
            if (!_replayBufferLoaded || _replayIndex >= 512) {
                SyncPointBuffer.replayTransfer();
                Object object = _newBufferWaitObj;
                synchronized (object) {
                    _newBufferWaitObj.notifyAll();
                }
            }
            _replayIndex += 2;
            ++_replayWaitIndex;
            SyncPointBuffer.monitorExit(_waitAlgoObj);
        }
        finally {
            _replaying = oldReplaying;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void compactThreadExit(long tid, long classIndex, long methodAndPC) {
        if (!_replaying) {
            return;
        }
        boolean oldReplaying = _replaying;
        try {
            _replaying = false;
            SyncPointBuffer.setMessage(tid + " " + SP.THREADEXIT.intValue() + " - compactWait class=" + Long.toHexString(classIndex) + " method=" + Long.toHexString(methodAndPC >>> 32) + ", PC=" + Long.toHexString(methodAndPC & 0xFFFFL));
        }
        finally {
            _replaying = oldReplaying;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replayTransfer() {
        _replayIndex = 0;
        _replayWaitIndex = 0;
        _replayBufferLoaded = true;
        Object object = _newBufferWaitObj;
        synchronized (object) {
            _newBufferWaitObj.notifyAll();
        }
    }

    public static synchronized boolean isRecording() {
        return _recording;
    }

    public static synchronized void setRecording(boolean recording) {
        _recording = recording;
    }

    public static void setMessage(String message) {
        _message = message;
    }

    public static void monitorEnter(Object o) {
    }

    public static void monitorExit(Object o) {
    }

    public static boolean isOldThread() {
        return true;
    }

    public static void setOldThread() {
    }

    public static void randomDelay(boolean delay) {
        if (delay && _runningThreads > 1L) {
            try {
                Thread.sleep((long)(0.0 + Math.random() * 5000.0));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delayThreadStart(boolean delay) {
        Class<SyncPointBuffer> clazz = SyncPointBuffer.class;
        synchronized (SyncPointBuffer.class) {
            ++_runningThreads;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            SyncPointBuffer.randomDelay(delay);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delayThreadExit(boolean delay) {
        SyncPointBuffer.randomDelay(delay);
        Class<SyncPointBuffer> clazz = SyncPointBuffer.class;
        synchronized (SyncPointBuffer.class) {
            --_runningThreads;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delayObjectWait(boolean delay) {
        Class<SyncPointBuffer> clazz = SyncPointBuffer.class;
        synchronized (SyncPointBuffer.class) {
            if (_runningThreads <= 2L) {
                throw new AssertionError((Object)("Call to Object.wait with only one user thread alive (_runningThreads==" + _runningThreads + ")"));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            SyncPointBuffer.randomDelay(delay);
            return;
        }
    }

    public static void randomYield(boolean yield) {
        if (yield && _runningThreads > 1L && (RANDOM_YIELD_PROB >= 1.0f || RANDOM_YIELD_PROB > 0.0f && Math.random() < (double)RANDOM_YIELD_PROB)) {
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void yieldThreadStart(boolean yield) {
        Class<SyncPointBuffer> clazz = SyncPointBuffer.class;
        synchronized (SyncPointBuffer.class) {
            ++_runningThreads;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            SyncPointBuffer.randomYield(yield);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void yieldThreadExit(boolean yield) {
        SyncPointBuffer.randomYield(yield);
        Class<SyncPointBuffer> clazz = SyncPointBuffer.class;
        synchronized (SyncPointBuffer.class) {
            --_runningThreads;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void yieldObjectWait(boolean yield) {
        Class<SyncPointBuffer> clazz = SyncPointBuffer.class;
        synchronized (SyncPointBuffer.class) {
            if (_runningThreads <= 2L) {
                throw new AssertionError((Object)("Call to Object.wait with only one user thread alive (_runningThreads==" + _runningThreads + ")"));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            SyncPointBuffer.randomYield(yield);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SP {
        MONITORENTER(1),
        MONITOREXIT(2),
        TRYMONITORENTER(3),
        THREADSTART(4),
        THREADEXIT(5),
        OBJID_MONITORENTER(6),
        OBJID_MONITOREXIT(7),
        OBJID_TRYMONITORENTER(8),
        THREADID_MONITORENTER(9),
        THREADID_MONITOREXIT(10),
        THREADID_TRYMONITORENTER(11),
        END(12),
        LAST_VALID_CODE(12);

        private int _value;

        private SP(int value) {
            this._value = value;
        }

        public int intValue() {
            return this._value;
        }
    }
}

