/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile;

import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.LineNumberTableAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.ADefaultAttributeVisitor;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodInfo {
    private short _accessFlags;
    private AUTFPoolInfo _name;
    private AUTFPoolInfo _descriptor;
    private ArrayList<AAttributeInfo> _attributes = new ArrayList();

    public MethodInfo(short accessFlags, AUTFPoolInfo name, AUTFPoolInfo signature, AAttributeInfo[] attributes) {
        this._accessFlags = accessFlags;
        this._name = name;
        this._descriptor = signature;
        if (attributes != null) {
            for (AAttributeInfo attr : attributes) {
                this._attributes.add(attr);
            }
        }
    }

    public MethodInfo(DataInputStream di, ConstantPool pool) throws IOException, ClassFormatError {
        this._accessFlags = di.readShort();
        this._name = ((APoolInfo)pool.get(di.readShort())).execute(CheckUTFVisitor.singleton(), null);
        this._descriptor = ((APoolInfo)pool.get(di.readShort())).execute(CheckUTFVisitor.singleton(), null);
        int count = di.readShort();
        for (int i = 0; i < count; ++i) {
            this._attributes.add(AAttributeInfo.read(di, pool));
        }
    }

    public void write(DataOutputStream dos, ConstantPool pool) throws IOException {
        dos.writeShort(this._accessFlags);
        dos.writeShort(pool.indexOf(this._name));
        dos.writeShort(pool.indexOf(this._descriptor));
        dos.writeShort(this._attributes.size());
        for (AAttributeInfo attr : this._attributes) {
            attr.write(dos);
        }
    }

    public String toString() {
        String s = this._descriptor.toString();
        String paramSig = s.substring(s.indexOf(40) + 1, s.indexOf(41));
        String returnSig = s.substring(s.indexOf(41) + 1);
        StringBuilder parameterList = new StringBuilder();
        parameterList.append(this._name + "(");
        char initialParameter = 'a';
        if (paramSig.length() > 0 && paramSig.charAt(0) != 'V') {
            while (paramSig.length() > 0) {
                StringBuilder varName = new StringBuilder();
                varName.append(initialParameter);
                initialParameter = (char)(initialParameter + '\u0001');
                parameterList.append(ClassFileTools.getTypeString(paramSig, varName.toString()));
                if ((paramSig = ClassFileTools.getNextSignature(paramSig)).length() <= 0) continue;
                parameterList.append(", ");
            }
        }
        parameterList.append(")");
        StringBuilder x = new StringBuilder();
        x.append(ClassFileTools.getAccessString(this._accessFlags));
        x.append(ClassFileTools.getTypeString(returnSig, parameterList.toString()));
        return x.toString();
    }

    public String toString(ConstantPool pool) {
        return this.toString(pool, true, true);
    }

    public String toString(ConstantPool pool, boolean lineNumbers, boolean PCs) {
        String s = this._descriptor.toString();
        String paramSig = s.substring(s.indexOf(40) + 1, s.indexOf(41));
        String returnSig = s.substring(s.indexOf(41) + 1);
        StringBuilder parameterList = new StringBuilder();
        parameterList.append(this._name + "(");
        char initialParameter = 'a';
        if (paramSig.length() > 0 && paramSig.charAt(0) != 'V') {
            while (paramSig.length() > 0) {
                StringBuilder varName = new StringBuilder();
                varName.append(initialParameter);
                initialParameter = (char)(initialParameter + '\u0001');
                parameterList.append(ClassFileTools.getTypeString(paramSig, varName.toString()));
                if ((paramSig = ClassFileTools.getNextSignature(paramSig)).length() <= 0) continue;
                parameterList.append(", ");
            }
        }
        parameterList.append(")");
        StringBuilder x = new StringBuilder();
        x.append(ClassFileTools.getAccessString(this._accessFlags));
        x.append(ClassFileTools.getTypeString(returnSig, parameterList.toString()));
        for (AAttributeInfo attr : this._attributes) {
            x.append("\n\t" + attr.toString());
        }
        if ((this._accessFlags & 0x500) == 0) {
            CodeAttributeInfo ca = this.getCodeAttributeInfo();
            x.append("\n" + new InstructionList(ca.getCode()).toString(lineNumbers, PCs, pool));
            ArrayList<LineNumberTableAttributeInfo.LineNumberRecord> lntErrors = this.checkLineNumbers();
            if (lntErrors.size() > 0) {
                x.append("\t" + LineNumberTableAttributeInfo.getAttributeName() + " Errors!\n");
                for (LineNumberTableAttributeInfo.LineNumberRecord lnr : lntErrors) {
                    x.append("\t\t(PC=" + lnr.startPC + " @ " + lnr.lineNo + ")\n");
                }
            }
        }
        return x.toString();
    }

    public ArrayList<LineNumberTableAttributeInfo.LineNumberRecord> checkLineNumbers() {
        ArrayList<LineNumberTableAttributeInfo.LineNumberRecord> errors = new ArrayList<LineNumberTableAttributeInfo.LineNumberRecord>();
        if ((this._accessFlags & 0x500) == 0) {
            AAttributeInfo attr;
            CodeAttributeInfo ca = this.getCodeAttributeInfo();
            LineNumberTableAttributeInfo lnt = null;
            AAttributeInfo[] arr$ = ca.getAttributes();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (lnt = (attr = arr$[i$]).execute(new ADefaultAttributeVisitor<LineNumberTableAttributeInfo, Object>(){

                @Override
                public LineNumberTableAttributeInfo defaultCase(AAttributeInfo host, Object param) {
                    return null;
                }

                @Override
                public LineNumberTableAttributeInfo lineNumberTableCase(LineNumberTableAttributeInfo host, Object param) {
                    return host;
                }
            }, null)) == null; ++i$) {
            }
            if (lnt != null) {
                InstructionList il = new InstructionList(ca.getCode());
                ArrayList<LineNumberTableAttributeInfo.LineNumberRecord> lns = new ArrayList<LineNumberTableAttributeInfo.LineNumberRecord>();
                for (LineNumberTableAttributeInfo.LineNumberRecord l : lnt.getLineNumbers()) {
                    lns.add(l);
                }
                Collections.sort(lns, new Comparator<LineNumberTableAttributeInfo.LineNumberRecord>(){

                    @Override
                    public int compare(LineNumberTableAttributeInfo.LineNumberRecord o1, LineNumberTableAttributeInfo.LineNumberRecord o2) {
                        return o1.startPC - o2.startPC;
                    }
                });
                for (LineNumberTableAttributeInfo.LineNumberRecord l : lns) {
                    boolean found = true;
                    while (il.getPCFromIndex(il.getIndex()) < l.startPC && (found = il.advanceIndex())) {
                    }
                    if (found && il.getPCFromIndex(il.getIndex()) == l.startPC) continue;
                    errors.add(l);
                }
            }
        }
        return errors;
    }

    public short getAccessFlags() {
        return this._accessFlags;
    }

    public void setAccessFlags(short accessFlags) {
        this._accessFlags = accessFlags;
    }

    public AUTFPoolInfo getName() {
        return this._name;
    }

    public void setName(AUTFPoolInfo name) {
        this._name = name;
    }

    public AUTFPoolInfo getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(AUTFPoolInfo descriptor) {
        this._descriptor = descriptor;
    }

    public ArrayList<AAttributeInfo> getAttributes() {
        return this._attributes;
    }

    public AAttributeInfo getAttribute(String name) {
        if (0 == this._attributes.size()) {
            return null;
        }
        for (AAttributeInfo attr : this._attributes) {
            if (0 != name.compareTo(attr.getName().toString())) continue;
            return attr;
        }
        return null;
    }

    public CodeAttributeInfo getCodeAttributeInfo() {
        for (AAttributeInfo attr : this._attributes) {
            CodeAttributeInfo code = attr.execute(new ADefaultAttributeVisitor<CodeAttributeInfo, Object>(){

                @Override
                public CodeAttributeInfo defaultCase(AAttributeInfo host, Object o) {
                    return null;
                }

                @Override
                public CodeAttributeInfo codeCase(CodeAttributeInfo host, Object o) {
                    return host;
                }
            }, null);
            if (code == null) continue;
            return code;
        }
        throw new ClassFormatError("Method has no Code attribute");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInfo that = (MethodInfo)o;
        if (this._accessFlags != that._accessFlags) {
            return false;
        }
        if (this._attributes != null ? !this._attributes.equals(that._attributes) : that._attributes != null) {
            return false;
        }
        if (this._descriptor != null ? !this._descriptor.equals(that._descriptor) : that._descriptor != null) {
            return false;
        }
        return !(this._name != null ? !this._name.equals(that._name) : that._name != null);
    }

    public int hashCode() {
        int result = this._accessFlags;
        result = 31 * result + (this._name != null ? this._name.hashCode() : 0);
        result = 31 * result + (this._descriptor != null ? this._descriptor.hashCode() : 0);
        result = 31 * result + (this._attributes != null ? this._attributes.hashCode() : 0);
        return result;
    }
}

