/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.attributes.AAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.util.Types;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class AMultipleNamedAnnotationsAttributeInfo
extends AAnnotationsAttributeInfo {
    public AMultipleNamedAnnotationsAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) {
        super(name, data, cp);
    }

    public int getEntityCount() {
        return this._data[0];
    }

    public NamedAnnotationsRecord[] getEntityAnnotations() throws ClassFormatError {
        int count = this.getEntityCount();
        NamedAnnotationsRecord[] nar = new NamedAnnotationsRecord[count];
        int index = 1;
        for (int i = 0; i < count; ++i) {
            AUTFPoolInfo name = ((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, index + 0))).execute(CheckUTFVisitor.singleton(), null);
            short annCount = (short)(0xFFFF & Types.ushortFromBytes(this._data, index + 2));
            index += 4;
            AAnnotationsAttributeInfo.Annotation[] ann = new AAnnotationsAttributeInfo.Annotation[annCount];
            for (short annIndex = 0; annIndex < annCount; annIndex = (short)(annIndex + 1)) {
                ann[annIndex] = new AAnnotationsAttributeInfo.Annotation(this._constantPool, this._data, index);
                index += ann[annIndex].getSize();
            }
            nar[i] = new NamedAnnotationsRecord(name, ann);
        }
        return nar;
    }

    public void setLocalVariableAnnotations(NamedAnnotationsRecord[] nars) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write((byte)nars.length);
        for (NamedAnnotationsRecord r : nars) {
            byte[] header = new byte[10];
            Types.bytesFromShort((short)(0xFFFF & this._constantPool.indexOf(r.name)), header, 0);
            Types.bytesFromShort((short)(0xFFFF & r.annotations.length), header, 2);
            baos.write(header, 0, 4);
            for (int i = 0; i < r.annotations.length; ++i) {
                try {
                    r.annotations[i].writeToByteArrayOutputStream(this._constantPool, baos);
                    continue;
                }
                catch (IOException e) {
                    throw new ClassFormatError("Error while writing out annotations");
                }
            }
        }
        this.setData(baos.toByteArray());
    }

    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(this._name);
        x.append(" <");
        x.append(this.getEntityCount());
        x.append(' ');
        x.append(this.getEntityName());
        x.append("(s) { ");
        boolean first = true;
        for (NamedAnnotationsRecord nars : this.getEntityAnnotations()) {
            if (first) {
                first = false;
            } else {
                x.append(", ");
            }
            x.append("(name=");
            x.append(nars.name.toString());
            x.append(", annotations ");
            x.append(nars.annotations.length);
            x.append(": {");
            boolean firstAnn = true;
            for (AAnnotationsAttributeInfo.Annotation ann : nars.annotations) {
                if (firstAnn) {
                    firstAnn = false;
                } else {
                    x.append(", ");
                }
                x.append(ann.toString());
            }
            x.append(" }");
        }
        x.append(" } >");
        return x.toString();
    }

    public abstract String getEntityName();

    public void adjustPC(int startPC, int deltaPC) {
    }

    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class NamedAnnotationsRecord {
        private final AUTFPoolInfo name;
        private final AAnnotationsAttributeInfo.Annotation[] annotations;

        public NamedAnnotationsRecord(AUTFPoolInfo name, AAnnotationsAttributeInfo.Annotation[] annotations) {
            this.name = name;
            this.annotations = new AAnnotationsAttributeInfo.Annotation[annotations.length];
            System.arraycopy(annotations, 0, this.annotations, 0, annotations.length);
        }

        public AUTFPoolInfo getName() {
            return this.name;
        }

        public AAnnotationsAttributeInfo.Annotation[] getAnnotations() {
            AAnnotationsAttributeInfo.Annotation[] as = new AAnnotationsAttributeInfo.Annotation[this.annotations.length];
            System.arraycopy(this.annotations, 0, as, 0, this.annotations.length);
            return as;
        }
    }
}

