/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.concJUnit;

import edu.rice.cs.cunit.FileInstrumentorLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.jar.JarFile;

public class ConcJUnitFileInstrumentorLauncher {
    static String concjunitrt = "%project.root%/concjunitrt.jar";
    public static final String CONFIG_STRING;

    public static void main(String[] args) {
        new ConcJUnitFileInstrumentorLauncher().run(args);
    }

    public void run(String[] args) {
        boolean run = false;
        for (String a : args) {
            if (a.equalsIgnoreCase("-h") || a.equalsIgnoreCase("--help")) {
                ConcJUnitFileInstrumentorLauncher.printHelp();
                System.exit(0);
                continue;
            }
            if (!a.equalsIgnoreCase("-r") && !a.equalsIgnoreCase("--run")) continue;
            run = true;
        }
        if (!run) {
            System.out.println(ConcJUnitFileInstrumentorLauncher.class.getName());
            System.out.println();
            System.out.println("This program will read your Java Runtime Environment (JRE) and create a");
            System.out.println("modified rt.concjunit.jar file in this directory. The original JRE will not be changed.");
            System.out.println();
            System.out.println("This process takes several minutes and requires about 30 MB of disk space.");
            System.out.println("Press Y and press the RETURN key if you want to continue.");
            try {
                String line = new BufferedReader(new InputStreamReader(System.in)).readLine();
                run = line.equalsIgnoreCase("y");
                if (run) {
                    System.out.println("Processing... Please wait.");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (run) {
            new ConcJUnitFileInstrumentorLauncherView();
        }
        System.out.println("Processing aborted.");
    }

    public static void printHelp() {
        System.out.println("Syntax:\n\tjava " + ConcJUnitFileInstrumentorLauncher.class.getName());
        System.out.println("\t\t[-h|--help] [-r|--run]");
        System.out.println("Arguments:");
        System.out.println("\t-h or --help  Show this help text");
        System.out.println("\t-r or --run   Run immediately, don't ask for user confirmation.");
    }

    static {
        String[] cps = System.getProperty("java.class.path").split("\\" + File.pathSeparator, -1);
        File found = null;
        for (String cp : cps) {
            try {
                JarFile jf;
                File f = new File(cp);
                if (!f.exists()) continue;
                if (f.isDirectory()) {
                    File cf = new File(f, ConcJUnitFileInstrumentorLauncher.class.getName().replace('.', File.separatorChar) + ".class");
                    if (!cf.exists() || !cf.isFile()) continue;
                    found = f;
                    break;
                }
                if (!f.isFile() || (jf = new JarFile(f)).getJarEntry(ConcJUnitFileInstrumentorLauncher.class.getName().replace('.', '/') + ".class") == null) continue;
                found = f;
                break;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (found != null) {
            concjunitrt = found.toString();
        }
        CONFIG_STRING = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<concutest><instrument rt=\"true\"><project root=\"%user.dir%\"/><source jar=\"%default.source.jar%\"/><cunit jar=\"" + concjunitrt + "\">" + "  <filter>edu/</filter>" + "  <filter>edu/rice/</filter>" + "  <filter>edu/rice/cs/</filter>" + "  <filter>edu/rice/cs/cunit/</filter>" + "  <filter>edu/rice/cs/cunit/classFile/</filter>" + "  <filter>edu/rice/cs/cunit/classFile/attributes/</filter>" + "  <filter>edu/rice/cs/cunit/classFile/attributes/visitors/</filter>" + "  <filter>edu/rice/cs/cunit/classFile/code/</filter>" + "  <filter>edu/rice/cs/cunit/classFile/code/instructions/</filter>" + "  <filter>edu/rice/cs/cunit/classFile/constantPool/</filter>" + "  <filter>edu/rice/cs/cunit/classFile/constantPool/visitors/</filter>" + "  <filter>edu/rice/cs/cunit/concJUnit/ThreadSets.class</filter>" + "  <filter>edu/rice/cs/cunit/instrumentors/</filter>" + "  <filter>edu/rice/cs/cunit/instrumentors/concJUnit/</filter>" + "  <filter>edu/rice/cs/cunit/instrumentors/record/</filter>" + "  <filter>edu/rice/cs/cunit/instrumentors/threadCheck/</filter>" + "  <filter>edu/rice/cs/cunit/instrumentors/util/</filter>" + "  <filter>edu/rice/cs/cunit/record/</filter>" + "  <filter>edu/rice/cs/cunit/record/graph/</filter>" + "  <filter>edu/rice/cs/cunit/record/syncPoints/</filter>" + "  <filter>edu/rice/cs/cunit/record/syncPoints/object/</filter>" + "  <filter>edu/rice/cs/cunit/record/syncPoints/sync/</filter>" + "  <filter>edu/rice/cs/cunit/record/syncPoints/thread/</filter>" + "  <filter>edu/rice/cs/cunit/threadCheck/</filter>" + "  <filter>edu/rice/cs/cunit/util/</filter>" + "  <filter>org/</filter>" + "  <filter>org/cliffc/</filter>" + "  <filter>org/cliffc/high_scale_lib/</filter>" + "</cunit>" + "<dest jar=\"%project.root%/rt.concjunit.jar\"/>" + "<instrumentor name=\"edu.rice.cs.cunit.instrumentors.concJUnit.ConcJUnitThreadStrategy\"/>" + "<sysinstrumentor name=\"\"/>" + "<backups create=\"true\"/>" + "<args line=\"\"/>" + "<output file=\"%project.root%/instr.concjunit.txt\" type=\"file\"/>" + "<input></input>" + "</instrument>" + "</concutest>";
    }

    public static class ConcJUnitFileInstrumentorLauncherView
    extends FileInstrumentorLauncher.FileInstrumentorLauncherView {
        public ConcJUnitFileInstrumentorLauncherView() {
            super(null, true);
            this.openConfig(new StringReader(CONFIG_STRING));
            this.executeFileInstrumentor(true);
            System.out.println("after execute");
            Runtime.getRuntime().halt(0);
        }
    }
}

