/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.concJUnit;

import edu.rice.cs.cunit.concJUnit.CreationContextError;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.cliffc.high_scale_lib.NonBlockingHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestThreadGroup
extends ThreadGroup {
    private volatile Throwable _uncaughtException = null;
    private volatile Thread _uncaughtThread = null;
    private final Object _event = new Object();
    private volatile boolean _notified = false;
    private static volatile TestThreadGroup _currentThreadGroup;

    public TestThreadGroup() {
        super(Thread.currentThread().getThreadGroup(), "Concutest-JUnit-" + (int)Math.random() * 10000 + "-" + System.currentTimeMillis());
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this._uncaughtException = e;
        this._uncaughtThread = t;
        this.notifyEvent();
    }

    public synchronized Throwable getUncaughtException() {
        return this._uncaughtException;
    }

    public synchronized Thread getUncaughtThread() {
        return this._uncaughtThread;
    }

    public synchronized Object getEvent() {
        return this._event;
    }

    public synchronized boolean hasBeenNotified() {
        return this._notified;
    }

    public synchronized void setNotified() {
        this._notified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEvent() throws InterruptedException {
        if (!this.hasBeenNotified()) {
            Object object = this._event;
            synchronized (object) {
                if (!this.hasBeenNotified()) {
                    this._event.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent() {
        this.setNotified();
        Object object = this._event;
        synchronized (object) {
            this._event.notify();
        }
    }

    public static Thread[] checkThreadsAlive(ThreadGroup tg, Thread t) {
        ArrayList<Thread> alive = new ArrayList<Thread>();
        int activeCount = tg.activeCount();
        Thread[] activeThreads = new Thread[Math.max(20, activeCount * 2)];
        int enumeratedCount = tg.enumerate(activeThreads, false);
        for (int i = 0; i < enumeratedCount; ++i) {
            Thread at = activeThreads[i];
            if (at == t || !at.isAlive() || at.isDaemon() || TestThreadGroup.shouldIgnoreThread(at) || !at.isAlive()) continue;
            alive.add(at);
            System.err.println("Thread " + at.getName() + " (" + at.getClass().getName() + ") is still alive");
        }
        return alive.toArray(new Thread[alive.size()]);
    }

    public static boolean shouldIgnoreThread(Thread at) {
        if (at.isDaemon()) {
            return true;
        }
        if (at.getName().equals("AWT-Shutdown")) {
            return true;
        }
        if (at.getName().startsWith("AWT-EventQueue-")) {
            return true;
        }
        if (at.getName().startsWith("RMI ")) {
            return true;
        }
        ThreadGroup tg = at.getThreadGroup();
        if (tg != null && tg.getName().equals("system")) {
            return true;
        }
        if (at.getName().equals("DestroyJavaVM")) {
            return true;
        }
        if (at.getName().equals("process reaper")) {
            return true;
        }
        if (at.getName().equals("Basic L&F File Loading Thread")) {
            return true;
        }
        if (at.getName().equals("Aqua L&F File Loading Thread")) {
            return true;
        }
        return at.getName().matches("pool-\\d*-thread-\\d*");
    }

    public static HashSet<Thread> collectThreads(Thread t, String fieldName) throws LuckyWarningsDisabledException {
        try {
            NonBlockingHashSet threadSet;
            HashSet<Thread> threads = new HashSet<Thread>();
            threads.add(t);
            Class<?> cThreadSets = Class.forName("edu.rice.cs.cunit.concJUnit.ThreadSets");
            Field fThreads = cThreadSets.getField(fieldName);
            Object oThreads = fThreads.get(null);
            NonBlockingHashMap sets = (NonBlockingHashMap)oThreads;
            if (sets != null && (threadSet = (NonBlockingHashSet)sets.get(t)) != null) {
                for (Thread ct : threadSet) {
                    threads.addAll(TestThreadGroup.collectThreads(ct, fieldName));
                }
            }
            return threads;
        }
        catch (ClassNotFoundException e) {
            System.err.println("Disabled \"lucky\" warnings: " + e);
            throw new LuckyWarningsDisabledException("Disabled \"lucky\" warnings", e);
        }
        catch (NoSuchFieldException e) {
            System.err.println("Disabled \"lucky\" warnings: " + e);
            throw new LuckyWarningsDisabledException("Disabled \"lucky\" warnings", e);
        }
        catch (IllegalAccessException e) {
            System.err.println("Disabled \"lucky\" warnings: " + e);
            throw new LuckyWarningsDisabledException("Disabled \"lucky\" warnings", e);
        }
    }

    public static void dumpThreads(String fieldName) {
        System.out.println(fieldName);
        try {
            Class<?> cThreadSets = Class.forName("edu.rice.cs.cunit.concJUnit.ThreadSets");
            Field fThreads = cThreadSets.getField(fieldName);
            Object oThreads = fThreads.get(null);
            NonBlockingHashMap sets = (NonBlockingHashMap)oThreads;
            System.out.println("\tsets=" + sets);
            if (sets != null) {
                for (Map.Entry e : sets.entrySet()) {
                    System.out.println("\t" + System.identityHashCode(e.getKey()) + " - " + e.getKey());
                    for (Thread t : (NonBlockingHashSet)e.getValue()) {
                        System.out.println("\t\t" + System.identityHashCode(t) + " - " + t);
                    }
                }
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    public static String getThreadStartStackTrace(Thread t) throws LuckyWarningsDisabledException {
        try {
            Class<?> cThreadSets = Class.forName("edu.rice.cs.cunit.concJUnit.ThreadSets");
            Field fThreads = cThreadSets.getField("threadStartStackTraces");
            Object oThreads = fThreads.get(null);
            NonBlockingHashMap sts = (NonBlockingHashMap)oThreads;
            if (sts != null) {
                return (String)sts.get(t);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new LuckyWarningsDisabledException("Disabled \"lucky\" warnings", e);
        }
        catch (NoSuchFieldException e) {
            throw new LuckyWarningsDisabledException("Disabled \"lucky\" warnings", e);
        }
        catch (IllegalAccessException e) {
            throw new LuckyWarningsDisabledException("Disabled \"lucky\" warnings", e);
        }
    }

    public static void extendStackTrace(Throwable t, Thread thread) throws LuckyWarningsDisabledException {
        String cc = TestThreadGroup.getThreadStartStackTrace(thread);
        StackTraceElement[] ccStes = CreationContextError.parseCreationContextString(cc);
        StackTraceElement[] tStes = t.getStackTrace();
        StackTraceElement[] extStes = new StackTraceElement[tStes.length + ccStes.length];
        System.arraycopy(tStes, 0, extStes, 0, tStes.length);
        System.arraycopy(ccStes, 0, extStes, tStes.length, ccStes.length);
        t.setStackTrace(extStes);
    }

    public static void setCurrentThreadGroup(TestThreadGroup tg) {
        _currentThreadGroup = tg;
    }

    public static TestThreadGroup getCurrentThreadGroup() {
        return _currentThreadGroup;
    }

    public static boolean isCheckThreadsEnabled() {
        String enabled = System.getProperty("edu.rice.cs.cunit.concJUnit.check.threads.enabled");
        return enabled == null || new Boolean(enabled) != false;
    }

    public static boolean isCheckJoinEnabled() {
        if (!TestThreadGroup.isCheckThreadsEnabled()) {
            return false;
        }
        String enabled = System.getProperty("edu.rice.cs.cunit.concJUnit.check.join.enabled");
        return enabled == null || new Boolean(enabled) != false;
    }

    public static boolean isCheckLuckyEnabled() {
        if (!TestThreadGroup.isCheckJoinEnabled()) {
            return false;
        }
        String enabled = System.getProperty("edu.rice.cs.cunit.concJUnit.check.lucky.enabled");
        return enabled == null || new Boolean(enabled) != false;
    }

    public static class DummyHandler {
        public void handle(Throwable t) {
            System.err.println(t);
        }
    }

    public static class AwtHandler {
        public void handle(Throwable t) {
            if (_currentThreadGroup != null) {
                _currentThreadGroup.uncaughtException(Thread.currentThread(), t);
            }
        }
    }

    public static class LuckyWarningsDisabledException
    extends Exception {
        public LuckyWarningsDisabledException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

