/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.util;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.attributes.AAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeInvisibleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.instrumentors.DoNotInstrument;
import edu.rice.cs.cunit.instrumentors.IInstrumentationStrategy;
import edu.rice.cs.cunit.instrumentors.util.IScannerStrategy;
import edu.rice.cs.cunit.util.Debug;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundStrategy
implements IInstrumentationStrategy,
IScannerStrategy {
    List<String> _parameters;
    ArrayList<IInstrumentationStrategy> _combined = new ArrayList();

    public CompoundStrategy(List<String> parameters) {
        this._parameters = parameters;
    }

    public CompoundStrategy(List<String> parameters, IInstrumentationStrategy[] contained) {
        this(parameters);
        for (IInstrumentationStrategy is : contained) {
            this._combined.add(is);
        }
    }

    public List<IInstrumentationStrategy> getCombined() {
        return this._combined;
    }

    @Override
    public void instrument(ClassFile cf) {
        String[] doNotInstrumentPatterns = new String[]{};
        AAttributeInfo attr = cf.getAttribute(RuntimeInvisibleAnnotationsAttributeInfo.getAttributeName());
        if (null != attr) {
            RuntimeInvisibleAnnotationsAttributeInfo ann = (RuntimeInvisibleAnnotationsAttributeInfo)attr;
            block0: for (AAnnotationsAttributeInfo.Annotation a : ann.getAnnotations()) {
                String typeString = ClassFileTools.getTypeString(a.getType(), "");
                if (!typeString.substring(0, typeString.length() - 1).equals(DoNotInstrument.class.getName())) continue;
                for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : a.getPairs()) {
                    if (!nvp.getName().toString().equals("instrumentors")) continue;
                    AAnnotationsAttributeInfo.Annotation.ConstantMemberValue c = nvp.getValue().execute(AAnnotationsAttributeInfo.Annotation.CheckConstantMemberVisitor.singleton(), null);
                    AUTFPoolInfo patternString = c.getConstValue().execute(CheckUTFVisitor.singleton(), null);
                    doNotInstrumentPatterns = patternString.toString().split(";");
                    break block0;
                }
                break;
            }
        }
        for (IInstrumentationStrategy itor : this._combined) {
            if (!ClassFileTools.classNameMatches(itor.getClass().getName(), doNotInstrumentPatterns)) {
                itor.instrument(cf);
                continue;
            }
            Debug.out.println("Class " + cf.getThisClassName() + " not instrumented with " + itor.getClass().getName() + " because it matched @DoNotInstrument instrumentors");
        }
    }

    public List<IScannerStrategy.IScanResult> getScanResults() {
        ArrayList<IScannerStrategy.IScanResult> results = new ArrayList<IScannerStrategy.IScanResult>();
        for (IInstrumentationStrategy is : this._combined) {
            if (!(is instanceof IScannerStrategy)) continue;
            results.addAll(((IScannerStrategy)is).getScanResults());
        }
        return results;
    }

    @Override
    public void done() {
        for (IInstrumentationStrategy itor : this._combined) {
            itor.done();
        }
    }
}

