/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.util;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ClassPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckClassVisitor;
import edu.rice.cs.cunit.instrumentors.util.IScannerStrategy;
import edu.rice.cs.cunit.util.Types;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanForObjectCtorStrategy
implements IScannerStrategy {
    public static final String CLASS_SIG_SEPARATOR_STRING = "::";
    ArrayList<Location> _locations = new ArrayList();

    public List<Location> getScanResults() {
        return this._locations;
    }

    @Override
    public void instrument(ClassFile cf) {
        for (MethodInfo mi : cf.getMethods()) {
            if ((mi.getAccessFlags() & 0x500) != 0) continue;
            CodeAttributeInfo codeAttr = mi.getCodeAttributeInfo();
            InstructionList il = new InstructionList(codeAttr.getCode());
            do {
                if (il.getOpcode() != -69 && il.getOpcode() != -35) continue;
                GenericInstruction gi = (GenericInstruction)il.getInstr();
                short index = Types.shortFromBytes(gi.getBytecode(), 1);
                ClassPoolInfo cpi = ((APoolInfo)cf.getConstantPool().get(index)).execute(CheckClassVisitor.singleton(), null);
                if (!cpi.getName().toString().equals("java/lang/Object")) continue;
                this._locations.add(new Location(cf.getThisClassName(), mi.getName().toString(), mi.getDescriptor().toString(), il.getPCFromIndex(il.getIndex())));
            } while (il.advanceIndex());
        }
    }

    @Override
    public void done() {
    }

    public static class Location
    implements IScannerStrategy.IScanResult {
        public final String className;
        public final String methodName;
        public final String methodDescriptor;
        public final int pc;

        public Location(String className, String methodName, String methodDescriptor, int pc) {
            this.className = className;
            this.methodName = methodName;
            this.methodDescriptor = methodDescriptor;
            this.pc = pc;
        }

        public String toString() {
            return this.className + ScanForObjectCtorStrategy.CLASS_SIG_SEPARATOR_STRING + this.methodName + this.methodDescriptor + ", PC=" + String.valueOf(this.pc);
        }

        public String getPropertyName() {
            return "Uses of new Object()";
        }
    }
}

