/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.config.OptionMap;
import edu.rice.cs.drjava.config.OptionMapLoader;
import edu.rice.cs.drjava.config.OptionParser;
import edu.rice.cs.util.swing.Utilities;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Configuration {
    protected volatile OptionMap map;
    protected volatile Exception _startupException;

    public Configuration(OptionMap om) {
        this.map = om;
        this._startupException = null;
    }

    public <T> T setSetting(final Option<T> op, final T value) {
        T ret = this.map.setOption(op, value);
        Utilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                op.notifyListeners(Configuration.this, value);
            }
        });
        return ret;
    }

    public <T> T getSetting(Option<T> op) {
        return this.map.getOption(op);
    }

    public <T> boolean isEditable(Option<T> op) {
        return true;
    }

    public <T> void addOptionListener(Option<T> op, OptionListener<T> l) {
        op.addListener(this, l);
    }

    public <T> void removeOptionListener(Option<T> op, OptionListener<T> l) {
        op.removeListener(this, l);
    }

    public void resetToDefaults() {
        OptionMapLoader.DEFAULT.loadInto(this.map);
    }

    public boolean hadStartupException() {
        return this._startupException != null;
    }

    public Exception getStartupException() {
        return this._startupException;
    }

    public void storeStartupException(Exception e) {
        this._startupException = e;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter(sw);
        for (OptionParser<?> key : this.map.keys()) {
            if (key.getDefault().equals(this.map.getOption(key))) continue;
            String tmpString = this.map.getString(key);
            tmpString = tmpString.replaceAll("\\\\", "\\\\\\\\");
            w.println(key.getName() + " = " + tmpString);
        }
        w.close();
        return sw.toString();
    }

    public OptionMap getOptionMap() {
        return this.map;
    }
}

