/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.DefaultOptionMap;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionMap;
import edu.rice.cs.drjava.config.OptionParseException;
import edu.rice.cs.drjava.config.OptionParser;
import edu.rice.cs.util.UnexpectedException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Properties;

public class OptionMapLoader
implements OptionConstants {
    private static final DefaultOptionMap DEFAULTS = new DefaultOptionMap();
    private static final Properties DEFAULT_STRINGS = new Properties();
    private static volatile Field[] fields = OptionConstants.class.getDeclaredFields();
    public static final OptionMapLoader DEFAULT;
    private final Properties prop;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionMapLoader(InputStream is) throws IOException {
        this(new Properties(DEFAULT_STRINGS));
        try {
            this.prop.load(is);
        }
        finally {
            is.close();
        }
    }

    private OptionMapLoader(Properties prop) {
        this.prop = prop;
    }

    public void loadInto(OptionMap map) {
        ArrayList<OptionParseException> es = new ArrayList<OptionParseException>();
        for (OptionParser<?> option : DEFAULTS.keys()) {
            try {
                String val = this.prop.getProperty(option.name);
                map.setString(option, val);
            }
            catch (OptionParseException ope) {
                es.add(ope);
                map.setString(option, OptionMapLoader.DEFAULT.prop.getProperty(option.name));
            }
        }
        if (es.size() > 0) {
            throw new OptionParseException(es.toArray(new OptionParseException[0]));
        }
    }

    static {
        for (int i = 0; i < fields.length; ++i) {
            Option option;
            Field field = fields[i];
            int mods = field.getModifiers();
            if (!Modifier.isStatic(mods) || !Modifier.isPublic(mods) || !Modifier.isFinal(mods)) continue;
            try {
                Object o = field.get(null);
                if (o == null || !(o instanceof Option)) continue;
                option = (Option)o;
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedException(e);
            }
            String sval = option.getDefaultString();
            DEFAULT_STRINGS.setProperty(option.name, sval);
            DEFAULTS.setString(option, sval);
        }
        DEFAULT = new OptionMapLoader(DEFAULT_STRINGS);
    }
}

