/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DJDocument;
import edu.rice.cs.drjava.model.Query;
import edu.rice.cs.drjava.model.compiler.JavacCompiler;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.HighlightStatus;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelControl;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.EventQueue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.ProgressMonitor;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

public abstract class AbstractDJDocument
extends SwingDocument
implements DJDocument,
OptionConstants {
    protected static final String delimiters = " \t\n\r{}()[].+-/*;:=!@#$%^&*~<>?,\"`'<>|";
    protected static final char newline = '\n';
    protected static final HashSet<String> _normEndings = AbstractDJDocument._makeNormEndings();
    protected final HashSet<String> _keywords = new HashSet<String>(JavacCompiler.JAVA_KEYWORDS);
    protected static final HashSet<String> _primTypes = AbstractDJDocument._makePrimTypes();
    protected volatile int _indent = 2;
    private static final int INIT_CACHE_SIZE = 65536;
    public static final int POS_THRESHOLD = 10000;
    public static final char[] CLOSING_BRACES = new char[]{'}', ')'};
    public final ReducedModelControl _reduced = new ReducedModelControl();
    protected volatile int _currentLocation = 0;
    private volatile HashMap<Query, Object> _queryCache;
    private volatile SortedMap<Integer, List<Query>> _offsetToQueries;
    private volatile Indenter _indenter;
    private volatile OptionListener<Integer> _listener1;
    private volatile OptionListener<Boolean> _listener2;
    private volatile int _numLinesChangedAfter = -1;

    protected AbstractDJDocument() {
        this(new Indenter(DrJava.getConfig().getSetting(INDENT_LEVEL)));
    }

    protected AbstractDJDocument(int indentLevel) {
        this(new Indenter(indentLevel));
    }

    protected AbstractDJDocument(Indenter indenter) {
        this._indenter = indenter;
        this._queryCache = null;
        this._offsetToQueries = null;
        this._initNewIndenter();
    }

    private Indenter getIndenter() {
        return this._indenter;
    }

    @Override
    public int getIndent() {
        return this._indent;
    }

    @Override
    public void setIndent(int indent) {
        DrJava.getConfig().setSetting(INDENT_LEVEL, indent);
        this._indent = indent;
    }

    protected void _removeIndenter() {
        DrJava.getConfig().removeOptionListener(INDENT_LEVEL, this._listener1);
        DrJava.getConfig().removeOptionListener(AUTO_CLOSE_COMMENTS, this._listener2);
    }

    private void _initNewIndenter() {
        final Indenter indenter = this._indenter;
        this._listener1 = new OptionListener<Integer>(){

            @Override
            public void optionChanged(OptionEvent<Integer> oce) {
                indenter.buildTree((Integer)oce.value);
            }
        };
        this._listener2 = new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oce) {
                indenter.buildTree(DrJava.getConfig().getSetting(OptionConstants.INDENT_LEVEL));
            }
        };
        DrJava.getConfig().addOptionListener(INDENT_LEVEL, this._listener1);
        DrJava.getConfig().addOptionListener(AUTO_CLOSE_COMMENTS, this._listener2);
    }

    protected static HashSet<String> _makeNormEndings() {
        HashSet<String> normEndings = new HashSet<String>();
        normEndings.add(";");
        normEndings.add("{");
        normEndings.add("}");
        normEndings.add("(");
        return normEndings;
    }

    public void setKeywords(Set<String> keywords) {
        this._keywords.clear();
        this._keywords.addAll(keywords);
    }

    protected static HashSet<String> _makePrimTypes() {
        String[] words = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "void"};
        HashSet<String> prims = new HashSet<String>();
        for (String w : words) {
            prims.add(w);
        }
        return prims;
    }

    @Override
    public ArrayList<HighlightStatus> getHighlightStatus(int start, int end) {
        assert (EventQueue.isDispatchThread());
        if (start == end) {
            return new ArrayList<HighlightStatus>(0);
        }
        this.setCurrentLocation(start);
        ArrayList<HighlightStatus> v = this._reduced.getHighlightStatus(start, end - start);
        for (int i = 0; i < v.size(); ++i) {
            HighlightStatus stat = v.get(i);
            if (stat.getState() != 0) continue;
            i = this._highlightKeywords(v, i);
        }
        return v;
    }

    private int _highlightKeywords(ArrayList<HighlightStatus> v, int i) {
        String text;
        HighlightStatus original = v.get(i);
        try {
            text = this.getText(original.getLocation(), original.getLength());
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        StringTokenizer tokenizer = new StringTokenizer(text, delimiters, true);
        int start = original.getLocation();
        int length = 0;
        v.remove(i);
        int index = i;
        int state = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            boolean process = false;
            if (this._isType(token)) {
                state = 6;
                process = true;
            } else if (this._keywords.contains(token)) {
                state = 4;
                process = true;
            } else if (AbstractDJDocument._isNum(token)) {
                state = 5;
                process = true;
            }
            if (process) {
                if (length != 0) {
                    HighlightStatus newStat = new HighlightStatus(start, length, original.getState());
                    v.add(index, newStat);
                    ++index;
                    start += length;
                    length = 0;
                }
                int keywordLength = token.length();
                v.add(index, new HighlightStatus(start, keywordLength, state));
                ++index;
                start += keywordLength;
                continue;
            }
            length += token.length();
        }
        if (length != 0) {
            HighlightStatus newStat = new HighlightStatus(start, length, original.getState());
            v.add(index, newStat);
            ++index;
            length = 0;
        }
        return index - 1;
    }

    static boolean _isNum(String x) {
        try {
            Double.parseDouble(x);
            return true;
        }
        catch (NumberFormatException e) {
            int radix = 10;
            int begin = 0;
            int end = x.length();
            int bits = 32;
            if (end - begin > 1) {
                char ch = x.charAt(end - 1);
                if (ch == 'l' || ch == 'L') {
                    --end;
                    bits = 64;
                }
                if (end - begin > 1 && x.charAt(0) == '0') {
                    radix = 8;
                    if (end - ++begin > 1 && ((ch = x.charAt(1)) == 'x' || ch == 'X')) {
                        ++begin;
                        radix = 16;
                    }
                }
            }
            try {
                BigInteger val = new BigInteger(x.substring(begin, end), radix);
                return val.bitLength() <= bits;
            }
            catch (NumberFormatException e2) {
                return false;
            }
        }
    }

    private boolean _isType(String x) {
        if (_primTypes.contains(x)) {
            return true;
        }
        try {
            return Character.isUpperCase(x.charAt(0));
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean hasOnlySpaces(String text) {
        return text.trim().length() == 0;
    }

    protected abstract void _styleChanged();

    private void _addCharToReducedModel(char curChar) {
        this._reduced.insertChar(curChar);
    }

    @Override
    public int getCurrentLocation() {
        return this._currentLocation;
    }

    @Override
    public void setCurrentLocation(int loc) {
        if (loc < 0) {
            throw new UnexpectedException("Illegal location " + loc);
        }
        if (loc > this.getLength()) {
            throw new UnexpectedException("Illegal location " + loc);
        }
        int dist = loc - this._currentLocation;
        this._currentLocation = loc;
        this._reduced.move(dist);
    }

    @Override
    public void move(int dist) {
        int newLocation = this._currentLocation + dist;
        if (0 > newLocation || newLocation > this.getLength()) {
            throw new IllegalArgumentException("AbstractDJDocument.move(" + dist + ") places the cursor at " + newLocation + " which is out of range");
        }
        this._reduced.move(dist);
        this._currentLocation = newLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int balanceBackward() {
        int origPos = this._currentLocation;
        try {
            if (this._currentLocation < 2) {
                int n = -1;
                return n;
            }
            char prevChar = this._getText(this._currentLocation - 1, 1).charAt(0);
            if (prevChar != '}' && prevChar != ')' && prevChar != ']') {
                int n = -1;
                return n;
            }
            int n = this._reduced.balanceBackward();
            return n;
        }
        finally {
            this.setCurrentLocation(origPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int balanceForward() {
        int origPos = this._currentLocation;
        try {
            if (this._currentLocation == 0) {
                int n = -1;
                return n;
            }
            char prevChar = this._getText(this._currentLocation - 1, 1).charAt(0);
            if (prevChar != '{' && prevChar != '(' && prevChar != '[') {
                int n = -1;
                return n;
            }
            int n = this._reduced.balanceForward();
            return n;
        }
        finally {
            this.setCurrentLocation(origPos);
        }
    }

    @Override
    public ReducedModelControl getReduced() {
        return this._reduced;
    }

    public ReducedModelState stateAtRelLocation(int dist) {
        return this._reduced.moveWalkerGetState(dist);
    }

    @Override
    public ReducedModelState getStateAtCurrent() {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        return this._reduced.getStateAtCurrent();
    }

    public void resetReducedModelLocation() {
        this._reduced.resetLocation();
    }

    @Override
    public int findPrevEnclosingBrace(int pos, char opening, char closing) throws BadLocationException {
        int i;
        Query.PrevEnclosingBrace key = new Query.PrevEnclosingBrace(pos, opening, closing);
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        if (pos >= this.getLength() || pos <= 0) {
            return -1;
        }
        char[] delims = new char[]{opening, closing};
        int reducedPos = pos;
        int braceBalance = 0;
        String text = this.getText(0, pos);
        int origPos = this._currentLocation;
        this.setCurrentLocation(pos);
        for (i = pos - 1; i >= 0; --i) {
            if (!AbstractDJDocument.match(text.charAt(i), delims)) continue;
            this.setCurrentLocation(i);
            reducedPos = i;
            if (this.isShadowed()) continue;
            if (text.charAt(i) == closing) {
                ++braceBalance;
                continue;
            }
            if (braceBalance == 0) break;
            --braceBalance;
        }
        this.setCurrentLocation(origPos);
        if (i == -1) {
            reducedPos = -1;
        }
        this._storeInCache(key, reducedPos, pos - 1);
        return reducedPos;
    }

    public boolean isShadowed() {
        return this._reduced.isShadowed();
    }

    public boolean isShadowed(int pos) {
        int origPos = this._currentLocation;
        this.setCurrentLocation(pos);
        boolean result = this.isShadowed();
        this.setCurrentLocation(origPos);
        return result;
    }

    @Override
    public int findNextEnclosingBrace(int pos, char opening, char closing) throws BadLocationException {
        int i;
        assert (EventQueue.isDispatchThread());
        Query.NextEnclosingBrace key = new Query.NextEnclosingBrace(pos, opening, closing);
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        if (pos >= this.getLength() - 1) {
            return -1;
        }
        char[] delims = new char[]{opening, closing};
        int reducedPos = pos;
        int braceBalance = 0;
        String text = this.getText();
        int origPos = this._currentLocation;
        this.setCurrentLocation(pos);
        for (i = pos + 1; i < text.length(); ++i) {
            if (!AbstractDJDocument.match(text.charAt(i), delims)) continue;
            this.setCurrentLocation(i);
            reducedPos = i;
            if (this.isShadowed()) continue;
            if (text.charAt(i) == opening) {
                ++braceBalance;
                continue;
            }
            if (braceBalance == 0) break;
            --braceBalance;
        }
        this.setCurrentLocation(origPos);
        if (i == text.length()) {
            reducedPos = -1;
        }
        this._storeInCache(key, reducedPos, reducedPos);
        return reducedPos;
    }

    @Override
    public int findPrevDelimiter(int pos, char[] delims) throws BadLocationException {
        return this.findPrevDelimiter(pos, delims, true);
    }

    @Override
    public int findPrevDelimiter(int pos, char[] delims, boolean skipBracePhrases) throws BadLocationException {
        int i;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        Query.PrevDelimiter key = new Query.PrevDelimiter(pos, delims, skipBracePhrases);
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int reducedPos = pos;
        int lineStartPos = this._getLineStartPos(pos);
        if (lineStartPos < 0) {
            lineStartPos = 0;
        }
        if (lineStartPos >= pos) {
            i = lineStartPos - 1;
        } else {
            assert (lineStartPos < pos);
            String line = this.getText(lineStartPos, pos - lineStartPos);
            int origPos = this._currentLocation;
            for (i = pos - 1; i >= lineStartPos; --i) {
                int irel = i - lineStartPos;
                this.setCurrentLocation(i);
                if (this.isShadowed() || AbstractDJDocument.isCommentOpen(line, irel)) continue;
                char ch = line.charAt(irel);
                if (AbstractDJDocument.match(ch, delims)) {
                    reducedPos = i;
                    break;
                }
                if (!skipBracePhrases || !AbstractDJDocument.match(ch, CLOSING_BRACES)) continue;
                this.setCurrentLocation(i + 1);
                int dist = this.balanceBackward();
                if (dist == -1) {
                    i = -1;
                    break;
                }
                assert (dist > 0);
                this.setCurrentLocation(i + 1 - dist);
                i = this._currentLocation;
            }
            this.setCurrentLocation(origPos);
        }
        if (i < lineStartPos) {
            reducedPos = i <= 0 ? -1 : this.findPrevDelimiter(i, delims, skipBracePhrases);
        }
        this._storeInCache(key, reducedPos, pos - 1);
        return reducedPos;
    }

    private static boolean match(char c, char[] delims) {
        for (char d : delims) {
            if (c != d) continue;
            return true;
        }
        return false;
    }

    public boolean findCharInStmtBeforePos(char findChar, int position) {
        boolean found;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        if (position == -1) {
            String msg = "Argument endChar to QuestionExistsCharInStmt must be a char that exists on the current line.";
            throw new UnexpectedException(new IllegalArgumentException(msg));
        }
        char[] findCharDelims = new char[]{findChar, ';', '{', '}'};
        try {
            int prevFindChar = this.findPrevDelimiter(position, findCharDelims, false);
            if (prevFindChar == -1 || prevFindChar < 0) {
                return false;
            }
            String foundString = this.getText(prevFindChar, 1);
            char foundChar = foundString.charAt(0);
            found = foundChar == findChar;
        }
        catch (Throwable t) {
            throw new UnexpectedException(t);
        }
        return found;
    }

    public int _findPrevCharPos(int pos, char[] whitespace) throws BadLocationException {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        Query.PrevCharPos key = new Query.PrevCharPos(pos, whitespace);
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int reducedPos = pos;
        int i = pos - 1;
        String text = this.getText(0, pos);
        int oldPos = this._currentLocation;
        this.setCurrentLocation(reducedPos);
        while (i >= 0) {
            if (AbstractDJDocument.match(text.charAt(i), whitespace)) {
                --i;
                continue;
            }
            this.setCurrentLocation(i);
            reducedPos = i;
            if (this._reduced.getStateAtCurrent().equals(ReducedModelStates.INSIDE_LINE_COMMENT) || this._reduced.getStateAtCurrent().equals(ReducedModelStates.INSIDE_BLOCK_COMMENT)) {
                --i;
                continue;
            }
            if (i <= 0 || !AbstractDJDocument._isStartOfComment(text, i - 1)) break;
            i -= 2;
        }
        this.setCurrentLocation(oldPos);
        int result = reducedPos;
        if (i < 0) {
            result = -1;
        }
        this._storeInCache(key, result, pos - 1);
        return result;
    }

    protected Object _checkCache(Query key) {
        if (this._queryCache == null) {
            return null;
        }
        return this._queryCache.get(key);
    }

    protected void _storeInCache(Query query, Object answer, int offset) {
        if (this._queryCache == null) {
            return;
        }
        this._queryCache.put(query, answer);
        this._addToOffsetsToQueries(query, offset);
    }

    protected void _clearCache(int offset) {
        Integer[] deadOffsets;
        if (this._queryCache == null) {
            return;
        }
        if (offset <= 0) {
            this._queryCache.clear();
            this._offsetToQueries.clear();
            return;
        }
        Integer[] arr$ = deadOffsets = this._offsetToQueries.tailMap(offset).keySet().toArray(new Integer[0]);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            for (Query query : (List)this._offsetToQueries.get(i)) {
                this._queryCache.remove(query);
            }
            this._offsetToQueries.remove(i);
        }
    }

    private void _addToOffsetsToQueries(Query query, int offset) {
        LinkedList<Query> selectedQueries = (LinkedList<Query>)this._offsetToQueries.get(offset);
        if (selectedQueries == null) {
            selectedQueries = new LinkedList<Query>();
            this._offsetToQueries.put(offset, selectedQueries);
        }
        selectedQueries.add(query);
    }

    @Override
    public void indentLines(int selStart, int selEnd) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        try {
            this.indentLines(selStart, selEnd, Indenter.IndentReason.OTHER, null);
        }
        catch (OperationCanceledException oce) {
            throw new UnexpectedException(oce);
        }
    }

    @Override
    public void indentLines(int selStart, int selEnd, Indenter.IndentReason reason, ProgressMonitor pm) throws OperationCanceledException {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        try {
            if (selStart == selEnd) {
                Position oldPosition = this.createUnwrappedPosition(this._currentLocation);
                int lineStart = this._getLineStartPos(selStart);
                if (lineStart < 0) {
                    lineStart = 0;
                }
                this.setCurrentLocation(lineStart);
                if (this._indentLine(reason)) {
                    this.setCurrentLocation(oldPosition.getOffset());
                    if (this.onlySpacesBeforeCurrent()) {
                        this.move(this._getWhiteSpace());
                    }
                }
            } else {
                this._indentBlock(selStart, selEnd, reason, pm);
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        this.endLastCompoundEdit();
    }

    private void _indentBlock(int start, int end, Indenter.IndentReason reason, ProgressMonitor pm) throws OperationCanceledException, BadLocationException {
        this._queryCache = new HashMap(65536);
        this._offsetToQueries = new TreeMap<Integer, List<Query>>();
        Position endPos = this.createUnwrappedPosition(end);
        for (int walker = start; walker < endPos.getOffset(); walker += this._reduced.getDistToNextNewline() + 1) {
            this.setCurrentLocation(walker);
            Position walkerPos = this.createUnwrappedPosition(walker);
            this._indentLine(reason);
            this.setCurrentLocation(walkerPos.getOffset());
            walker = walkerPos.getOffset();
            if (pm == null) continue;
            pm.setProgress(walker);
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        this._queryCache = null;
        this._offsetToQueries = null;
    }

    public boolean _indentLine(Indenter.IndentReason reason) {
        return this.getIndenter().indent(this, reason);
    }

    @Override
    public int getIntelligentBeginLinePos(int currPos) throws BadLocationException {
        int firstRealChar;
        int i;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        int firstChar = this._getLineStartPos(currPos);
        String prefix = this.getText(firstChar, currPos - firstChar);
        int len = prefix.length();
        for (i = 0; i < len && Character.isWhitespace(prefix.charAt(i)); ++i) {
        }
        if (i < len && (firstRealChar = firstChar + i) < currPos) {
            return firstRealChar;
        }
        return firstChar;
    }

    @Override
    public int _getIndentOfCurrStmt(int pos) {
        char[] delims = new char[]{';', '{', '}'};
        char[] whitespace = new char[]{' ', '\t', '\n', ','};
        return this._getIndentOfCurrStmt(pos, delims, whitespace);
    }

    @Override
    public int _getIndentOfCurrStmt(int pos, char[] delims) {
        char[] whitespace = new char[]{' ', '\t', '\n', ','};
        return this._getIndentOfCurrStmt(pos, delims, whitespace);
    }

    @Override
    public int _getIndentOfCurrStmt(int pos, char[] delims, char[] whitespace) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        try {
            int nextNonWSChar;
            int lineStart = this._getLineStartPos(pos);
            Query.IndentOfCurrStmt key = new Query.IndentOfCurrStmt(lineStart, delims, whitespace);
            Integer cached = (Integer)this._checkCache(key);
            if (cached != null) {
                return cached;
            }
            boolean reachedStart = false;
            int prevDelim = this.findPrevDelimiter(lineStart, delims, true);
            if (prevDelim == -1) {
                reachedStart = true;
            }
            if ((nextNonWSChar = reachedStart ? this.getFirstNonWSCharPos(0) : this.getFirstNonWSCharPos(prevDelim + 1, whitespace, false)) == -1) {
                nextNonWSChar = this.getLength();
            }
            int newLineStart = this._getLineStartPos(nextNonWSChar);
            int firstNonWS = this._getLineFirstCharPos(newLineStart);
            int wSPrefix = firstNonWS - newLineStart;
            this._storeInCache(key, wSPrefix, Math.max(pos - 1, firstNonWS));
            return wSPrefix;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public int findCharOnLine(int pos, char findChar) {
        int matchIndex;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        Query.CharOnLine key = new Query.CharOnLine(pos, findChar);
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        try {
            int oldPos = this._currentLocation;
            int lineStart = this._getLineStartPos(pos);
            int lineEnd = this._getLineEndPos(pos);
            String lineText = this.getText(lineStart, lineEnd - lineStart);
            int i = lineText.indexOf(findChar, 0);
            matchIndex = i + lineStart;
            while (i != -1) {
                this.setCurrentLocation(matchIndex);
                if (this._reduced.getStateAtCurrent().equals(ReducedModelStates.FREE)) break;
                i = lineText.indexOf(findChar, i + 1);
            }
            this.setCurrentLocation(oldPos);
            if (i == -1) {
                matchIndex = -1;
            }
            this._storeInCache(key, matchIndex, Math.max(pos - 1, matchIndex));
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        return matchIndex;
    }

    @Override
    public int _getLineStartPos(int pos) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        if (pos < 0 || pos > this.getLength()) {
            return -1;
        }
        Query.LineStartPos key = new Query.LineStartPos(pos);
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int oldPos = this._currentLocation;
        this.setCurrentLocation(pos);
        int dist = this._reduced.getDistToStart(0);
        this.setCurrentLocation(oldPos);
        int newPos = 0;
        if (dist >= 0) {
            newPos = pos - dist;
        }
        this._storeInCache(key, newPos, pos - 1);
        return newPos;
    }

    @Override
    public int _getLineEndPos(int pos) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        if (pos < 0 || pos > this.getLength()) {
            return -1;
        }
        Query.LineEndPos key = new Query.LineEndPos(pos);
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int oldPos = this._currentLocation;
        this.setCurrentLocation(pos);
        int dist = this._reduced.getDistToNextNewline();
        this.setCurrentLocation(oldPos);
        int newPos = pos + dist;
        assert (newPos == this.getLength() || this._getText(newPos, 1).charAt(0) == '\n');
        this._storeInCache(key, newPos, newPos);
        return newPos;
    }

    @Override
    public int _getLineFirstCharPos(int pos) {
        int endLinePos;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        Query.LineFirstCharPos key = new Query.LineFirstCharPos(pos);
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int startLinePos = this._getLineStartPos(pos);
        int nonWSPos = endLinePos = this._getLineEndPos(pos);
        String text = this._getText(startLinePos, endLinePos - startLinePos);
        for (int walker = 0; walker < text.length(); ++walker) {
            if (text.charAt(walker) == ' ' || text.charAt(walker) == '\t') {
                continue;
            }
            nonWSPos = startLinePos + walker;
            break;
        }
        this._storeInCache(key, nonWSPos, Math.max(pos - 1, nonWSPos));
        return nonWSPos;
    }

    @Override
    public int getFirstNonWSCharPos(int pos) throws BadLocationException {
        char[] whitespace = new char[]{' ', '\t', '\n'};
        return this.getFirstNonWSCharPos(pos, whitespace, false);
    }

    @Override
    public int getFirstNonWSCharPos(int pos, boolean acceptComments) throws BadLocationException {
        char[] whitespace = new char[]{' ', '\t', '\n'};
        return this.getFirstNonWSCharPos(pos, whitespace, acceptComments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFirstNonWSCharPos(int pos, char[] whitespace, boolean acceptComments) throws BadLocationException {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        Query.FirstNonWSCharPos key = new Query.FirstNonWSCharPos(pos, whitespace, acceptComments);
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int docLen = this.getLength();
        int origPos = this._currentLocation;
        int endPos = this._getLineEndPos(pos);
        String line = this.getText(pos, endPos - pos);
        this.setCurrentLocation(pos);
        try {
            int i = pos;
            int reducedPos = pos;
            while (i < endPos) {
                if (AbstractDJDocument.match(line.charAt(i - pos), whitespace)) {
                    ++i;
                    continue;
                }
                this.setCurrentLocation(i);
                reducedPos = i;
                if (!acceptComments && (this._reduced.getStateAtCurrent().equals(ReducedModelStates.INSIDE_LINE_COMMENT) || this._reduced.getStateAtCurrent().equals(ReducedModelStates.INSIDE_BLOCK_COMMENT))) {
                    ++i;
                    continue;
                }
                if (!acceptComments && AbstractDJDocument._isStartOfComment(line, i - pos)) {
                    i += 2;
                    continue;
                }
                this._storeInCache(key, reducedPos, reducedPos);
                int n = reducedPos;
                return n;
            }
            if (endPos + 1 >= docLen) {
                this._storeInCache(key, -1, Integer.MAX_VALUE);
                int n = -1;
                return n;
            }
        }
        finally {
            this.setCurrentLocation(origPos);
        }
        return this.getFirstNonWSCharPos(endPos + 1, whitespace, acceptComments);
    }

    public int _findPrevNonWSCharPos(int pos) throws BadLocationException {
        char[] whitespace = new char[]{' ', '\t', '\n'};
        return this._findPrevCharPos(pos, whitespace);
    }

    protected static boolean _isStartOfComment(String text, int pos) {
        char currChar = text.charAt(pos);
        if (currChar == '/') {
            try {
                char afterCurrChar = text.charAt(pos + 1);
                if (afterCurrChar == '/' || afterCurrChar == '*') {
                    return true;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean _inParenPhrase(int pos) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        Query.PosInParenPhrase key = new Query.PosInParenPhrase(pos);
        Boolean cached = (Boolean)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int oldPos = this._currentLocation;
        this.setCurrentLocation(pos);
        boolean _inParenPhrase = this._inParenPhrase();
        this.setCurrentLocation(oldPos);
        this._storeInCache(key, _inParenPhrase, pos - 1);
        return _inParenPhrase;
    }

    public BraceInfo _getLineEnclosingBrace() {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        int lineStart = this._getLineStartPos(this._currentLocation);
        if (lineStart < 0) {
            return BraceInfo.NULL;
        }
        int keyPos = lineStart;
        Query.LineEnclosingBrace key = new Query.LineEnclosingBrace(keyPos);
        BraceInfo cached = (BraceInfo)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        BraceInfo b = this._reduced._getLineEnclosingBrace();
        this._storeInCache(key, b, keyPos - 1);
        return b;
    }

    public BraceInfo _getEnclosingBrace() {
        int pos = this._currentLocation;
        Query.EnclosingBrace key = new Query.EnclosingBrace(pos);
        BraceInfo cached = (BraceInfo)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        BraceInfo b = this._reduced._getEnclosingBrace();
        this._storeInCache(key, b, pos - 1);
        return b;
    }

    private boolean _inParenPhrase() {
        BraceInfo info = this._reduced._getEnclosingBrace();
        return info.braceType().equals("(");
    }

    public boolean _inBlockComment(int pos) {
        int here = this._currentLocation;
        int distToStart = here - this._getLineStartPos(here);
        this._reduced.resetLocation();
        ReducedModelState state = this.stateAtRelLocation(-distToStart);
        return state.equals(ReducedModelStates.INSIDE_BLOCK_COMMENT);
    }

    protected boolean notInBlock(int pos) {
        Query.PosNotInBlock key = new Query.PosNotInBlock(pos);
        Boolean cached = (Boolean)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int oldPos = this._currentLocation;
        this.setCurrentLocation(pos);
        BraceInfo info = this._reduced._getEnclosingBrace();
        boolean notInParenPhrase = info.braceType().equals("");
        this.setCurrentLocation(oldPos);
        this._storeInCache(key, notInParenPhrase, pos - 1);
        return notInParenPhrase;
    }

    private boolean onlySpacesBeforeCurrent() throws BadLocationException {
        int pos;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        int lineStart = this._getLineStartPos(this._currentLocation);
        if (lineStart < 0) {
            lineStart = 0;
        }
        int prefixSize = this._currentLocation - lineStart;
        String prefix = this.getText(lineStart, prefixSize);
        for (pos = prefixSize - 1; pos >= 0 && prefix.charAt(pos) == ' '; --pos) {
        }
        return pos < 0;
    }

    private int _getWhiteSpace() throws BadLocationException {
        int i;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        int lineEnd = this._getLineEndPos(this._currentLocation);
        int lineLen = lineEnd - this._currentLocation;
        String line = this.getText(this._currentLocation, lineLen);
        for (i = 0; i < lineLen && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private int _getWhiteSpacePrefix() throws BadLocationException {
        int pos;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        int lineStart = this._getLineStartPos(this._currentLocation);
        if (lineStart < 0) {
            lineStart = 0;
        }
        int prefixSize = this._currentLocation - lineStart;
        String prefix = this.getText(lineStart, prefixSize);
        for (pos = prefixSize - 1; pos >= 0 && prefix.charAt(pos) == ' '; --pos) {
        }
        return pos < 0 ? prefixSize : 0;
    }

    public void setTab(int tab, int pos) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        try {
            int startPos = this._getLineStartPos(pos);
            int firstNonWSPos = this._getLineFirstCharPos(pos);
            int len = firstNonWSPos - startPos;
            if (len != tab) {
                int diff = tab - len;
                if (diff > 0) {
                    this.insertString(firstNonWSPos, StringOps.getBlankString(diff), null);
                } else {
                    this.remove(firstNonWSPos + diff, -diff);
                }
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    public void setTab(String tab, int pos) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        try {
            int startPos = this._getLineStartPos(pos);
            int firstNonWSPos = this._getLineFirstCharPos(pos);
            int len = firstNonWSPos - startPos;
            this.remove(startPos, len);
            this.insertString(startPos, tab, null);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        super.insertUpdate(chng, attr);
        try {
            int offset = chng.getOffset();
            int length = chng.getLength();
            String str = this.getText(offset, length);
            if (length > 0) {
                this._clearCache(offset);
            }
            Runnable doCommand = length == 1 ? new CharInsertCommand(offset, str.charAt(0)) : new InsertCommand(offset, str);
            UninsertCommand undoCommand = new UninsertCommand(offset, length, str);
            this.addUndoRedo(chng, undoCommand, doCommand);
            doCommand.run();
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        try {
            int offset = chng.getOffset();
            int length = chng.getLength();
            String removedText = this.getText(offset, length);
            super.removeUpdate(chng);
            if (length > 0) {
                this._clearCache(offset);
            }
            RemoveCommand doCommand = new RemoveCommand(offset, length, removedText);
            UnremoveCommand undoCommand = new UnremoveCommand(offset, removedText);
            this.addUndoRedo(chng, undoCommand, doCommand);
            doCommand.run();
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    public byte[] getBytes() {
        return this.getText().getBytes();
    }

    @Override
    public void clear() {
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    private static boolean isCommentOpen(String text, int pos) {
        int len = text.length();
        if (len < 2) {
            return false;
        }
        if (pos == len - 1) {
            return AbstractDJDocument.isCommentStart(text, pos - 1);
        }
        if (pos == 0) {
            return AbstractDJDocument.isCommentStart(text, 0);
        }
        return AbstractDJDocument.isCommentStart(text, pos - 1) || AbstractDJDocument.isCommentStart(text, pos);
    }

    private static boolean isCommentStart(String text, int pos) {
        char ch1 = text.charAt(pos);
        char ch2 = text.charAt(pos + 1);
        return ch1 == '/' && (ch2 == '/' || ch2 == '*');
    }

    protected abstract int startCompoundEdit();

    protected abstract void endCompoundEdit(int var1);

    protected abstract void endLastCompoundEdit();

    protected abstract void addUndoRedo(AbstractDocument.DefaultDocumentEvent var1, Runnable var2, Runnable var3);

    private void _numLinesChanged(int offset) {
        if (this._numLinesChangedAfter < 0) {
            this._numLinesChangedAfter = offset;
            return;
        }
        this._numLinesChangedAfter = Math.min(this._numLinesChangedAfter, offset);
    }

    public int getAndResetNumLinesChangedAfter() {
        int result = this._numLinesChangedAfter;
        this._numLinesChangedAfter = -1;
        return result;
    }

    protected class UninsertCommand
    extends RemoveCommand {
        public UninsertCommand(int offset, int length, String text) {
            super(offset, length, text);
        }

        @Override
        public void run() {
            super.run();
        }
    }

    protected class RemoveCommand
    implements Runnable {
        protected final int _offset;
        protected final int _length;
        protected final String _removedText;

        public RemoveCommand(int offset, int length, String removedText) {
            this._offset = offset;
            this._length = length;
            this._removedText = removedText;
        }

        @Override
        public void run() {
            AbstractDJDocument.this.setCurrentLocation(this._offset);
            if (this._removedText.indexOf(10) >= 0) {
                AbstractDJDocument.this._numLinesChanged(this._offset);
            }
            AbstractDJDocument.this._reduced.delete(this._length);
            AbstractDJDocument.this._styleChanged();
        }
    }

    protected class CharInsertCommand
    implements Runnable {
        protected final int _offset;
        protected final char _ch;

        public CharInsertCommand(int offset, char ch) {
            this._offset = offset;
            this._ch = ch;
        }

        @Override
        public void run() {
            AbstractDJDocument.this._reduced.move(this._offset - AbstractDJDocument.this._currentLocation);
            if (this._ch == '\n') {
                AbstractDJDocument.this._numLinesChanged(this._offset);
            }
            AbstractDJDocument.this._addCharToReducedModel(this._ch);
            AbstractDJDocument.this._currentLocation = this._offset + 1;
            AbstractDJDocument.this._styleChanged();
        }
    }

    protected class UnremoveCommand
    extends InsertCommand {
        public UnremoveCommand(int offset, String text) {
            super(offset, text);
        }

        @Override
        public void run() {
            super.run();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractDJDocument.this.setCurrentLocation(UnremoveCommand.this._offset);
                }
            });
        }
    }

    protected class InsertCommand
    implements Runnable {
        protected final int _offset;
        protected final String _text;

        public InsertCommand(int offset, String text) {
            this._offset = offset;
            this._text = text;
        }

        @Override
        public void run() {
            AbstractDJDocument.this._reduced.move(this._offset - AbstractDJDocument.this._currentLocation);
            int len = this._text.length();
            int newLineOffset = this._text.indexOf(10);
            if (newLineOffset >= 0) {
                AbstractDJDocument.this._numLinesChanged(this._offset + newLineOffset);
            }
            for (int i = 0; i < len; ++i) {
                AbstractDJDocument.this._addCharToReducedModel(this._text.charAt(i));
            }
            AbstractDJDocument.this._currentLocation = this._offset + len;
            AbstractDJDocument.this._styleChanged();
        }
    }
}

