/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.compiler.CompilerOptions;
import edu.rice.cs.drjava.model.compiler.Javac160FilteringCompiler;
import edu.rice.cs.nextgen2.compiler.main.JavaCompiler;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Options;
import edu.rice.cs.nextgen2.compiler.util.Position;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.ArgumentTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NextGenCompiler
extends Javac160FilteringCompiler {
    private static final PrintWriter NULL_WRITER = new PrintWriter(new Writer(){

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    });

    public NextGenCompiler(JavaVersion.FullVersion version, String location, List<? extends File> defaultBootClassPath) {
        super(version, location, defaultBootClassPath);
    }

    @Override
    public String getName() {
        return "Nextgen " + this._version.versionString();
    }

    @Override
    public List<File> additionalBootClassPathForInteractions() {
        System.out.println("NextGenCompiler default boot classpath: " + (this._defaultBootClassPath == null ? "null" : IOUtil.pathToString(this._defaultBootClassPath)));
        System.out.println("NextGenCompiler.additionalBootClassPathForInteractions: " + new File(this._location));
        return Arrays.asList(new File(this._location));
    }

    @Override
    public String transformCommands(String interactionsString) {
        if (interactionsString.startsWith("applet ")) {
            throw new RuntimeException("Applets not supported by Nextgen.");
        }
        if (interactionsString.startsWith("run ") || interactionsString.startsWith("nextgen ") || interactionsString.startsWith("java ")) {
            interactionsString = NextGenCompiler._transformNextgenCommand(interactionsString);
        }
        return interactionsString;
    }

    protected static String _transformNextgenCommand(String s) {
        String command = "edu.rice.cs.nextgen2.classloader.Runner.main(new String[]'{'\"{0}\"{1}'}');";
        if (s.endsWith(";")) {
            s = NextGenCompiler._deleteSemiColon(s);
        }
        List<String> args = ArgumentTokenizer.tokenize(s, true);
        String classNameWithQuotes = args.get(1);
        String className = classNameWithQuotes.substring(1, classNameWithQuotes.length() - 1);
        StringBuilder argsString = new StringBuilder();
        for (int i = 2; i < args.size(); ++i) {
            argsString.append(",");
            argsString.append(args.get(i));
        }
        return MessageFormat.format("edu.rice.cs.nextgen2.classloader.Runner.main(new String[]'{'\"{0}\"{1}'}');", className, argsString.toString());
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName("java.lang.Enum");
            Class.forName("edu.rice.cs.nextgen2.classloader.Runner");
            Class.forName("edu.rice.cs.nextgen2.compiler.Main");
            Class.forName("edu.rice.cs.nextgen2.compiler.main.JavaCompiler");
            return true;
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    @Override
    public Set<String> getSourceFileExtensions() {
        HashSet<String> extensions = new HashSet<String>();
        extensions.add(this.getSuggestedFileExtension());
        return extensions;
    }

    @Override
    public String getSuggestedFileExtension() {
        return ".java";
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".java");
            }

            public String getDescription() {
                return "Nextgen source files (*.java)";
            }
        };
    }

    @Override
    public String getOpenAllFilesInFolderExtension() {
        return ".java";
    }

    @Override
    public boolean supportsLanguageLevels() {
        return false;
    }

    @Override
    public List<? extends DJError> compile(List<? extends File> files, List<? extends File> classPath, List<? extends File> sourcePath, File destination, List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        DebugUtil.debug.logStart("compile()");
        DebugUtil.debug.logValues(new String[]{"this", "files", "classPath", "sourcePath", "destination", "bootClassPath", "sourceVersion", "showWarnings"}, this, files, classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        Context context = this._createContext(classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        OurLog log = new OurLog(context);
        JavaCompiler compiler = this._makeCompiler(context);
        edu.rice.cs.nextgen2.compiler.util.List filesToCompile = this._emptyStringList();
        for (File file : files) {
            filesToCompile = filesToCompile.prepend((Object)file.getAbsolutePath());
        }
        try {
            compiler.compile(filesToCompile);
        }
        catch (Throwable t) {
            LinkedList<DJError> linkedList = log.getErrors();
            linkedList.addFirst(new DJError("Compile exception: " + t, false));
            DebugUtil.error.log(t);
            DebugUtil.debug.logEnd("compile() (caught an exception)");
            return linkedList;
        }
        DebugUtil.debug.logEnd("compile()");
        return log.getErrors();
    }

    private Context _createContext(List<? extends File> classPath, List<? extends File> sourcePath, File destination, List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        if (bootClassPath == null) {
            bootClassPath = this._defaultBootClassPath;
        }
        Context context = new Context();
        Options options = Options.instance((Context)context);
        options.putAll(CompilerOptions.getOptions(showWarnings));
        options.put((Object)"-g", (Object)"");
        if (classPath != null) {
            options.put((Object)"-classpath", (Object)IOUtil.pathToString(classPath));
        }
        if (sourcePath != null) {
            options.put((Object)"-sourcepath", (Object)IOUtil.pathToString(sourcePath));
        }
        if (destination != null) {
            options.put((Object)"-d", (Object)destination.getPath());
        }
        if (bootClassPath != null) {
            System.out.println("bootClassPath: " + IOUtil.pathToString(bootClassPath));
            options.put((Object)"-bootclasspath", (Object)IOUtil.pathToString(bootClassPath));
        }
        if (sourceVersion != null) {
            options.put((Object)"-source", (Object)sourceVersion);
        }
        if (!showWarnings) {
            options.put((Object)"-nowarn", (Object)"");
        }
        if (sourceVersion != null) {
            options.put((Object)"-target", (Object)sourceVersion);
        } else {
            options.put((Object)"-target", (Object)"1.5");
        }
        return context;
    }

    protected JavaCompiler _makeCompiler(Context context) {
        return JavaCompiler.instance((Context)context);
    }

    private edu.rice.cs.nextgen2.compiler.util.List<String> _emptyStringList() {
        return edu.rice.cs.nextgen2.compiler.util.List.make();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OurLog
    extends Log {
        private LinkedList<DJError> _errors = new LinkedList();
        private String _sourceName = "";

        public OurLog(Context context) {
            super(context, NULL_WRITER, NULL_WRITER, NULL_WRITER);
        }

        public void warning(int pos, String key, Object ... args) {
            super.warning(pos, key, args);
            String msg = OurLog.getText((String)("compiler.warn." + key), (Object[])args);
            if (this.currentSource() != null) {
                this._errors.addLast(new DJError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, true));
            } else {
                this._errors.addLast(new DJError(msg, true));
            }
        }

        public void mandatoryWarning(int pos, String key, Object ... args) {
            super.warning(pos, key, args);
            String msg = OurLog.getText((String)("compiler.warn." + key), (Object[])args);
            if (this.currentSource() != null) {
                this._errors.addLast(new DJError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, true));
            } else {
                this._errors.addLast(new DJError(msg, true));
            }
        }

        public void error(int pos, String key, Object ... args) {
            super.error(pos, key, args);
            String msg = OurLog.getText((String)("compiler.err." + key), (Object[])args);
            if (this.currentSource() != null) {
                this._errors.addLast(new DJError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, false));
            } else {
                this._errors.addLast(new DJError(msg, false));
            }
        }

        public void note(String key, Object ... args) {
            super.note(key, args);
        }

        public void mandatoryNote(String key, Object ... args) {
            super.note(key, args);
        }

        public LinkedList<DJError> getErrors() {
            return this._errors;
        }
    }
}

