/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler.descriptors;

import edu.rice.cs.drjava.model.JDKDescriptor;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.FileOps;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MintDescriptor
extends JDKDescriptor {
    @Override
    public String getName() {
        return "Mint";
    }

    @Override
    public Set<String> getToolsPackages() {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, "com.sun.codemodel", "com.sun.istack.internal.tools", "com.sun.istack.internal.ws", "com.sun.source", "com.sun.xml.internal.dtdparser", "com.sun.xml.internal.rngom", "com.sun.xml.internal.xsom", "org.relaxng", "edu.rice.cs.mint.comp.com.sun.tools.javac", "edu.rice.cs.mint.comp.com.sun.tools.javac.tree", "edu.rice.cs.mint.comp.com.sun.tools.javac.comp", "edu.rice.cs.mint.comp.com.sun.tools.javac.main", "edu.rice.cs.mint", "edu.rice.cs.mint.comp", "edu.rice.cs.mint.runtime", "edu.rice.cs.mint.runtime.mspTree");
        return set;
    }

    @Override
    public Iterable<File> getSearchDirectories() {
        return IterUtil.singleton(FileOps.getDrJavaFile().getParentFile());
    }

    @Override
    public Iterable<File> getSearchFiles() {
        SizedIterable<File> files = IterUtil.asIterable(new File("/C:/Program Files/JavaPLT/JavaMint/langtools/dist/lib/classes.jar"), new File("/C:/Program Files/JavaPLT/JavaMint/langtools/dist/lib/tools.jar"), new File("/C:/Program Files/JavaMint/langtools/dist/lib/classes.jar"), new File("/C:/Program Files/JavaMint/langtools/dist/lib/tools.jar"), new File("/usr/local/JavaMint/langtools/dist/lib/classes.jar"), new File("/usr/local/JavaMint/langtools/dist/lib/tools.jar"));
        try {
            String mint_home = System.getenv("MINT_HOME");
            if (mint_home != null) {
                files = IterUtil.compose(files, new File(new File(mint_home), "langtools/dist/lib/classes.jar"));
                files = IterUtil.compose(files, new File(new File(mint_home), "langtools/dist/lib/tools.jar"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        files = IterUtil.compose(FileOps.getDrJavaFile(), files);
        return files;
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public boolean containsCompiler(File f) {
        return JDKDescriptor.Util.exists(f, "edu/rice/cs/mint/comp/TransStaging.class", "edu/rice/cs/mint/comp/com/sun/source/tree/BracketExprTree.class", "edu/rice/cs/mint/comp/com/sun/source/tree/BracketStatTree.class", "edu/rice/cs/mint/comp/com/sun/source/tree/EscapeExprTree.class", "edu/rice/cs/mint/comp/com/sun/source/tree/EscapeStatTree.class");
    }

    @Override
    public JavaVersion.FullVersion guessVersion(File f) {
        return JavaVersion.parseFullVersion(JavaVersion.JAVA_6.fullVersion().versionString(), "Rice JavaPLT", "Rice JavaPLT", f);
    }

    @Override
    public String getAdapterForCompiler() {
        return "edu.rice.cs.drjava.model.compiler.MintCompiler";
    }

    @Override
    public String getAdapterForDebugger() {
        return null;
    }

    @Override
    public JavaVersion getMinimumMajorVersion() {
        return JavaVersion.JAVA_6;
    }

    @Override
    public Iterable<File> getAdditionalCompilerFiles(File compiler) throws FileNotFoundException {
        return IterUtil.empty();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " --> " + this.getAdapterForCompiler();
    }
}

