/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleAction;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.util.UnexpectedException;
import javax.swing.text.BadLocationException;

class ActionStartPrevLinePlusMultiline
extends IndentRuleAction {
    private String[] _suffices;
    private int _line = 0;
    private int _offset = 0;

    public ActionStartPrevLinePlusMultiline(String[] suffices, int line, int position) {
        this._suffices = suffices;
        if (line < 0 || line >= suffices.length) {
            throw new IllegalArgumentException("The specified line was outside the bounds of the specified array.");
        }
        this._line = line;
        if (position < 0 || position > suffices[line].length()) {
            throw new IllegalArgumentException("The specified position was not within the bounds of the specified line.");
        }
        for (int i = 0; i < line; ++i) {
            this._offset += this._suffices[i].length();
        }
        this._offset += position;
    }

    @Override
    public boolean indentLine(AbstractDJDocument doc, Indenter.IndentReason reason) {
        super.indentLine(doc, reason);
        try {
            int here = doc.getCurrentLocation();
            int startLine = doc._getLineStartPos(here);
            if (startLine > 0) {
                int startPrevLine = doc._getLineStartPos(startLine - 1);
                int firstChar = doc._getLineFirstCharPos(startPrevLine);
                String prefix = doc.getText(startPrevLine, firstChar - startPrevLine);
                for (int i = 0; i < this._suffices.length; ++i) {
                    doc.setTab(prefix + this._suffices[i], here);
                    here += prefix.length() + this._suffices[i].length();
                }
                int newPos = startLine + this._offset + prefix.length() * (this._line + 1);
                doc.setCurrentLocation(newPos);
            } else {
                for (int i = 0; i < this._suffices.length; ++i) {
                    doc.setTab(this._suffices[i], here);
                    here += this._suffices[i].length();
                }
            }
            return false;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }
}

