/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl.newjvm;

import edu.rice.cs.dynamicjava.interpreter.EvaluatorException;
import edu.rice.cs.dynamicjava.interpreter.InterpreterException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;

public abstract class InterpretResult
implements Serializable {
    public abstract <T> T apply(Visitor<T> var1);

    public static InterpretResult busy() {
        return BusyResult.INSTANCE;
    }

    public static InterpretResult exception(InterpreterException e) {
        return new ExceptionResult(e);
    }

    public static InterpretResult unexpectedException(Throwable t) {
        return new UnexpectedExceptionResult(t);
    }

    public static InterpretResult noValue() {
        return NoValueResult.INSTANCE;
    }

    public static InterpretResult stringValue(String s) {
        return new StringValueResult(s);
    }

    public static InterpretResult charValue(Character c) {
        return new CharValueResult(c);
    }

    public static InterpretResult numberValue(Number n) {
        return new NumberValueResult(n);
    }

    public static InterpretResult booleanValue(Boolean b) {
        return new BooleanValueResult(b);
    }

    public static InterpretResult objectValue(String objS, String objTS) {
        return new ObjectValueResult(objS, objTS);
    }

    private static class ObjectValueResult
    extends InterpretResult {
        private final String _objString;
        private final String _objTypeStr;

        public ObjectValueResult(String objString, String objTypeStr) {
            this._objString = objString;
            this._objTypeStr = objTypeStr;
        }

        @Override
        public <T> T apply(Visitor<T> v) {
            return v.forObjectValue(this._objString, this._objTypeStr);
        }
    }

    private static class BooleanValueResult
    extends InterpretResult {
        private final Boolean _val;

        public BooleanValueResult(Boolean val) {
            this._val = val;
        }

        @Override
        public <T> T apply(Visitor<T> v) {
            return v.forBooleanValue(this._val);
        }
    }

    private static class NumberValueResult
    extends InterpretResult {
        private final Number _val;

        public NumberValueResult(Number val) {
            this._val = val;
        }

        @Override
        public <T> T apply(Visitor<T> v) {
            return v.forNumberValue(this._val);
        }
    }

    private static class CharValueResult
    extends InterpretResult {
        private final Character _val;

        public CharValueResult(Character val) {
            this._val = val;
        }

        @Override
        public <T> T apply(Visitor<T> v) {
            return v.forCharValue(this._val);
        }
    }

    private static class StringValueResult
    extends InterpretResult {
        private final String _val;

        public StringValueResult(String val) {
            this._val = val;
        }

        @Override
        public <T> T apply(Visitor<T> v) {
            return v.forStringValue(this._val);
        }
    }

    private static class NoValueResult
    extends InterpretResult {
        public static final NoValueResult INSTANCE = new NoValueResult();

        private NoValueResult() {
        }

        @Override
        public <T> T apply(Visitor<T> v) {
            return v.forNoValue();
        }
    }

    private static class UnexpectedExceptionResult
    extends InterpretResult {
        private final Throwable _t;

        public UnexpectedExceptionResult(Throwable t) {
            this._t = t;
        }

        @Override
        public <T> T apply(Visitor<T> v) {
            return v.forUnexpectedException(this._t);
        }
    }

    private static class ExceptionResult
    extends InterpretResult {
        private final String _msg;
        private final StackTraceElement[] _stackTrace;

        public ExceptionResult(InterpreterException e) {
            if (e instanceof EvaluatorException) {
                this._msg = e.getMessage();
                this._stackTrace = e.getCause().getStackTrace();
            } else {
                StringWriter msg = new StringWriter();
                e.printUserMessage(new PrintWriter(msg));
                this._msg = msg.toString().trim();
                this._stackTrace = null;
            }
        }

        @Override
        public <T> T apply(Visitor<T> v) {
            if (this._stackTrace != null) {
                return v.forEvalException(this._msg, this._stackTrace);
            }
            return v.forException(this._msg);
        }
    }

    private static class BusyResult
    extends InterpretResult {
        public static final BusyResult INSTANCE = new BusyResult();

        private BusyResult() {
        }

        @Override
        public <T> T apply(Visitor<T> v) {
            return v.forBusy();
        }
    }

    public static interface Visitor<T> {
        public T forNoValue();

        public T forStringValue(String var1);

        public T forCharValue(Character var1);

        public T forNumberValue(Number var1);

        public T forBooleanValue(Boolean var1);

        public T forObjectValue(String var1, String var2);

        public T forException(String var1);

        public T forEvalException(String var1, StackTraceElement[] var2);

        public T forUnexpectedException(Throwable var1);

        public T forBusy();
    }
}

